/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.publisher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.governanceengine.api.events.GovernanceEngineEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceEnginePublisher {
    private static final Logger log = LoggerFactory.getLogger(GovernanceEnginePublisher.class);
    private OpenMetadataTopicConnector connector;
    private AuditLog auditLog;

    public GovernanceEnginePublisher(OpenMetadataTopicConnector openMetadataTopicConnector, AuditLog auditLog) {
        this.connector = openMetadataTopicConnector;
        this.auditLog = auditLog;
    }

    public void publishEvent(GovernanceEngineEvent event) {
        try {
            this.connector.sendEvent(this.eventToString(event));
            log.info("[Governance Engine]event send");
        }
        catch (ConnectorCheckedException e) {
            log.error("[Governance Engine] Unable to send event {}", (Object)event);
        }
    }

    private String eventToString(GovernanceEngineEvent engineEvent) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)engineEvent);
        }
        catch (JsonProcessingException e) {
            log.error("[Governance Engine] Unable to map the event {} to string.", (Object)engineEvent);
            return null;
        }
    }
}

