/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.connectors.outtopic.GovernanceEngineOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.governanceengine.connectors.outtopic.GovernanceEngineOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.outtopic.GovernanceEngineOMRSTopicListener;
import org.odpi.openmetadata.accessservices.governanceengine.outtopic.GovernanceEngineOutTopicPublisher;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GovernanceEngineAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private GovernanceEngineInstance instance = null;
    private String serverName = null;
    private GovernanceEngineOutTopicPublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", GovernanceEngineAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = super.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = super.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = super.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new GovernanceEngineInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), accessServiceConfig.getAccessServiceOutTopic());
            this.serverName = this.instance.getServerName();
            Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
            if (outTopicEventBusConnection != null) {
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), GovernanceEngineOutTopicServerProvider.class.getName(), auditLog);
                GovernanceEngineOutTopicServerConnector outTopicServerConnector = (GovernanceEngineOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, GovernanceEngineOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), "initialize");
                this.eventPublisher = new GovernanceEngineOutTopicPublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog);
                this.registerWithEnterpriseTopic(AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new GovernanceEngineOMRSTopicListener(AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), serverUserName, this.instance.getMetadataElementHandler(), this.instance.getGovernanceActionHandler(), this.eventPublisher, repositoryConnector.getRepositoryHelper(), outTopicAuditLog), auditLog);
            }
            auditLog.logMessage("initialize", GovernanceEngineAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}));
        }
        catch (OMAGConfigurationErrorException error) {
            auditLog.logException("initialize", GovernanceEngineAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            throw error;
        }
        catch (Throwable error) {
            auditLog.logException("initialize", GovernanceEngineAuditCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), error.getMessage()}), error);
            throw new OMAGConfigurationErrorException(GovernanceEngineErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), this.serverName, error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "initialize", error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        this.auditLog.logMessage("shutdown", GovernanceEngineAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

