/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import org.odpi.openmetadata.accessservices.governanceengine.handlers.GovernanceConfigurationHandler;
import org.odpi.openmetadata.accessservices.governanceengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceServiceRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class GovernanceConfigRESTServices {
    private static GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceConfigRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createGovernanceEngine(String serverName, String userId, String typeName, NewGovernanceEngineRequestBody requestBody) {
        String methodName = "createGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceEngine");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "createGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceEngine");
            if (requestBody != null) {
                response.setGUID(handler.createGovernanceEngine(userId, typeName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription()));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceEngine", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementResponse getGovernanceEngineByGUID(String serverName, String userId, String guid) {
        String methodName = "getGovernanceEngineByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineByGUID");
        GovernanceEngineElementResponse response = new GovernanceEngineElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceEngineByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineByGUID");
            response.setElement(handler.getGovernanceEngineByGUID(userId, guid));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getGovernanceEngineByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementResponse getGovernanceEngineByName(String serverName, String userId, String name) {
        String methodName = "getGovernanceEngineByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineByName");
        GovernanceEngineElementResponse response = new GovernanceEngineElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceEngineByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineByName");
            response.setElement(handler.getGovernanceEngineByName(userId, name));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getGovernanceEngineByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineElementsResponse getAllGovernanceEngines(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllGovernanceEngines";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllGovernanceEngines");
        GovernanceEngineElementsResponse response = new GovernanceEngineElementsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getAllGovernanceEngines");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllGovernanceEngines");
            response.setElements(handler.getAllGovernanceEngines(userId, startingFrom, maximumResults));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAllGovernanceEngines", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceEngine(String serverName, String userId, String guid, UpdateGovernanceEngineRequestBody requestBody) {
        String methodName = "updateGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "updateGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceEngine");
            if (requestBody != null) {
                handler.updateGovernanceEngine(userId, guid, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getTypeDescription(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceEngine", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceEngine(String serverName, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteGovernanceEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "deleteGovernanceEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceEngine");
            if (requestBody != null) {
                handler.deleteGovernanceEngine(userId, guid, requestBody.getQualifiedName());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteGovernanceEngine", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "deleteGovernanceEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceService(String serverName, String userId, String typeName, NewGovernanceServiceRequestBody requestBody) {
        String methodName = "createGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceService");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "createGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceService");
            if (requestBody != null) {
                response.setGUID(handler.createGovernanceService(userId, typeName, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getConnection()));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceService", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementResponse getGovernanceServiceByGUID(String serverName, String userId, String guid) {
        String methodName = "getGovernanceServiceByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceByGUID");
        GovernanceServiceElementResponse response = new GovernanceServiceElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceServiceByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceByGUID");
            response.setElement(handler.getGovernanceServiceByGUID(userId, guid));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getGovernanceServiceByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementResponse getGovernanceServiceByName(String serverName, String userId, String name) {
        String methodName = "getGovernanceServiceByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceByName");
        GovernanceServiceElementResponse response = new GovernanceServiceElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceServiceByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceByName");
            response.setElement(handler.getGovernanceServiceByName(userId, name));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getGovernanceServiceByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceServiceElementsResponse getAllGovernanceServices(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllGovernanceServices");
        GovernanceServiceElementsResponse response = new GovernanceServiceElementsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getAllGovernanceServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllGovernanceServices");
            response.setElements(handler.getAllGovernanceServices(userId, startingFrom, maximumResults));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAllGovernanceServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getGovernanceServiceRegistrations(String serverName, String userId, String governanceServiceGUID) {
        String methodName = "getGovernanceServiceRegistrations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceServiceRegistrations");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getGovernanceServiceRegistrations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceServiceRegistrations");
            response.setGUIDs(handler.getGovernanceServiceRegistrations(userId, governanceServiceGUID));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getGovernanceServiceRegistrations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceService(String serverName, String userId, String guid, UpdateGovernanceServiceRequestBody requestBody) {
        String methodName = "updateGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "updateGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceService");
            if (requestBody != null) {
                handler.updateGovernanceService(userId, guid, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getConnection(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceService", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "updateGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteGovernanceService(String serverName, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGovernanceService");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "deleteGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGovernanceService");
            if (requestBody != null) {
                handler.deleteGovernanceService(userId, guid, requestBody.getQualifiedName());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteGovernanceService", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "deleteGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse registerGovernanceServiceWithEngine(String serverName, String userId, String governanceEngineGUID, GovernanceServiceRegistrationRequestBody requestBody) {
        String methodName = "registerGovernanceServiceWithEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "registerGovernanceServiceWithEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "registerGovernanceServiceWithEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "registerGovernanceServiceWithEngine");
            if (requestBody != null) {
                handler.registerGovernanceServiceWithEngine(userId, governanceEngineGUID, requestBody.getGovernanceServiceGUID(), requestBody.getRequestType(), requestBody.getRequestParameters());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "registerGovernanceServiceWithEngine", serverName);
            }
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "registerGovernanceServiceWithEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredGovernanceServiceResponse getRegisteredGovernanceService(String serverName, String userId, String governanceEngineGUID, String governanceServiceGUID) {
        String methodName = "getRegisteredGovernanceService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredGovernanceService");
        RegisteredGovernanceServiceResponse response = new RegisteredGovernanceServiceResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getRegisteredGovernanceService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredGovernanceService");
            response.setRegisteredGovernanceService(handler.getRegisteredGovernanceService(userId, governanceEngineGUID, governanceServiceGUID));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getRegisteredGovernanceService", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getRegisteredGovernanceServices(String serverName, String userId, String governanceEngineGUID, int startingFrom, int maximumResults) {
        String methodName = "getRegisteredGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredGovernanceServices");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getRegisteredGovernanceServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredGovernanceServices");
            response.setGUIDs(handler.getRegisteredGovernanceServices(userId, governanceEngineGUID, startingFrom, maximumResults));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getRegisteredGovernanceServices", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterGovernanceServiceRequestFromEngine(String serverName, String userId, String requestType, String governanceEngineGUID, String governanceServiceGUID, NullRequestBody requestBody) {
        String methodName = "unregisterGovernanceServiceRequestFromEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterGovernanceServiceRequestFromEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "unregisterGovernanceServiceRequestFromEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterGovernanceServiceRequestFromEngine");
            handler.unregisterGovernanceServiceRequestFromEngine(userId, requestType, governanceEngineGUID, governanceServiceGUID);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "unregisterGovernanceServiceRequestFromEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterGovernanceServiceFromEngine(String serverName, String userId, String governanceEngineGUID, String governanceServiceGUID, NullRequestBody requestBody) {
        String methodName = "unregisterGovernanceServiceFromEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterGovernanceServiceFromEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "unregisterGovernanceServiceFromEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterGovernanceServiceFromEngine");
            handler.unregisterGovernanceServiceFromEngine(userId, governanceEngineGUID, governanceServiceGUID);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "unregisterGovernanceServiceFromEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

