/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import org.odpi.openmetadata.accessservices.governanceengine.handlers.GovernanceConfigurationHandler;
import org.odpi.openmetadata.accessservices.governanceengine.handlers.MetadataElementHandler;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstance;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;

class GovernanceEngineInstanceHandler
extends OMASServiceInstanceHandler {
    GovernanceEngineInstanceHandler() {
        super(AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName());
        GovernanceEngineRegistration.registerAccessService();
    }

    GovernanceConfigurationHandler getGovernanceConfigurationHandler(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GovernanceEngineInstance instance = (GovernanceEngineInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getGovernanceConfigurationHandler();
        }
        return null;
    }

    MetadataElementHandler<OpenMetadataElement> getMetadataElementHandler(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GovernanceEngineInstance instance = (GovernanceEngineInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getMetadataElementHandler();
        }
        return null;
    }

    GovernanceActionHandler<GovernanceActionElement> getGovernanceActionHandler(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        GovernanceEngineInstance instance = (GovernanceEngineInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getGovernanceActionHandler();
        }
        return null;
    }
}

