/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.converters;

import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceEngineOMASConverter;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceActionTypeConverter<B>
extends GovernanceEngineOMASConverter<B> {
    public GovernanceActionTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, null, methodName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof GovernanceActionTypeElement) {
                InstanceProperties instanceProperties;
                GovernanceActionTypeElement bean = (GovernanceActionTypeElement)returnBean;
                GovernanceActionTypeProperties actionTypeProperties = new GovernanceActionTypeProperties();
                if (entity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                    instanceProperties = new InstanceProperties(entity.getProperties());
                    actionTypeProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    actionTypeProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    actionTypeProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    actionTypeProperties.setDisplayName(this.removeName(instanceProperties));
                    actionTypeProperties.setDescription(this.removeDescription(instanceProperties));
                    actionTypeProperties.setOwner(this.removeOwner(instanceProperties));
                    actionTypeProperties.setOwnerCategory(this.removeOwnerCategoryFromProperties(instanceProperties));
                    actionTypeProperties.setSupportedGuards(this.removeSupportedGuards(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    actionTypeProperties.setRequestType(this.removeRequestType(instanceProperties));
                    actionTypeProperties.setRequestParameters(this.removeRequestParameters(instanceProperties));
                    EntityProxy entityProxy = relationship.getEntityTwoProxy();
                    if (entityProxy != null) {
                        actionTypeProperties.setGovernanceEngineGUID(entityProxy.getGUID());
                    }
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

