/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceEngineOMASConverter;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceServiceProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceActionConverter<B>
extends GovernanceEngineOMASConverter<B> {
    public GovernanceActionConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceActionElement) {
                GovernanceActionElement bean = (GovernanceActionElement)returnBean;
                GovernanceActionProperties properties = new GovernanceActionProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    properties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    properties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    properties.setDisplayName(this.removeDisplayName(instanceProperties));
                    properties.setDescription(this.removeDescription(instanceProperties));
                    properties.setMandatoryGuards(this.removeMandatoryGuards(instanceProperties));
                    properties.setReceivedGuards(this.removeReceivedGuards(instanceProperties));
                    properties.setActionStatus(this.removeActionStatus("actionStatus", instanceProperties));
                    properties.setStartTime(this.removeStartDate(instanceProperties));
                    properties.setProcessingEngineUserId(this.removeProcessingEngineUserId(instanceProperties));
                    properties.setCompletionTime(this.removeCompletionDate(instanceProperties));
                    properties.setCompletionGuards(this.removeCompletionGuards(instanceProperties));
                    properties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    if (relationships != null) {
                        ArrayList<RequestSourceElement> requestSourceElements = new ArrayList<RequestSourceElement>();
                        ArrayList<ActionTargetElement> actionTargetElements = new ArrayList<ActionTargetElement>();
                        for (Relationship relationship : relationships) {
                            String requestSourceGUID;
                            if (relationship == null || relationship.getType() == null) continue;
                            String actualTypeName = relationship.getType().getTypeDefName();
                            instanceProperties = new InstanceProperties(relationship.getProperties());
                            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "GovernanceActionExecutor")) {
                                properties.setRequestType(this.removeRequestType(instanceProperties));
                                properties.setRequestParameters(this.removeRequestParameters(instanceProperties));
                                EntityProxy entityProxy = relationship.getEntityTwoProxy();
                                properties.setGovernanceEngineGUID(entityProxy.getGUID());
                                if (entityProxy.getUniqueProperties() == null) continue;
                                properties.setGovernanceEngineName(this.getQualifiedName(entityProxy.getUniqueProperties()));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "TargetForAction")) {
                                ActionTargetElement actionTargetElement = new ActionTargetElement();
                                actionTargetElement.setActionTargetName(this.removeActionTargetName(instanceProperties));
                                actionTargetElement.setStatus(this.removeActionStatus("status", instanceProperties));
                                actionTargetElement.setStartDate(this.removeStartDate(instanceProperties));
                                actionTargetElement.setCompletionDate(this.removeCompletionDate(instanceProperties));
                                String actionTargetGUID = relationship.getEntityTwoProxy().getGUID();
                                if (actionTargetGUID != null) {
                                    actionTargetElement.setActionTargetGUID(actionTargetGUID);
                                    actionTargetElement.setTargetElement(this.getOpenMetadataElement(actionTargetGUID, supplementaryEntities));
                                }
                                actionTargetElements.add(actionTargetElement);
                                continue;
                            }
                            if (!this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, "GovernanceActionRequestSource") || (requestSourceGUID = relationship.getEntityOneProxy().getGUID()) == null) continue;
                            RequestSourceElement requestSourceElement = new RequestSourceElement();
                            requestSourceElement.setRequestSourceElement(this.getOpenMetadataElement(requestSourceGUID, supplementaryEntities));
                            instanceProperties = new InstanceProperties(relationship.getProperties());
                            requestSourceElement.setRequestSourceName(this.removeRequestSourceName(instanceProperties));
                            requestSourceElement.setOriginGovernanceService(this.removeOriginGovernanceService(instanceProperties));
                            requestSourceElement.setOriginGovernanceEngine(this.removeOriginGovernanceEngine(instanceProperties));
                            requestSourceElements.add(requestSourceElement);
                        }
                        if (!requestSourceElements.isEmpty()) {
                            properties.setRequestSourceElements(requestSourceElements);
                        }
                        if (!actionTargetElements.isEmpty()) {
                            properties.setActionTargetElements(actionTargetElements);
                        }
                    }
                    bean.setProperties(properties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            } else {
                this.handleUnexpectedBeanClass(beanClass.getName(), GovernanceServiceProperties.class.getName(), methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

