/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.converters.RelatedElementConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.RelatedElementsConverter;
import org.odpi.openmetadata.accessservices.governanceengine.handlers.MetadataElementBuilder;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitivePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class MetadataElementHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    private PropertyHelper propertyHelper = new PropertyHelper();
    private RelatedElementsConverter<RelatedMetadataElements> relatedElementsConverter;
    private RelatedElementConverter<RelatedMetadataElement> relatedElementConverter;

    public MetadataElementHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.relatedElementsConverter = new RelatedElementsConverter(repositoryHelper, serviceName, serverName);
        this.relatedElementConverter = new RelatedElementConverter(repositoryHelper, serviceName, serverName);
    }

    public B getMetadataElementByGUID(String userId, String elementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        return (B)this.getBeanFromRepository(userId, elementGUID, "elementGUID", "OpenMetadataRoot", methodName);
    }

    public B getMetadataElementByUniqueName(String userId, String uniqueName, String uniqueNameParameterName, String uniqueNamePropertyName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "uniqueName";
        String namePropertyName = "uniqueNamePropertyName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        this.invalidParameterHandler.validateName(uniqueNamePropertyName, "uniqueNamePropertyName", methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (uniqueNameParameterName != null) {
            this.invalidParameterHandler.validateName(uniqueName, uniqueNameParameterName, methodName);
        } else {
            this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        }
        return (B)this.getBeanByUniqueName(userId, uniqueName, uniqueNameParameterName, uniqueNamePropertyName, "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", methodName);
    }

    public String getMetadataElementGUIDByUniqueName(String userId, String uniqueName, String uniqueNameParameterName, String uniqueNamePropertyName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "uniqueName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (uniqueNameParameterName != null) {
            this.invalidParameterHandler.validateName(uniqueName, uniqueNameParameterName, methodName);
        } else {
            this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        }
        return this.getBeanGUIDByUniqueName(userId, uniqueName, uniqueNameParameterName, uniqueNamePropertyName, "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", methodName);
    }

    public List<B> findMetadataElementsWithString(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.findBeans(userId, searchString, "searchString", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", null, startFrom, pageSize, methodName);
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String userId, String elementGUID, int startingAtEnd, String relationshipTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "elementGUID";
        String typeNameParameterName = "relationshipTypeName";
        String otherEndGUIDParameterName = "otherEnd.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = null;
        if (relationshipTypeName != null) {
            relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        }
        int attachmentAtEnd = 0;
        if (startingAtEnd == 1) {
            attachmentAtEnd = 2;
        } else if (startingAtEnd == 2) {
            attachmentAtEnd = 1;
        }
        List relationships = super.getAttachmentLinks(userId, elementGUID, "elementGUID", "OpenMetadataRoot", relationshipTypeGUID, relationshipTypeName, null, "OpenMetadataRoot", attachmentAtEnd, startFrom, pageSize, methodName);
        if (relationships != null) {
            ArrayList<RelatedMetadataElement> results = new ArrayList<RelatedMetadataElement>();
            for (Relationship relationship : relationships) {
                EntityDetail otherEndEntity;
                EntityProxy otherEnd;
                if (relationship == null || (otherEnd = this.repositoryHandler.getOtherEnd(elementGUID, relationship)) == null || (otherEndEntity = this.getEntityFromRepository(userId, otherEnd.getGUID(), "otherEnd.getGUID()", "OpenMetadataRoot", methodName)) == null) continue;
                results.add(this.relatedElementConverter.getNewBean(RelatedMetadataElement.class, otherEndEntity, relationship, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> findMetadataElements(String userId, String metadataElementTypeName, List<String> metadataElementSubtypeName, org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications searchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return super.findBeans(userId, metadataElementTypeName, metadataElementSubtypeName, this.getSearchProperties(searchProperties), this.getInstanceStatuses(limitResultsByStatus), this.getSearchClassifications(searchClassifications), null, sequencingProperty, this.getSequencingOrder(sequencingOrder), startingFrom, pageSize, methodName);
    }

    private SearchProperties getSearchProperties(org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties gafSearchProperties) throws InvalidParameterException {
        if (gafSearchProperties != null) {
            SearchProperties omrsSearchProperties = new SearchProperties();
            omrsSearchProperties.setConditions(this.getPropertyConditions(gafSearchProperties.getConditions()));
            omrsSearchProperties.setMatchCriteria(this.getMatchCriteria(gafSearchProperties.getMatchCriteria()));
            return omrsSearchProperties;
        }
        return null;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications getSearchClassifications(SearchClassifications gafSearchClassifications) throws InvalidParameterException {
        if (gafSearchClassifications != null) {
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications omrsSearchClassifications = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications();
            if (gafSearchClassifications.getConditions() != null && !gafSearchClassifications.getConditions().isEmpty()) {
                ArrayList<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition> omrsClassificationConditions = new ArrayList<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition>();
                for (ClassificationCondition gafClassificationCondition : gafSearchClassifications.getConditions()) {
                    org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition omrsClassificationCondition = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition();
                    omrsClassificationCondition.setName(gafClassificationCondition.getName());
                    omrsClassificationCondition.setMatchProperties(this.getSearchProperties(gafClassificationCondition.getSearchProperties()));
                    omrsClassificationConditions.add(omrsClassificationCondition);
                }
                if (!omrsClassificationConditions.isEmpty()) {
                    omrsSearchClassifications.setConditions(omrsClassificationConditions);
                }
            }
            omrsSearchClassifications.setMatchCriteria(this.getMatchCriteria(gafSearchClassifications.getMatchCriteria()));
        }
        return null;
    }

    private List<PropertyCondition> getPropertyConditions(List<org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition> gafPropertyConditions) throws InvalidParameterException {
        if (gafPropertyConditions != null && !gafPropertyConditions.isEmpty()) {
            for (org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition propertyCondition : gafPropertyConditions) {
                if (propertyCondition == null) continue;
                PropertyCondition omrsPropertyCondition = new PropertyCondition();
                omrsPropertyCondition.setProperty(propertyCondition.getProperty());
                omrsPropertyCondition.setOperator(this.getPropertyComparisonOperator(propertyCondition.getOperator()));
                omrsPropertyCondition.setValue(this.getInstancePropertyValue(propertyCondition.getValue()));
                omrsPropertyCondition.setNestedConditions(this.getSearchProperties(propertyCondition.getNestedConditions()));
            }
        }
        return null;
    }

    private InstancePropertyValue getInstancePropertyValue(PropertyValue propertyValue) throws InvalidParameterException {
        if (propertyValue != null) {
            String methodName = "getInstancePropertyValue";
            String typeParameterName = "propertyValue.getTypeName()";
            AttributeTypeDef typeDef = this.repositoryHelper.getAttributeTypeDefByName(this.serviceName, propertyValue.getTypeName());
            this.invalidParameterHandler.validateObject((Object)typeDef, "propertyValue.getTypeName()", "getInstancePropertyValue");
            if (propertyValue instanceof ArrayPropertyValue) {
                ArrayPropertyValue gafPropertyValue = (ArrayPropertyValue)propertyValue;
                return this.getArrayPropertyValue(typeDef, gafPropertyValue.getArrayCount(), this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getArrayValues()));
            }
            if (propertyValue instanceof EnumPropertyValue) {
                EnumPropertyValue gafPropertyValue = (EnumPropertyValue)propertyValue;
                return this.getEnumPropertyValue(typeDef, gafPropertyValue.getSymbolicName());
            }
            if (propertyValue instanceof MapPropertyValue) {
                MapPropertyValue gafPropertyValue = (MapPropertyValue)propertyValue;
                return this.getMapPropertyValue(typeDef, this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getMapValues()));
            }
            if (propertyValue instanceof PrimitivePropertyValue) {
                PrimitivePropertyValue gafPropertyValue = (PrimitivePropertyValue)propertyValue;
                return this.getPrimitivePropertyValue(typeDef, gafPropertyValue.getPrimitiveDefCategory(), gafPropertyValue.getPrimitiveValue());
            }
            if (propertyValue instanceof org.odpi.openmetadata.frameworks.governanceaction.search.StructPropertyValue) {
                org.odpi.openmetadata.frameworks.governanceaction.search.StructPropertyValue gafPropertyValue = (org.odpi.openmetadata.frameworks.governanceaction.search.StructPropertyValue)propertyValue;
                return this.getStructPropertyValue(typeDef, this.propertyHelper.getElementPropertiesAsMap(gafPropertyValue.getAttributes()));
            }
        }
        return null;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue getArrayPropertyValue(AttributeTypeDef typeDef, int arrayCount, Map<String, Object> arrayValues) throws InvalidParameterException {
        String methodName = "getArrayPropertyValue";
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue omrsPropertyValue = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue();
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.ARRAY);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        omrsPropertyValue.setArrayCount(arrayCount);
        try {
            omrsPropertyValue.setArrayValues(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, arrayValues, "getArrayPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue getEnumPropertyValue(AttributeTypeDef typeDef, String symbolicName) throws InvalidParameterException {
        EnumDef enumDef;
        List enumElementDefs;
        String methodName = "getEnumPropertyValue";
        String symbolicNameParameterName = "symbolicName";
        String propertyParameterName = "omrsPropertyValue";
        this.invalidParameterHandler.validateName(symbolicName, "symbolicName", "getEnumPropertyValue");
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue omrsPropertyValue = null;
        if (typeDef instanceof EnumDef && (enumElementDefs = (enumDef = (EnumDef)typeDef).getElementDefs()) != null && !enumElementDefs.isEmpty()) {
            for (EnumElementDef enumElementDef : enumElementDefs) {
                if (enumElementDef == null || !symbolicName.equals(enumElementDef.getValue())) continue;
                omrsPropertyValue = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue();
                omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.ENUM);
                omrsPropertyValue.setTypeGUID(typeDef.getGUID());
                omrsPropertyValue.setTypeName(typeDef.getName());
                omrsPropertyValue.setSymbolicName(symbolicName);
                omrsPropertyValue.setOrdinal(enumElementDef.getOrdinal());
                omrsPropertyValue.setDescription(enumElementDef.getDescription());
            }
        }
        this.invalidParameterHandler.validateObject(omrsPropertyValue, "omrsPropertyValue", "getEnumPropertyValue");
        return omrsPropertyValue;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue getMapPropertyValue(AttributeTypeDef typeDef, Map<String, Object> mapValues) throws InvalidParameterException {
        String methodName = "getMapPropertyValue";
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue omrsPropertyValue = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue();
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.MAP);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        try {
            omrsPropertyValue.setMapValues(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, mapValues, "getMapPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue getPrimitivePropertyValue(AttributeTypeDef typeDef, PrimitiveDefCategory primitiveDefCategory, Object primitiveValue) throws InvalidParameterException {
        String methodName = "getPrimitivePropertyValue";
        String valueParameterName = "primitiveValue";
        String categoryParameterName = "primitiveDefCategory";
        this.invalidParameterHandler.validateObject((Object)primitiveDefCategory, "primitiveDefCategory", "getPrimitivePropertyValue");
        this.invalidParameterHandler.validateObject(primitiveValue, "primitiveValue", "getPrimitivePropertyValue");
        org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue omrsPropertyValue = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue();
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.PRIMITIVE);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        omrsPropertyValue.setPrimitiveDefCategory(this.getPrimitiveDefCategory(primitiveDefCategory));
        omrsPropertyValue.setPrimitiveValue(primitiveValue);
        return omrsPropertyValue;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory getPrimitiveDefCategory(PrimitiveDefCategory gafPrimitiveDefCategory) {
        if (gafPrimitiveDefCategory != null) {
            switch (gafPrimitiveDefCategory) {
                case OM_PRIMITIVE_TYPE_UNKNOWN: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
                }
                case OM_PRIMITIVE_TYPE_BOOLEAN: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN;
                }
                case OM_PRIMITIVE_TYPE_BYTE: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE;
                }
                case OM_PRIMITIVE_TYPE_CHAR: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR;
                }
                case OM_PRIMITIVE_TYPE_SHORT: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT;
                }
                case OM_PRIMITIVE_TYPE_INT: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT;
                }
                case OM_PRIMITIVE_TYPE_LONG: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG;
                }
                case OM_PRIMITIVE_TYPE_FLOAT: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT;
                }
                case OM_PRIMITIVE_TYPE_DOUBLE: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE;
                }
                case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER;
                }
                case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL;
                }
                case OM_PRIMITIVE_TYPE_STRING: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING;
                }
                case OM_PRIMITIVE_TYPE_DATE: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE;
                }
            }
        }
        return null;
    }

    private StructPropertyValue getStructPropertyValue(AttributeTypeDef typeDef, Map<String, Object> attributes) throws InvalidParameterException {
        String methodName = "getStructPropertyValue";
        StructPropertyValue omrsPropertyValue = new StructPropertyValue();
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.STRUCT);
        omrsPropertyValue.setTypeGUID(typeDef.getGUID());
        omrsPropertyValue.setTypeName(typeDef.getName());
        try {
            omrsPropertyValue.setAttributes(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, attributes, "getStructPropertyValue"));
        }
        catch (OCFCheckedExceptionBase error) {
            String parameterName = "searchProperties";
            throw new InvalidParameterException(error, "searchProperties");
        }
        return omrsPropertyValue;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria getMatchCriteria(MatchCriteria gafMatchCriteria) {
        if (gafMatchCriteria != null) {
            switch (gafMatchCriteria) {
                case ALL: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.ALL;
                }
                case ANY: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.ANY;
                }
                case NONE: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria.NONE;
                }
            }
        }
        return null;
    }

    private PropertyComparisonOperator getPropertyComparisonOperator(org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator gafPropertyComparisonOperator) {
        if (gafPropertyComparisonOperator != null) {
            switch (gafPropertyComparisonOperator) {
                case EQ: {
                    return PropertyComparisonOperator.EQ;
                }
                case NEQ: {
                    return PropertyComparisonOperator.NEQ;
                }
                case LT: {
                    return PropertyComparisonOperator.LT;
                }
                case LTE: {
                    return PropertyComparisonOperator.LTE;
                }
                case GT: {
                    return PropertyComparisonOperator.GT;
                }
                case GTE: {
                    return PropertyComparisonOperator.GTE;
                }
                case IN: {
                    return PropertyComparisonOperator.IN;
                }
                case IS_NULL: {
                    return PropertyComparisonOperator.IS_NULL;
                }
                case NOT_NULL: {
                    return PropertyComparisonOperator.NOT_NULL;
                }
                case LIKE: {
                    return PropertyComparisonOperator.LIKE;
                }
            }
        }
        return null;
    }

    private org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder getSequencingOrder(SequencingOrder gafSequencingOrder) {
        if (gafSequencingOrder != null) {
            switch (gafSequencingOrder) {
                case ANY: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.ANY;
                }
                case GUID: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.GUID;
                }
                case CREATION_DATE_RECENT: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_RECENT;
                }
                case CREATION_DATE_OLDEST: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.CREATION_DATE_OLDEST;
                }
                case LAST_UPDATE_RECENT: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_RECENT;
                }
                case LAST_UPDATE_OLDEST: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.LAST_UPDATE_OLDEST;
                }
                case PROPERTY_ASCENDING: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_ASCENDING;
                }
                case PROPERTY_DESCENDING: {
                    return org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder.PROPERTY_DESCENDING;
                }
            }
        }
        return null;
    }

    private List<InstanceStatus> getInstanceStatuses(List<ElementStatus> elementStatuses) {
        if (elementStatuses != null) {
            ArrayList<InstanceStatus> instanceStatuses = new ArrayList<InstanceStatus>();
            for (ElementStatus elementStatus : elementStatuses) {
                if (elementStatus == null) continue;
                instanceStatuses.add(this.getInstanceStatus(elementStatus));
            }
            if (!instanceStatuses.isEmpty()) {
                return instanceStatuses;
            }
        }
        return null;
    }

    private InstanceStatus getInstanceStatus(ElementStatus elementStatus) {
        if (elementStatus != null) {
            switch (elementStatus) {
                case UNKNOWN: {
                    return InstanceStatus.UNKNOWN;
                }
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case PREPARED: {
                    return InstanceStatus.PREPARED;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case APPROVED: {
                    return InstanceStatus.APPROVED;
                }
                case REJECTED: {
                    return InstanceStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return InstanceStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return InstanceStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return InstanceStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return InstanceStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return InstanceStatus.STANDBY;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
                case FAILED: {
                    return InstanceStatus.FAILED;
                }
                case DISABLED: {
                    return InstanceStatus.DISABLED;
                }
                case COMPLETE: {
                    return InstanceStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return InstanceStatus.DEPRECATED;
                }
                case OTHER: {
                    return InstanceStatus.OTHER;
                }
            }
        }
        return null;
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String userId, String relationshipTypeName, org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        List relationships = this.findAttachmentLinks(userId, relationshipTypeName, this.getSearchProperties(searchProperties), null, null, sequencingProperty, this.getSequencingOrder(sequencingOrder), startFrom, pageSize, methodName);
        if (relationships != null) {
            ArrayList<RelatedMetadataElements> results = new ArrayList<RelatedMetadataElements>();
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                results.add(this.relatedElementsConverter.getNewRelationshipBean(RelatedMetadataElements.class, relationship, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public String createMetadataElementInStore(String userId, String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementTypeParameterName = "metadataElementTypeName";
        String templateGUIDParameterName = "templateGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(metadataElementTypeName, "metadataElementTypeName", methodName);
        String metadataElementTypeGUID = this.invalidParameterHandler.validateTypeName(metadataElementTypeName, "OpenMetadataRoot", this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.propertyHelper.getElementPropertiesAsMap(properties), this.getInstanceStatus(initialStatus), effectiveFrom, effectiveTo, this.repositoryHelper, this.serviceName, this.serverName);
        if (templateGUID == null) {
            return this.createBeanInRepository(userId, null, null, metadataElementTypeGUID, metadataElementTypeName, null, null, builder, methodName);
        }
        return this.createBeanFromTemplate(userId, null, null, templateGUID, "templateGUID", metadataElementTypeGUID, metadataElementTypeName, null, null, builder, methodName);
    }

    public void updateMetadataElementInStore(String userId, String metadataElementGUID, boolean replaceProperties, ElementProperties properties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.propertyHelper.getElementPropertiesAsMap(properties), this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", builder.getInstanceProperties(methodName), !replaceProperties, methodName);
    }

    public void updateMetadataElementStatusInStore(String userId, String metadataElementGUID, ElementStatus newElementStatus, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String statusParameterName = "newElementStatus";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        super.updateBeanStatusInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", this.getInstanceStatus(newElementStatus), "newElementStatus", methodName);
        super.updateBeanEffectivityDates(userId, null, null, metadataElementGUID, "metadataElementGUID", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", effectiveFrom, effectiveTo, methodName);
    }

    public void deleteMetadataElementInStore(String userId, String metadataElementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        super.deleteBeanInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", null, null, methodName);
    }

    public void classifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, "OpenMetadataRoot", this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties classificationProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationTypeGUID, classificationName, classificationProperties, false, methodName);
    }

    public void reclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, boolean replaceProperties, ElementProperties properties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, "OpenMetadataRoot", this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties classificationProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), null, null);
        this.setClassificationInRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationTypeGUID, classificationName, classificationProperties, !replaceProperties, methodName);
    }

    public void updateClassificationStatusInStore(String userId, String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, "OpenMetadataRoot", this.serviceName, methodName, this.repositoryHelper);
        super.updateClassificationEffectivityDates(userId, null, null, metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationTypeGUID, classificationName, effectiveFrom, effectiveTo, methodName);
    }

    public void unclassifyMetadataElementInStore(String userId, String metadataElementGUID, String classificationName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "metadataElementGUID";
        String classificationParameterName = "classificationName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", methodName);
        this.invalidParameterHandler.validateName(classificationName, "classificationName", methodName);
        String classificationTypeGUID = this.invalidParameterHandler.validateTypeName(classificationName, "OpenMetadataRoot", this.serviceName, methodName, this.repositoryHelper);
        super.removeClassificationFromRepository(userId, null, null, metadataElementGUID, "metadataElementGUID", "OpenMetadataRoot", classificationTypeGUID, classificationName, methodName);
    }

    public String createRelatedElementsInStore(String userId, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementTypeParameterName = "relationshipTypeName";
        String end1ParameterName = "metadataElement1GUID";
        String end2ParameterName = "metadataElement2GUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        this.invalidParameterHandler.validateGUID(metadataElement1GUID, "metadataElement1GUID", methodName);
        this.invalidParameterHandler.validateGUID(metadataElement2GUID, "metadataElement2GUID", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), effectiveFrom, effectiveTo);
        super.linkElementToElement(userId, null, null, metadataElement1GUID, "metadataElement1GUID", "OpenMetadataRoot", metadataElement2GUID, "metadataElement2GUID", "OpenMetadataRoot", relationshipTypeGUID, relationshipTypeName, relationshipProperties, methodName);
        return null;
    }

    public Map<String, InstancePropertyValue> getElementPropertiesAsOMRSMap(ElementProperties properties) throws InvalidParameterException {
        if (properties != null) {
            Map propertyValues = properties.getInstanceProperties();
            HashMap<String, InstancePropertyValue> resultingMap = new HashMap<String, InstancePropertyValue>();
            if (propertyValues != null) {
                for (String mapPropertyName : propertyValues.keySet()) {
                    PropertyValue actualPropertyValue = properties.getPropertyValue(mapPropertyName);
                    InstancePropertyValue instancePropertyValue = this.getInstancePropertyValue(actualPropertyValue);
                    resultingMap.put(mapPropertyName, instancePropertyValue);
                }
            }
            return resultingMap;
        }
        return null;
    }

    public void updateRelatedElementsInStore(String userId, String relationshipGUID, boolean replaceProperties, ElementProperties properties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        MetadataElementBuilder builder = new MetadataElementBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties relationshipProperties = builder.getInstanceProperties(this.getElementPropertiesAsOMRSMap(properties), null, null);
        this.updateRelationshipProperties(userId, null, null, relationshipGUID, "relationshipGUID", null, !replaceProperties, relationshipProperties, methodName);
    }

    public void updateRelatedElementsStatusInStore(String userId, String relationshipGUID, Date effectiveFrom, Date effectiveTo, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        super.updateRelationshipEffectivityDates(userId, null, null, relationshipGUID, "relationshipGUID", null, effectiveFrom, effectiveTo, methodName);
    }

    public void deleteRelatedElementsInStore(String userId, String relationshipGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "relationshipGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(relationshipGUID, "relationshipGUID", methodName);
        this.repositoryHandler.removeRelationship(userId, null, null, null, relationshipGUID, methodName);
    }
}

