/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.outtopic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.handlers.MetadataElementHandler;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.outtopic.GovernanceEngineOutTopicPublisher;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementControlHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceEngineOMRSTopicListener
extends OMRSTopicListenerBase {
    private GovernanceEngineOutTopicPublisher eventPublisher;
    private OMRSRepositoryHelper repositoryHelper;
    private MetadataElementHandler<OpenMetadataElement> metadataElementHandler;
    private GovernanceActionHandler<GovernanceActionElement> governanceActionHandler;
    private String userId;
    private EntityDetail nullEntity = null;
    private Relationship nullRelationship = null;
    private PropertyHelper propertyHelper = new PropertyHelper();

    public GovernanceEngineOMRSTopicListener(String serviceName, String userId, MetadataElementHandler<OpenMetadataElement> metadataElementHandler, GovernanceActionHandler<GovernanceActionElement> governanceActionHandler, GovernanceEngineOutTopicPublisher eventPublisher, OMRSRepositoryHelper repositoryHelper, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.metadataElementHandler = metadataElementHandler;
        this.governanceActionHandler = governanceActionHandler;
        this.userId = userId;
        this.eventPublisher = eventPublisher;
        this.repositoryHelper = repositoryHelper;
    }

    private boolean processGovernanceEngineEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceEngine")) {
            this.eventPublisher.publishRefreshGovernanceEngineEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "qualifiedName", entity.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean excludeGovernanceEngineEvent(String sourceName, EntityDetail entity) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null) {
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceEngine");
        }
        return false;
    }

    private boolean processSupportedGovernanceService(String sourceName, Relationship relationship, String methodName) {
        EntityProxy end2;
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "SupportedGovernanceService") && (end2 = relationship.getEntityTwoProxy()) != null) {
            this.eventPublisher.publishRefreshGovernanceServiceEvent(end2.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "qualifiedName", end2.getUniqueProperties(), methodName), relationship.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "requestType", relationship.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean excludeSupportedGovernanceService(String sourceName, Relationship relationship) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null) {
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "SupportedGovernanceService");
        }
        return false;
    }

    private boolean processGovernanceActionEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        String entityGUIDParameterName = "entity.getGUID";
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceAction")) {
            GovernanceActionStatus status = this.governanceActionHandler.getActionStatus("actionStatus", entity.getProperties());
            if (status == GovernanceActionStatus.APPROVED) {
                try {
                    int attempt = 0;
                    int sleepTime = 1000;
                    while (attempt < 5) {
                        EntityDetail governanceEngine = this.governanceActionHandler.getAttachedEntity(this.userId, entity.getGUID(), "entity.getGUID", "GovernanceAction", "e690ab17-6779-46b4-a8f1-6872d88c1bbb", "GovernanceActionExecutor", "GovernanceEngine", methodName);
                        if (governanceEngine != null) {
                            this.eventPublisher.publishNewGovernanceAction(governanceEngine.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "qualifiedName", governanceEngine.getProperties(), methodName), entity.getGUID());
                            return true;
                        }
                        ++attempt;
                        Thread.sleep(sleepTime);
                        sleepTime *= 2;
                    }
                    this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.BAD_GOVERNANCE_ACTION.getMessageDefinition(new String[]{entity.toString()}));
                }
                catch (InvalidParameterException error) {
                    this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
                }
                catch (Exception error) {
                    this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
                }
            }
            return true;
        }
        return false;
    }

    private boolean excludeGovernanceActionEvent(String sourceName, EntityDetail entity) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null) {
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceAction");
        }
        return false;
    }

    private boolean excludeGovernanceManagementEvents(String sourceName, EntityDetail entity) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null) {
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceActionType");
        }
        return false;
    }

    private boolean excludeGovernanceManagementEvents(String sourceName, Relationship relationship) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null) {
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "SupportedGovernanceService")) {
                return true;
            }
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceActionTypeUse")) {
                return true;
            }
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "TargetForAction")) {
                return true;
            }
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceActionRequestSource")) {
                return true;
            }
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceActionExecutor");
        }
        return false;
    }

    private ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    private ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOriginCategory.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOriginCategory.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOriginCategory.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOriginCategory.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOriginCategory.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOriginCategory.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOriginCategory.UNKNOWN;
                }
            }
        }
        return ElementOriginCategory.UNKNOWN;
    }

    private ElementType getElementType(InstanceHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            elementType.setElementTypeId(instanceType.getTypeDefGUID());
            elementType.setElementTypeName(instanceType.getTypeDefName());
            elementType.setElementTypeVersion(instanceType.getTypeDefVersion());
            elementType.setElementTypeDescription(instanceType.getTypeDefDescription());
            List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setElementSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    private void fillElementControlHeader(String sourceName, ElementControlHeader elementControlHeader, InstanceAuditHeader header) {
        if (header != null) {
            elementControlHeader.setElementSourceServer(sourceName);
            elementControlHeader.setElementOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementControlHeader.setElementMetadataCollectionId(header.getMetadataCollectionId());
            elementControlHeader.setElementMetadataCollectionName(header.getMetadataCollectionName());
            elementControlHeader.setElementLicense(header.getInstanceLicense());
            elementControlHeader.setElementCreatedBy(header.getCreatedBy());
            elementControlHeader.setElementUpdatedBy(header.getUpdatedBy());
            elementControlHeader.setElementMaintainedBy(header.getMaintainedBy());
            elementControlHeader.setElementCreateTime(header.getCreateTime());
            elementControlHeader.setElementUpdateTime(header.getUpdateTime());
            elementControlHeader.setElementVersion(header.getVersion());
            elementControlHeader.setStatus(this.getElementStatus(header.getStatus()));
            elementControlHeader.setMappingProperties(header.getMappingProperties());
        }
    }

    private ElementClassification getClassification(String sourceName, Classification classification) {
        ElementClassification beanClassification = new ElementClassification();
        this.fillElementControlHeader(sourceName, (ElementControlHeader)beanClassification, (InstanceAuditHeader)classification);
        beanClassification.setClassificationName(classification.getName());
        if (classification.getProperties() != null) {
            Map classificationPropertyMap = this.repositoryHelper.getInstancePropertiesAsMap(classification.getProperties());
            beanClassification.setClassificationProperties(this.propertyHelper.addPropertyMap(null, classificationPropertyMap));
            beanClassification.setEffectiveFromTime(classification.getProperties().getEffectiveFromTime());
            beanClassification.setEffectiveToTime(classification.getProperties().getEffectiveToTime());
        }
        return beanClassification;
    }

    private RelatedMetadataElements getRelatedElements(String sourceName, Relationship relationship) {
        RelatedMetadataElements relatedMetadataElements = new RelatedMetadataElements();
        this.fillElementControlHeader(sourceName, (ElementControlHeader)relatedMetadataElements, (InstanceAuditHeader)relationship);
        relatedMetadataElements.setRelationshipGUID(relationship.getGUID());
        relatedMetadataElements.setRelationshipType(this.getElementType((InstanceHeader)relationship));
        if (relationship.getProperties() != null) {
            Map classificationPropertyMap = this.repositoryHelper.getInstancePropertiesAsMap(relationship.getProperties());
            relatedMetadataElements.setRelationshipProperties(this.propertyHelper.addPropertyMap(null, classificationPropertyMap));
            relatedMetadataElements.setEffectiveFromTime(relationship.getProperties().getEffectiveFromTime());
            relatedMetadataElements.setEffectiveToTime(relationship.getProperties().getEffectiveToTime());
        }
        if (relationship.getEntityOneProxy() != null) {
            relatedMetadataElements.setElementGUIDAtEnd1(relationship.getEntityOneProxy().getGUID());
        }
        if (relationship.getEntityTwoProxy() != null) {
            relatedMetadataElements.setElementGUIDAtEnd2(relationship.getEntityTwoProxy().getGUID());
        }
        return relatedMetadataElements;
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, EntityDetail entity, EntityDetail previousEntity, String methodName) {
        if (entity != null) {
            try {
                WatchdogMetadataElementEvent watchdogEvent = new WatchdogMetadataElementEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setMetadataElement(this.metadataElementHandler.getMetadataElementByGUID(this.userId, entity.getGUID(), methodName));
                if (previousEntity != null) {
                    watchdogEvent.setPreviousMetadataElement(this.metadataElementHandler.getMetadataElementByGUID(this.userId, previousEntity.getGUID(), methodName));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, EntityDetail entity, Classification classification, Classification previousClassification, String methodName) {
        if (entity != null) {
            try {
                WatchdogClassificationEvent watchdogEvent = new WatchdogClassificationEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setMetadataElement(this.metadataElementHandler.getMetadataElementByGUID(this.userId, entity.getGUID(), methodName));
                watchdogEvent.setChangedClassification(this.getClassification(sourceName, classification));
                if (previousClassification != null) {
                    watchdogEvent.setChangedClassification(this.getClassification(sourceName, previousClassification));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, Relationship relationship, Relationship previousRelationship, String methodName) {
        if (relationship != null) {
            try {
                this.metadataElementHandler.getMetadataElementByGUID(this.userId, relationship.getEntityOneProxy().getGUID(), methodName);
                this.metadataElementHandler.getMetadataElementByGUID(this.userId, relationship.getEntityTwoProxy().getGUID(), methodName);
                WatchdogRelatedElementsEvent watchdogEvent = new WatchdogRelatedElementsEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setRelatedMetadataElements(this.getRelatedElements(sourceName, relationship));
                if (previousRelationship != null) {
                    watchdogEvent.setPreviousRelatedMetadataElements(this.getRelatedElements(sourceName, previousRelationship));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, relationship.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, relationship.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processNewEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processNewEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_ELEMENT, entity, this.nullEntity, "processNewEntityEvent");
        }
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.processGovernanceActionEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, newEntity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_ELEMENT_PROPERTIES, newEntity, oldEntity, "processUpdatedEntityEvent");
        }
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processUndoneEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processUndoneEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_ELEMENT_PROPERTIES, entity, this.nullEntity, "processUndoneEntityEvent");
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processClassifiedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processClassifiedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_CLASSIFICATION, entity, classification, null, "processClassifiedEntityEvent");
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processDeclassifiedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_CLASSIFICATION, entity, originalClassification, null, "processDeclassifiedEntityEvent");
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processReclassifiedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES, entity, classification, originalClassification, "processReclassifiedEntityEvent");
        }
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processDeletedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processDeletedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_ELEMENT, entity, this.nullEntity, "processDeletedEntityEvent");
        }
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_ELEMENT, entity, this.nullEntity, "processDeletePurgedEntityEvent");
        }
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processRestoredEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processRestoredEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processRestoredEntityEvent");
        }
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processReIdentifiedEntityEvent");
        }
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processReTypedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processReTypedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processReTypedEntityEvent");
        }
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processReHomedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processReHomedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processReHomedEntityEvent");
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRefreshEntityEvent";
        if (!(this.excludeGovernanceEngineEvent(sourceName, entity) || this.excludeGovernanceActionEvent(sourceName, entity) || this.excludeGovernanceManagementEvents(sourceName, entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processRefreshEntityEvent");
        }
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processNewRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_RELATIONSHIP, relationship, this.nullRelationship, "processNewRelationshipEvent");
        }
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, newRelationship, "processUpdatedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, newRelationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_RELATIONSHIP_PROPERTIES, newRelationship, oldRelationship, "processUpdatedRelationshipEvent");
        }
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processUndoneRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processUndoneRelationshipEvent");
        }
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processDeletedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_RELATIONSHIP, relationship, this.nullRelationship, "processDeletedRelationshipEvent");
        }
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletePurgedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processDeletePurgedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_RELATIONSHIP, relationship, this.nullRelationship, "processDeletePurgedRelationshipEvent");
        }
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processRestoredRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processRestoredRelationshipEvent");
        }
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processReIdentifiedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processReIdentifiedRelationshipEvent");
        }
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processReTypedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processReTypedRelationshipEvent");
        }
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processReHomedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processReHomedRelationshipEvent");
        }
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRefreshRelationshipEvent";
        if (!this.excludeSupportedGovernanceService(sourceName, relationship) && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processRefreshRelationshipEvent");
        }
    }
}

