/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.StructTypePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GovernanceEngineOMASConverter<B>
extends OCFConverter<B> {
    private static final Logger log = LoggerFactory.getLogger(GovernanceEngineOMASConverter.class);
    PropertyHelper propertyHelper = new PropertyHelper();

    GovernanceEngineOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    private List<AttachedClassification> getAttachedClassifications(List<Classification> entityClassifications) {
        ArrayList<AttachedClassification> beanClassifications = null;
        if (entityClassifications != null) {
            beanClassifications = new ArrayList<AttachedClassification>();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                AttachedClassification beanClassification = new AttachedClassification();
                this.fillElementControlHeader((ElementControlHeader)beanClassification, (InstanceAuditHeader)entityClassification);
                beanClassification.setClassificationName(entityClassification.getName());
                if (entityClassification.getProperties() != null) {
                    Map classificationPropertyMap = this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties());
                    beanClassification.setClassificationProperties(this.propertyHelper.addPropertyMap(null, classificationPropertyMap));
                    beanClassification.setEffectiveFromTime(entityClassification.getProperties().getEffectiveFromTime());
                    beanClassification.setEffectiveToTime(entityClassification.getProperties().getEffectiveToTime());
                }
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    GovernanceActionStatus removeActionStatus(String propertyName, InstanceProperties properties) {
        GovernanceActionStatus ownerCategory = this.getActionStatus(propertyName, properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove(propertyName);
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerCategory;
    }

    private GovernanceActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        GovernanceActionStatus governanceActionStatus = GovernanceActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceActionStatus = GovernanceActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    governanceActionStatus = GovernanceActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    governanceActionStatus = GovernanceActionStatus.WAITING;
                    break;
                }
                case 3: {
                    governanceActionStatus = GovernanceActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    governanceActionStatus = GovernanceActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    governanceActionStatus = GovernanceActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    governanceActionStatus = GovernanceActionStatus.INVALID;
                    break;
                }
                case 12: {
                    governanceActionStatus = GovernanceActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    governanceActionStatus = GovernanceActionStatus.FAILED;
                }
            }
        }
        return governanceActionStatus;
    }

    OpenMetadataElement getOpenMetadataElement(String entityGUID, List<EntityDetail> entities) {
        OpenMetadataElement metadataElement = new OpenMetadataElement();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || !entityGUID.equals(entity.getGUID())) continue;
                this.fillOpenMetadataElement(metadataElement, entity);
                return metadataElement;
            }
        }
        metadataElement.setElementGUID(entityGUID);
        return metadataElement;
    }

    void fillElementControlHeader(ElementControlHeader elementControlHeader, InstanceAuditHeader header) {
        if (header != null) {
            elementControlHeader.setStatus(this.getElementStatus(header.getStatus()));
            elementControlHeader.setType(this.getElementType(header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementControlHeader.setOrigin(elementOrigin);
            elementControlHeader.setVersions(this.getElementVersions(header));
        }
    }

    private ElementProperties mapElementProperties(InstanceProperties instanceProperties) {
        if (instanceProperties != null && instanceProperties.getInstanceProperties() != null) {
            ElementProperties gafElementProperties = new ElementProperties();
            Map omrsProperties = instanceProperties.getInstanceProperties();
            for (String propertyName : omrsProperties.keySet()) {
                log.debug("=================================");
                log.debug("Processing property: " + propertyName);
                InstancePropertyValue omrsPropertyValue = (InstancePropertyValue)omrsProperties.get(propertyName);
                if (omrsPropertyValue != null) {
                    log.debug("OMRS Property value: " + omrsPropertyValue);
                    log.debug("OMRS Property category: " + omrsPropertyValue.getInstancePropertyCategory());
                    switch (omrsPropertyValue.getInstancePropertyCategory()) {
                        case PRIMITIVE: {
                            PrimitivePropertyValue omrsPrimitivePropertyValue = (PrimitivePropertyValue)omrsPropertyValue;
                            PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                            primitiveTypePropertyValue.setTypeName(omrsPrimitivePropertyValue.getTypeName());
                            primitiveTypePropertyValue.setPrimitiveValue(omrsPrimitivePropertyValue.getPrimitiveValue());
                            primitiveTypePropertyValue.setPrimitiveTypeCategory(this.mapPrimitiveDefCategory(omrsPrimitivePropertyValue.getPrimitiveDefCategory()));
                            gafElementProperties.setProperty(propertyName, (PropertyValue)primitiveTypePropertyValue);
                            break;
                        }
                        case ENUM: {
                            EnumPropertyValue omrsEnumPropertyValue = (EnumPropertyValue)omrsPropertyValue;
                            EnumTypePropertyValue enumTypePropertyValue = new EnumTypePropertyValue();
                            enumTypePropertyValue.setTypeName(omrsEnumPropertyValue.getTypeName());
                            enumTypePropertyValue.setSymbolicName(omrsEnumPropertyValue.getSymbolicName());
                            gafElementProperties.setProperty(propertyName, (PropertyValue)enumTypePropertyValue);
                            break;
                        }
                        case MAP: {
                            MapPropertyValue omrsMapPropertyValue = (MapPropertyValue)omrsPropertyValue;
                            MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                            mapTypePropertyValue.setTypeName(omrsMapPropertyValue.getTypeName());
                            mapTypePropertyValue.setMapValues(this.mapElementProperties(omrsMapPropertyValue.getMapValues()));
                            gafElementProperties.setProperty(propertyName, (PropertyValue)mapTypePropertyValue);
                            break;
                        }
                        case ARRAY: {
                            ArrayPropertyValue omrsArrayPropertyValue = (ArrayPropertyValue)omrsPropertyValue;
                            ArrayTypePropertyValue arrayTypePropertyValue = new ArrayTypePropertyValue();
                            arrayTypePropertyValue.setTypeName(omrsArrayPropertyValue.getTypeName());
                            arrayTypePropertyValue.setArrayValues(this.mapElementProperties(omrsArrayPropertyValue.getArrayValues()));
                            gafElementProperties.setProperty(propertyName, (PropertyValue)arrayTypePropertyValue);
                            break;
                        }
                        case STRUCT: {
                            StructPropertyValue omrsStructPropertyValue = (StructPropertyValue)omrsPropertyValue;
                            StructTypePropertyValue structTypePropertyValue = new StructTypePropertyValue();
                            structTypePropertyValue.setTypeName(omrsStructPropertyValue.getTypeName());
                            structTypePropertyValue.setAttributes(this.mapElementProperties(omrsStructPropertyValue.getAttributes()));
                            gafElementProperties.setProperty(propertyName, (PropertyValue)structTypePropertyValue);
                        }
                    }
                    continue;
                }
                log.debug("Ignoring property: " + propertyName);
            }
            log.debug("GAF properties: " + gafElementProperties);
            return gafElementProperties;
        }
        return null;
    }

    void fillOpenMetadataElement(OpenMetadataElement bean, EntityDetail entity) {
        this.fillElementControlHeader((ElementControlHeader)bean, (InstanceAuditHeader)entity);
        bean.setElementGUID(entity.getGUID());
        bean.setClassifications(this.getAttachedClassifications(entity.getClassifications()));
        InstanceProperties instanceProperties = entity.getProperties();
        if (instanceProperties != null) {
            bean.setEffectiveFromTime(instanceProperties.getEffectiveFromTime());
            bean.setEffectiveToTime(instanceProperties.getEffectiveToTime());
            if (log.isDebugEnabled()) {
                log.debug("OMRS properties: " + instanceProperties);
            }
            ElementProperties elementProperties = this.mapElementProperties(instanceProperties);
            if (log.isDebugEnabled()) {
                log.debug("GAF properties: " + elementProperties);
            }
            bean.setElementProperties(elementProperties);
        }
    }

    private PrimitiveTypeCategory mapPrimitiveDefCategory(PrimitiveDefCategory primitiveDefCategory) {
        switch (primitiveDefCategory) {
            case OM_PRIMITIVE_TYPE_INT: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT;
            }
            case OM_PRIMITIVE_TYPE_BYTE: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BYTE;
            }
            case OM_PRIMITIVE_TYPE_CHAR: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_CHAR;
            }
            case OM_PRIMITIVE_TYPE_DATE: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE;
            }
            case OM_PRIMITIVE_TYPE_LONG: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG;
            }
            case OM_PRIMITIVE_TYPE_FLOAT: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT;
            }
            case OM_PRIMITIVE_TYPE_SHORT: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_SHORT;
            }
            case OM_PRIMITIVE_TYPE_DOUBLE: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DOUBLE;
            }
            case OM_PRIMITIVE_TYPE_STRING: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING;
            }
            case OM_PRIMITIVE_TYPE_BOOLEAN: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN;
            }
            case OM_PRIMITIVE_TYPE_BIGDECIMAL: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL;
            }
            case OM_PRIMITIVE_TYPE_BIGINTEGER: {
                return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGINTEGER;
            }
        }
        return PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_UNKNOWN;
    }
}

