/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.converters;

import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredGovernanceService;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredGovernanceServiceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RegisteredGovernanceServiceConverter {
    private final OMRSRepositoryHelper repositoryHelper;
    private final String serviceName;

    public RegisteredGovernanceServiceConverter(OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    public RegisteredGovernanceServiceElement getBean(GovernanceServiceElement governanceService, List<Relationship> relationships) {
        String methodName = "getBean";
        RegisteredGovernanceServiceElement bean = new RegisteredGovernanceServiceElement(governanceService);
        if (relationships != null) {
            RegisteredGovernanceService properties;
            HashMap<String, RegisteredGovernanceServiceProperties> requestTypeMappings = new HashMap<String, RegisteredGovernanceServiceProperties>();
            for (Relationship relationship : relationships) {
                InstanceProperties instanceProperties;
                if (relationship == null || (instanceProperties = relationship.getProperties()) == null) continue;
                String requestType = this.repositoryHelper.getStringProperty(this.serviceName, "requestType", instanceProperties, "getBean");
                RegisteredGovernanceServiceProperties registeredGovernanceServiceProperties = new RegisteredGovernanceServiceProperties();
                String serviceRequestType = this.repositoryHelper.getStringProperty(this.serviceName, "serviceRequestType", instanceProperties, "getBean");
                if (requestType == null) continue;
                if (serviceRequestType == null) {
                    registeredGovernanceServiceProperties.setServiceRequestType(requestType);
                } else {
                    registeredGovernanceServiceProperties.setServiceRequestType(serviceRequestType);
                }
                registeredGovernanceServiceProperties.setRequestParameters(this.repositoryHelper.getStringMapFromProperty(this.serviceName, "requestParameters", instanceProperties, "getBean"));
                requestTypeMappings.put(requestType, registeredGovernanceServiceProperties);
            }
            if (!requestTypeMappings.isEmpty() && (properties = bean.getProperties()) != null) {
                properties.setRequestTypes(requestTypeMappings);
                bean.setProperties(properties);
            }
        }
        return bean;
    }
}

