/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.outtopic;

import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceEngineOMASConverter;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.handlers.MetadataElementHandler;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.governanceengine.outtopic.GovernanceEngineOutTopicPublisher;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceEngineOMRSTopicListener
extends OMRSTopicListenerBase {
    private final GovernanceEngineOutTopicPublisher eventPublisher;
    private final OMRSRepositoryHelper repositoryHelper;
    private final MetadataElementHandler<OpenMetadataElement> metadataElementHandler;
    private final GovernanceActionHandler<GovernanceActionElement> governanceActionHandler;
    private final String userId;
    private final EntityDetail nullEntity = null;
    private final Relationship nullRelationship = null;
    private final GovernanceEngineOMASConverter<MetadataElement> converter;

    public GovernanceEngineOMRSTopicListener(String serviceName, String userId, MetadataElementHandler<OpenMetadataElement> metadataElementHandler, GovernanceActionHandler<GovernanceActionElement> governanceActionHandler, GovernanceEngineOutTopicPublisher eventPublisher, OMRSRepositoryHelper repositoryHelper, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.metadataElementHandler = metadataElementHandler;
        this.governanceActionHandler = governanceActionHandler;
        this.userId = userId;
        this.eventPublisher = eventPublisher;
        this.repositoryHelper = repositoryHelper;
        this.converter = new GovernanceEngineOMASConverter(repositoryHelper, serviceName, metadataElementHandler.getServerName());
    }

    private boolean processGovernanceEngineEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceEngine")) {
            this.eventPublisher.publishRefreshGovernanceEngineEvent(entity.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "qualifiedName", entity.getProperties(), methodName));
            return true;
        }
        return false;
    }

    private boolean excludeGovernanceEngineEvent(String sourceName, EntitySummary entity) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null) {
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceEngine");
        }
        return false;
    }

    private boolean processSupportedGovernanceService(String sourceName, Relationship relationship, String methodName) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "SupportedGovernanceService")) {
            EntityProxy governanceEngineEntityProxy = relationship.getEntityOneProxy();
            EntityProxy governanceServiceEntityProxy = relationship.getEntityTwoProxy();
            if (governanceEngineEntityProxy != null) {
                this.eventPublisher.publishRefreshGovernanceServiceEvent(governanceEngineEntityProxy.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "qualifiedName", governanceEngineEntityProxy.getUniqueProperties(), methodName), governanceServiceEntityProxy.getGUID(), this.repositoryHelper.getStringProperty(sourceName, "requestType", relationship.getProperties(), methodName));
                return true;
            }
        }
        return false;
    }

    private boolean excludeSupportedGovernanceService(String sourceName, Relationship relationship) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null) {
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "SupportedGovernanceService");
        }
        return false;
    }

    private boolean processGovernanceActionEvent(String sourceName, EntityDetail entity, String methodName) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null && this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceAction")) {
            GovernanceActionStatus status = this.governanceActionHandler.getActionStatus("actionStatus", entity.getProperties());
            if (status == GovernanceActionStatus.APPROVED) {
                String governanceEngineGUID = this.repositoryHelper.getStringProperty(sourceName, "executorEngineGUID", entity.getProperties(), methodName);
                String governanceEngineName = this.repositoryHelper.getStringProperty(sourceName, "executorEngineName", entity.getProperties(), methodName);
                this.eventPublisher.publishNewGovernanceAction(governanceEngineGUID, governanceEngineName, entity.getGUID());
            }
            return true;
        }
        return false;
    }

    private boolean excludeGovernanceActionEvent(String sourceName, EntitySummary entity) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null) {
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceAction");
        }
        return false;
    }

    private boolean excludeGovernanceManagementEvents(String sourceName, EntitySummary entity) {
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null) {
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceActionType");
        }
        return false;
    }

    private boolean excludeGovernanceManagementEvents(String sourceName, Relationship relationship) {
        InstanceType type;
        if (relationship != null && (type = relationship.getType()) != null) {
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "SupportedGovernanceService")) {
                return true;
            }
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "TargetForAction")) {
                return true;
            }
            if (this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceActionRequestSource")) {
                return true;
            }
            return this.repositoryHelper.isTypeOf(sourceName, type.getTypeDefName(), "GovernanceActionExecutor");
        }
        return false;
    }

    private AttachedClassification getClassification(Classification classification) {
        if (classification != null) {
            AttachedClassification beanClassification = new AttachedClassification();
            this.converter.fillElementControlHeader((ElementControlHeader)beanClassification, (InstanceAuditHeader)classification);
            beanClassification.setClassificationName(classification.getName());
            if (classification.getProperties() != null) {
                beanClassification.setClassificationProperties(this.converter.mapElementProperties(classification.getProperties()));
                beanClassification.setEffectiveFromTime(classification.getProperties().getEffectiveFromTime());
                beanClassification.setEffectiveToTime(classification.getProperties().getEffectiveToTime());
            }
            return beanClassification;
        }
        return null;
    }

    private RelatedMetadataElements getRelatedElements(Relationship relationship) {
        if (relationship != null) {
            RelatedMetadataElements relatedMetadataElements = new RelatedMetadataElements();
            this.converter.fillElementControlHeader((ElementControlHeader)relatedMetadataElements, (InstanceAuditHeader)relationship);
            relatedMetadataElements.setRelationshipGUID(relationship.getGUID());
            relatedMetadataElements.setRelationshipType(this.converter.getElementType((InstanceAuditHeader)relationship));
            if (relationship.getProperties() != null) {
                relatedMetadataElements.setRelationshipProperties(this.converter.mapElementProperties(relationship.getProperties()));
                relatedMetadataElements.setEffectiveFromTime(relationship.getProperties().getEffectiveFromTime());
                relatedMetadataElements.setEffectiveToTime(relationship.getProperties().getEffectiveToTime());
            }
            if (relationship.getEntityOneProxy() != null) {
                relatedMetadataElements.setElementGUIDAtEnd1(relationship.getEntityOneProxy().getGUID());
            }
            if (relationship.getEntityTwoProxy() != null) {
                relatedMetadataElements.setElementGUIDAtEnd2(relationship.getEntityTwoProxy().getGUID());
            }
            return relatedMetadataElements;
        }
        return null;
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, EntityDetail entity, EntityDetail previousEntity, String methodName) {
        if (entity != null) {
            try {
                WatchdogMetadataElementEvent watchdogEvent = new WatchdogMetadataElementEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setMetadataElement(this.metadataElementHandler.getMetadataElementByGUID(this.userId, entity.getGUID(), true, false, null, methodName));
                if (previousEntity != null) {
                    watchdogEvent.setPreviousMetadataElement(this.metadataElementHandler.getMetadataElementByGUID(this.userId, previousEntity.getGUID(), true, false, null, methodName));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, EntitySummary entity, Classification classification, Classification previousClassification, String methodName) {
        if (entity != null) {
            try {
                WatchdogClassificationEvent watchdogEvent = new WatchdogClassificationEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setMetadataElement(this.metadataElementHandler.getMetadataElementByGUID(this.userId, entity.getGUID(), true, false, null, methodName));
                watchdogEvent.setChangedClassification(this.getClassification(classification));
                if (previousClassification != null) {
                    watchdogEvent.setChangedClassification(this.getClassification(previousClassification));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, Relationship relationship, Relationship previousRelationship, String methodName) {
        if (relationship != null) {
            try {
                this.metadataElementHandler.getMetadataElementByGUID(this.userId, relationship.getEntityOneProxy().getGUID(), true, false, null, methodName);
                this.metadataElementHandler.getMetadataElementByGUID(this.userId, relationship.getEntityTwoProxy().getGUID(), true, false, null, methodName);
                WatchdogRelatedElementsEvent watchdogEvent = new WatchdogRelatedElementsEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setRelatedMetadataElements(this.getRelatedElements(relationship));
                if (previousRelationship != null) {
                    watchdogEvent.setPreviousRelatedMetadataElements(this.getRelatedElements(previousRelationship));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, relationship.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, relationship.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processNewEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processNewEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_ELEMENT, entity, this.nullEntity, "processNewEntityEvent");
        }
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.processGovernanceActionEvent(sourceName, newEntity, "processUpdatedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)newEntity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_ELEMENT_PROPERTIES, newEntity, oldEntity, "processUpdatedEntityEvent");
        }
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processUndoneEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processUndoneEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_ELEMENT_PROPERTIES, entity, this.nullEntity, "processUndoneEntityEvent");
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        if (!(this.excludeGovernanceEngineEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceActionEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_CLASSIFICATION, (EntitySummary)entity, classification, null, "processClassifiedEntityEvent");
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent(proxy)";
        if (!(this.excludeGovernanceEngineEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceActionEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_CLASSIFICATION, (EntitySummary)entity, classification, null, "processClassifiedEntityEvent(proxy)");
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        if (!(this.excludeGovernanceEngineEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceActionEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_CLASSIFICATION, (EntitySummary)entity, originalClassification, null, "processDeclassifiedEntityEvent");
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        if (!(this.excludeGovernanceEngineEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceActionEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_CLASSIFICATION, (EntitySummary)entity, originalClassification, null, "processDeclassifiedEntityEvent");
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        if (!(this.excludeGovernanceEngineEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceActionEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES, (EntitySummary)entity, classification, originalClassification, "processReclassifiedEntityEvent");
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        if (!(this.excludeGovernanceEngineEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceActionEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES, (EntitySummary)entity, classification, originalClassification, "processReclassifiedEntityEvent");
        }
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processDeletedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processDeletedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_ELEMENT, entity, this.nullEntity, "processDeletedEntityEvent");
        }
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processDeletePurgedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_ELEMENT, entity, this.nullEntity, "processDeletePurgedEntityEvent");
        }
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processRestoredEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processRestoredEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processRestoredEntityEvent");
        }
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processReIdentifiedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processReIdentifiedEntityEvent");
        }
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processReTypedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processReTypedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processReTypedEntityEvent");
        }
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        if (!(this.processGovernanceEngineEvent(sourceName, entity, "processReHomedEntityEvent") || this.processGovernanceActionEvent(sourceName, entity, "processReHomedEntityEvent") || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processReHomedEntityEvent");
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRefreshEntityEvent";
        if (!(this.excludeGovernanceEngineEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceActionEvent(sourceName, (EntitySummary)entity) || this.excludeGovernanceManagementEvents(sourceName, (EntitySummary)entity))) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, this.nullEntity, "processRefreshEntityEvent");
        }
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processNewRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_RELATIONSHIP, relationship, this.nullRelationship, "processNewRelationshipEvent");
        }
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, newRelationship, "processUpdatedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, newRelationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_RELATIONSHIP_PROPERTIES, newRelationship, oldRelationship, "processUpdatedRelationshipEvent");
        }
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processUndoneRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processUndoneRelationshipEvent");
        }
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processDeletedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_RELATIONSHIP, relationship, this.nullRelationship, "processDeletedRelationshipEvent");
        }
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletePurgedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processDeletePurgedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_RELATIONSHIP, relationship, this.nullRelationship, "processDeletePurgedRelationshipEvent");
        }
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processRestoredRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processRestoredRelationshipEvent");
        }
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processReIdentifiedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processReIdentifiedRelationshipEvent");
        }
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processReTypedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processReTypedRelationshipEvent");
        }
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        if (!this.processSupportedGovernanceService(sourceName, relationship, "processReHomedRelationshipEvent") && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processReHomedRelationshipEvent");
        }
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRefreshRelationshipEvent";
        if (!this.excludeSupportedGovernanceService(sourceName, relationship) && !this.excludeGovernanceManagementEvents(sourceName, relationship)) {
            this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, this.nullRelationship, "processRefreshRelationshipEvent");
        }
    }
}

