/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.handlers.MetadataElementHandler;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.slf4j.LoggerFactory;

public class GovernanceEngineRESTServices {
    private static final GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceEngineRESTServices.class), instanceHandler.getServiceName());

    public ConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse logAssetAuditMessage(String serverName, String userId, String assetGUID, String governanceService, String message) {
        String methodName = "logAssetAuditMessage";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "logAssetAuditMessage");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "logAssetAuditMessage");
            auditLog.logMessage("logAssetAuditMessage", GovernanceEngineAuditCode.ASSET_AUDIT_LOG.getMessageDefinition(new String[]{assetGUID, governanceService, message}));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "logAssetAuditMessage", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkElementsAsDuplicates(String serverName, String userId, PeerDuplicatesRequestBody requestBody) {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameterName = "element1GUID";
        String element2GUIDParameterName = "element2GUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkElementsAsDuplicates");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkElementsAsDuplicates");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "linkElementsAsDuplicates");
            if (requestBody != null) {
                handler.linkElementsAsPeerDuplicates(userId, requestBody.getMetadataElement1GUID(), "element1GUID", requestBody.getMetadataElement2GUID(), "element2GUID", requestBody.getSetKnownDuplicate(), requestBody.getStatusIdentifier(), requestBody.getSteward(), requestBody.getStewardTypeName(), requestBody.getStewardPropertyName(), requestBody.getSource(), requestBody.getNotes(), instanceHandler.getSupportedZones(userId, serverName, "linkElementsAsDuplicates"), "linkElementsAsDuplicates");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkElementsAsDuplicates", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkElementsAsDuplicates", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkConsolidatedDuplicate(String serverName, String userId, ConsolidatedDuplicatesRequestBody requestBody) {
        String methodName = "linkConsolidatedDuplicate";
        String elementGUIDParameterName = "consolidatedElementGUID";
        String sourceElementGUIDsParameterName = "sourceElementGUIDs";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "linkConsolidatedDuplicate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkConsolidatedDuplicate");
            MetadataElementHandler<OpenMetadataElement> handler = instanceHandler.getMetadataElementHandler(userId, serverName, "linkConsolidatedDuplicate");
            if (requestBody != null) {
                handler.linkConsolidatedDuplicate(userId, requestBody.getConsolidatedElementGUID(), "consolidatedElementGUID", requestBody.getStatusIdentifier(), requestBody.getSteward(), requestBody.getStewardTypeName(), requestBody.getStewardPropertyName(), requestBody.getSource(), requestBody.getNotes(), requestBody.getSourceElementGUIDs(), "sourceElementGUIDs", instanceHandler.getSupportedZones(userId, serverName, "linkConsolidatedDuplicate"), "linkConsolidatedDuplicate");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "linkConsolidatedDuplicate", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "linkConsolidatedDuplicate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateActionTargetStatus(String serverName, String userId, ActionTargetStatusRequestBody requestBody) {
        String methodName = "updateActionTargetStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateActionTargetStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateActionTargetStatus");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "updateActionTargetStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.updateActionTargetStatus(userId, requestBody.getActionTargetGUID(), statusOrdinal, requestBody.getStartDate(), requestBody.getCompletionDate(), requestBody.getCompletionMessage(), new Date(), "updateActionTargetStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateActionTargetStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateActionTargetStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionStatus(String serverName, String userId, String governanceActionGUID, StatusRequestBody requestBody) {
        String methodName = "updateGovernanceActionStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionStatus");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "updateGovernanceActionStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.updateGovernanceActionStatus(userId, governanceActionGUID, statusOrdinal, new Date(), "updateGovernanceActionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse recordCompletionStatus(String serverName, String userId, String governanceActionGUID, CompletionStatusRequestBody requestBody) {
        String methodName = "recordCompletionStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "recordCompletionStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "recordCompletionStatus");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "recordCompletionStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.recordCompletionStatus(userId, governanceActionGUID, statusOrdinal, requestBody.getRequestParameters(), requestBody.getOutputGuards(), requestBody.getNewActionTargets(), requestBody.getCompletionMessage(), new Date(), "recordCompletionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "recordCompletionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "recordCompletionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceAction(String serverName, String userId, String governanceEngineName, GovernanceActionRequestBody requestBody) {
        String methodName = "initiateGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateGovernanceAction");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceAction");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "initiateGovernanceAction");
                String governanceActionGUID = handler.createGovernanceAction(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), null, requestBody.getReceivedGuards(), requestBody.getStartTime(), governanceEngineName, requestBody.getRequestType(), requestBody.getRequestParameters(), null, null, null, requestBody.getProcessName(), requestBody.getRequestSourceName(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), "initiateGovernanceAction");
                if (governanceActionGUID != null) {
                    handler.approveGovernanceAction(userId, governanceActionGUID, requestBody.getQualifiedName(), null, requestBody.getReceivedGuards(), requestBody.getStartTime(), governanceEngineName, requestBody.getRequestType(), requestBody.getRequestParameters(), null, requestBody.getProcessName(), "initiateGovernanceAction");
                    response.setGUID(governanceActionGUID);
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceAction", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse initiateGovernanceActionProcess(String serverName, String userId, GovernanceActionProcessRequestBody requestBody) {
        String methodName = "initiateGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "initiateGovernanceActionProcess");
        AuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "initiateGovernanceActionProcess");
            if (requestBody != null) {
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "initiateGovernanceActionProcess");
                response.setGUID(handler.initiateGovernanceActionProcess(userId, requestBody.getProcessQualifiedName(), requestBody.getRequestSourceGUIDs(), requestBody.getActionTargets(), requestBody.getRequestParameters(), requestBody.getStartTime(), requestBody.getOriginatorServiceName(), requestBody.getOriginatorEngineName(), "initiateGovernanceActionProcess"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "initiateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "initiateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementResponse getGovernanceAction(String serverName, String userId, String governanceActionGUID) {
        String methodName = "getGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceAction");
        AuditLog auditLog = null;
        GovernanceActionElementResponse response = new GovernanceActionElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceAction");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getGovernanceAction");
            response.setElement((GovernanceActionElement)handler.getGovernanceAction(userId, governanceActionGUID, new Date(), "getGovernanceAction"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse claimGovernanceAction(String serverName, String userId, String governanceActionGUID, NullRequestBody requestBody) {
        String methodName = "claimGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "claimGovernanceAction");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "claimGovernanceAction");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "claimGovernanceAction");
            handler.claimGovernanceAction(userId, governanceActionGUID, new Date(), "claimGovernanceAction");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "claimGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getGovernanceActions(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActions");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getGovernanceActions");
            response.setElements(handler.getGovernanceActions(userId, startFrom, pageSize, new Date(), "getGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getActiveGovernanceActions(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getActiveGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveGovernanceActions");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getActiveGovernanceActions");
            response.setElements(handler.getActiveGovernanceActions(userId, startFrom, pageSize, new Date(), "getActiveGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getActiveClaimedGovernanceActions(String serverName, String userId, String governanceEngineGUID, int startFrom, int pageSize) {
        String methodName = "getActiveClaimedGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveClaimedGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveClaimedGovernanceActions");
            GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getActiveClaimedGovernanceActions");
            response.setElements(handler.getActiveClaimedGovernanceActions(userId, governanceEngineGUID, startFrom, pageSize, new Date(), "getActiveClaimedGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveClaimedGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse findGovernanceActions(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActions";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActions");
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActions");
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "findGovernanceActions");
                if (requestBody.getSearchStringParameterName() != null) {
                    searchStringParameterName = requestBody.getSearchStringParameterName();
                }
                response.setElements(handler.findGovernanceActions(userId, requestBody.getSearchString(), searchStringParameterName, startFrom, pageSize, false, false, new Date(), "findGovernanceActions"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActions", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getGovernanceActionsByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionsByName");
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionsByName");
                GovernanceActionHandler<GovernanceActionElement> handler = instanceHandler.getGovernanceActionHandler(userId, serverName, "getGovernanceActionsByName");
                if (requestBody.getNameParameterName() != null) {
                    nameParameterName = requestBody.getNameParameterName();
                }
                response.setElements(handler.getGovernanceActionsByName(userId, requestBody.getName(), nameParameterName, startFrom, pageSize, null, "getGovernanceActionsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

