/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.ElementOrigin;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementControlHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

abstract class GovernanceEngineOMASConverter<B>
extends OCFConverter<B> {
    protected PropertyHelper propertyHelper = new PropertyHelper();

    GovernanceEngineOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    ElementHeader getMetadataElementHeader(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            return this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName);
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    ElementHeader getMetadataElementHeader(Class<B> beanClass, InstanceHeader header, List<Classification> entityClassifications, String methodName) throws PropertyServerException {
        if (header != null) {
            ElementHeader elementHeader = new ElementHeader();
            elementHeader.setGUID(header.getGUID());
            elementHeader.setClassifications(this.getElementClassifications(entityClassifications));
            elementHeader.setType(this.getElementType(header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            return elementHeader;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    List<ElementClassification> getElementClassifications(EntityDetail entity) {
        if (entity != null) {
            return this.getElementClassifications(entity.getClassifications());
        }
        return null;
    }

    private List<ElementClassification> getElementClassifications(List<Classification> entityClassifications) {
        ArrayList<ElementClassification> beanClassifications = null;
        if (entityClassifications != null) {
            beanClassifications = new ArrayList<ElementClassification>();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification();
                this.fillElementControlHeader((ElementControlHeader)beanClassification, (InstanceAuditHeader)entityClassification);
                beanClassification.setClassificationName(entityClassification.getName());
                if (entityClassification.getProperties() != null) {
                    Map classificationPropertyMap = this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties());
                    beanClassification.setClassificationProperties(this.propertyHelper.addPropertyMap(null, classificationPropertyMap));
                    beanClassification.setEffectiveFromTime(entityClassification.getProperties().getEffectiveFromTime());
                    beanClassification.setEffectiveToTime(entityClassification.getProperties().getEffectiveToTime());
                }
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    ElementType getElementType(InstanceHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            elementType.setElementTypeId(instanceType.getTypeDefGUID());
            elementType.setElementTypeName(instanceType.getTypeDefName());
            elementType.setElementTypeVersion(instanceType.getTypeDefVersion());
            elementType.setElementTypeDescription(instanceType.getTypeDefDescription());
            List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setElementSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    private ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOriginCategory.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOriginCategory.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOriginCategory.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOriginCategory.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOriginCategory.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOriginCategory.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOriginCategory.UNKNOWN;
                }
            }
        }
        return ElementOriginCategory.UNKNOWN;
    }

    GovernanceActionStatus removeActionStatus(String propertyName, InstanceProperties properties) {
        GovernanceActionStatus ownerCategory = this.getActionStatus(propertyName, properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove(propertyName);
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerCategory;
    }

    private GovernanceActionStatus getActionStatus(String propertyName, InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        GovernanceActionStatus governanceActionStatus = GovernanceActionStatus.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(propertyName)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    governanceActionStatus = GovernanceActionStatus.REQUESTED;
                    break;
                }
                case 1: {
                    governanceActionStatus = GovernanceActionStatus.APPROVED;
                    break;
                }
                case 2: {
                    governanceActionStatus = GovernanceActionStatus.WAITING;
                    break;
                }
                case 3: {
                    governanceActionStatus = GovernanceActionStatus.ACTIVATING;
                    break;
                }
                case 4: {
                    governanceActionStatus = GovernanceActionStatus.IN_PROGRESS;
                    break;
                }
                case 10: {
                    governanceActionStatus = GovernanceActionStatus.ACTIONED;
                    break;
                }
                case 11: {
                    governanceActionStatus = GovernanceActionStatus.INVALID;
                    break;
                }
                case 12: {
                    governanceActionStatus = GovernanceActionStatus.IGNORED;
                    break;
                }
                case 13: {
                    governanceActionStatus = GovernanceActionStatus.FAILED;
                    break;
                }
                case 99: {
                    governanceActionStatus = GovernanceActionStatus.OTHER;
                }
            }
        }
        return governanceActionStatus;
    }

    ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    OpenMetadataElement getOpenMetadataElement(String entityGUID, List<EntityDetail> entities) {
        OpenMetadataElement metadataElement = new OpenMetadataElement();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || !entityGUID.equals(entity.getGUID())) continue;
                this.fillOpenMetadataElement(metadataElement, entity);
                return metadataElement;
            }
        }
        metadataElement.setElementGUID(entityGUID);
        return metadataElement;
    }

    void fillElementControlHeader(ElementControlHeader elementControlHeader, InstanceAuditHeader header) {
        if (header != null) {
            elementControlHeader.setElementSourceServer(this.serverName);
            elementControlHeader.setElementOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementControlHeader.setElementMetadataCollectionId(header.getMetadataCollectionId());
            elementControlHeader.setElementMetadataCollectionName(header.getMetadataCollectionName());
            elementControlHeader.setElementLicense(header.getInstanceLicense());
            elementControlHeader.setElementCreatedBy(header.getCreatedBy());
            elementControlHeader.setElementUpdatedBy(header.getUpdatedBy());
            elementControlHeader.setElementMaintainedBy(header.getMaintainedBy());
            elementControlHeader.setElementCreateTime(header.getCreateTime());
            elementControlHeader.setElementUpdateTime(header.getUpdateTime());
            elementControlHeader.setElementVersion(header.getVersion());
            elementControlHeader.setStatus(this.getElementStatus(header.getStatus()));
            elementControlHeader.setMappingProperties(header.getMappingProperties());
        }
    }

    void fillOpenMetadataElement(OpenMetadataElement bean, EntityDetail entity) {
        this.fillElementControlHeader((ElementControlHeader)bean, (InstanceAuditHeader)entity);
        bean.setElementGUID(entity.getGUID());
        bean.setElementType(this.getElementType((InstanceHeader)entity));
        bean.setClassifications(this.getElementClassifications(entity));
        InstanceProperties instanceProperties = entity.getProperties();
        if (instanceProperties != null) {
            bean.setEffectiveFromTime(instanceProperties.getEffectiveFromTime());
            bean.setEffectiveToTime(instanceProperties.getEffectiveToTime());
            Map propertyMap = this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties);
            bean.setElementProperties(this.propertyHelper.addPropertyMap(new ElementProperties(), propertyMap));
        }
    }
}

