/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.outtopic;

import org.odpi.openmetadata.accessservices.governanceengine.connectors.outtopic.GovernanceEngineOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceActionEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEventType;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceServiceConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.WatchdogGovernanceServiceEvent;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;

public class GovernanceEngineOutTopicPublisher {
    private GovernanceEngineOutTopicServerConnector outTopicServerConnector;
    private AuditLog outTopicAuditLog;
    private String outTopicName;
    private final String actionDescription = "Out topic event publishing";

    public GovernanceEngineOutTopicPublisher(GovernanceEngineOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic event publishing", GovernanceEngineAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    void publishRefreshGovernanceEngineEvent(String governanceEngineGUID, String governanceEngineName) {
        String methodName = "publishRefreshGovernanceEngineEvent";
        if (this.outTopicServerConnector != null) {
            try {
                GovernanceEngineConfigurationEvent newEvent = new GovernanceEngineConfigurationEvent();
                newEvent.setEventType(GovernanceEngineEventType.REFRESH_GOVERNANCE_ENGINE_EVENT);
                newEvent.setGovernanceEngineGUID(governanceEngineGUID);
                newEvent.setGovernanceEngineName(governanceEngineName);
                this.outTopicServerConnector.sendEvent((GovernanceEngineEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceEngineAuditCode.REFRESH_GOVERNANCE_ENGINE.getMessageDefinition(new String[]{governanceEngineName, governanceEngineGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishRefreshGovernanceEngineEvent");
            }
        }
    }

    void publishRefreshGovernanceServiceEvent(String governanceEngineGUID, String governanceEngineName, String registeredGovernanceServiceGUID, String governanceRequestType) {
        String methodName = "publishRefreshGovernanceServiceEvent";
        if (this.outTopicServerConnector != null) {
            try {
                GovernanceServiceConfigurationEvent newEvent = new GovernanceServiceConfigurationEvent();
                newEvent.setEventType(GovernanceEngineEventType.REFRESH_GOVERNANCE_SERVICE_EVENT);
                newEvent.setGovernanceEngineGUID(governanceEngineGUID);
                newEvent.setGovernanceEngineName(governanceEngineName);
                newEvent.setRegisteredGovernanceServiceGUID(registeredGovernanceServiceGUID);
                newEvent.setRequestType(governanceRequestType);
                this.outTopicServerConnector.sendEvent((GovernanceEngineEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceEngineAuditCode.REFRESH_GOVERNANCE_SERVICE.getMessageDefinition(new String[]{governanceEngineName, governanceEngineGUID, governanceRequestType, registeredGovernanceServiceGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishRefreshGovernanceServiceEvent");
            }
        }
    }

    void publishNewGovernanceAction(String governanceEngineGUID, String governanceEngineName, String governanceActionGUID) {
        String methodName = "publishNewGovernanceAction";
        if (this.outTopicServerConnector != null) {
            try {
                GovernanceActionEvent newEvent = new GovernanceActionEvent();
                newEvent.setEventType(GovernanceEngineEventType.REQUESTED_GOVERNANCE_ACTION_EVENT);
                newEvent.setGovernanceEngineGUID(governanceEngineGUID);
                newEvent.setGovernanceEngineName(governanceEngineName);
                newEvent.setGovernanceActionGUID(governanceActionGUID);
                this.outTopicServerConnector.sendEvent((GovernanceEngineEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceEngineAuditCode.NEW_GOVERNANCE_ACTION.getMessageDefinition(new String[]{governanceActionGUID, governanceEngineName, governanceEngineGUID}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishNewGovernanceAction");
            }
        }
    }

    void publishWatchdogEvent(WatchdogGovernanceEvent watchdogGovernanceEvent) {
        String methodName = "publishWatchdogEvent";
        if (this.outTopicServerConnector != null) {
            try {
                WatchdogGovernanceServiceEvent newEvent = new WatchdogGovernanceServiceEvent();
                newEvent.setEventType(GovernanceEngineEventType.WATCHDOG_GOVERNANCE_SERVICE_EVENT);
                newEvent.settWatchdogGovernanceEvent(watchdogGovernanceEvent);
                this.outTopicServerConnector.sendEvent((GovernanceEngineEvent)newEvent);
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceEngineAuditCode.WATCHDOG_EVENT.getMessageDefinition(new String[]{watchdogGovernanceEvent.getEventType().getName()}));
                }
            }
            catch (Exception error) {
                this.logUnexpectedPublishingException(error, "publishWatchdogEvent");
            }
        }
    }

    private void logUnexpectedPublishingException(Throwable error, String methodName) {
        if (this.outTopicAuditLog != null) {
            this.outTopicAuditLog.logException(methodName, GovernanceEngineAuditCode.OUT_TOPIC_FAILURE.getMessageDefinition(new String[]{this.outTopicName, error.getClass().getName(), error.getMessage()}), error);
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic event publishing", GovernanceEngineAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic event publishing", GovernanceEngineAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

