/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceEngineConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceServiceConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.RegisteredGovernanceServiceConverter;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceEngineElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIDummyBeanConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceConfigurationHandler {
    private String serviceName;
    private String serverName;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private SoftwareServerCapabilityHandler<GovernanceEngineElement> governanceEngineHandler;
    private AssetHandler<GovernanceServiceElement> governanceServiceHandler;
    private ConnectionHandler<Connection> connectionHandler;
    private ConnectorTypeHandler<ConnectorType> connectorTypeHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public GovernanceConfigurationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.governanceEngineHandler = new SoftwareServerCapabilityHandler(new GovernanceEngineConverter(repositoryHelper, serviceName, serverName), GovernanceEngineElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.governanceServiceHandler = new AssetHandler(new GovernanceServiceConverter(repositoryHelper, serviceName, serverName), GovernanceServiceElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectionHandler = new ConnectionHandler((OpenMetadataAPIGenericConverter)new ConnectionConverter(repositoryHelper, serviceName, serverName), Connection.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectorTypeHandler = new ConnectorTypeHandler((OpenMetadataAPIGenericConverter)new OpenMetadataAPIDummyBeanConverter(repositoryHelper, serviceName, serverName), ConnectorType.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceEngine(String userId, String typeName, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceEngine";
        String typeNameParameterName = "typeName";
        this.invalidParameterHandler.validateName(typeName, "typeName", "createGovernanceEngine");
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, "GovernanceEngine", this.serviceName, "createGovernanceEngine", this.repositoryHelper);
        return this.governanceEngineHandler.createSoftwareServerCapability(userId, null, null, typeGUID, typeName, null, qualifiedName, displayName, description, null, null, null, null, null, null, null, null, "createGovernanceEngine");
    }

    public GovernanceEngineElement getGovernanceEngineByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByGUID";
        String guidParameter = "guid";
        return (GovernanceEngineElement)this.governanceEngineHandler.getBeanFromRepository(userId, guid, "guid", "GovernanceEngine", false, false, new Date(), "getGovernanceEngineByGUID");
    }

    public GovernanceEngineElement getGovernanceEngineByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByName";
        String nameParameter = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add("qualifiedName");
        return (GovernanceEngineElement)this.governanceEngineHandler.getBeanByValue(userId, name, "name", "3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", specificMatchPropertyNames, false, false, null, "getGovernanceEngineByName");
    }

    public List<GovernanceEngineElement> getAllGovernanceEngines(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceEngines";
        return this.governanceEngineHandler.getBeansByType(userId, "3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", null, startingFrom, maximumResults, null, "getAllGovernanceEngines");
    }

    public void updateGovernanceEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceEngine";
        String guidParameter = "guid";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceEngine");
        SoftwareServerCapabilityBuilder builder = new SoftwareServerCapabilityBuilder(qualifiedName, displayName, description, typeDescription, version, patchLevel, source, additionalProperties, "3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getInstanceProperties("updateGovernanceEngine");
        this.governanceEngineHandler.updateBeanInRepository(userId, null, null, guid, "guid", "3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", properties, false, "updateGovernanceEngine");
    }

    public void deleteGovernanceEngine(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceEngine";
        String guidParameter = "governanceEngineGUID";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceEngine");
        this.governanceEngineHandler.deleteBeanInRepository(userId, null, null, guid, "governanceEngineGUID", "3fa23d4a-aceb-422f-9301-04ed474c6f74", "GovernanceEngine", "qualifiedName", qualifiedName, false, false, new Date(), "deleteGovernanceEngine");
    }

    public String createGovernanceService(String userId, String typeName, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ConnectorType connectorType;
        String connectorTypeGUID;
        String methodName = "createGovernanceService";
        String connectionParameterName = "createGovernanceService";
        String assetGUIDParameterName = "assetGUID";
        String connectorTypeGUIDParameterName = "connectorTypeGUID";
        String embeddedConnectionGUIDParameterName = "embeddedConnectionGUID ";
        String typeNameParameterName = "typeName";
        this.invalidParameterHandler.validateName(typeName, "typeName", "createGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "createGovernanceService", "createGovernanceService");
        String assetGUID = this.governanceServiceHandler.createAssetInRepository(userId, null, null, qualifiedName, displayName, description, null, typeName, null, InstanceStatus.ACTIVE, "createGovernanceService");
        if (assetGUID != null && (connectorTypeGUID = this.connectorTypeHandler.getConnectorTypeForConnection(userId, null, null, assetGUID, (connectorType = connection.getConnectorType()).getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), "createGovernanceService")) != null) {
            if (connection instanceof VirtualConnection) {
                String connectionGUIDParameterName = "connection.getGUID";
                String connectionGUID = this.connectionHandler.createVirtualConnection(userId, null, null, assetGUID, "assetGUID", connection.getAssetSummary(), connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connectorTypeGUID, "connectorTypeGUID", null, null, "createGovernanceService");
                List embeddedConnections = ((VirtualConnection)connection).getEmbeddedConnections();
                if (embeddedConnections != null) {
                    for (EmbeddedConnection embeddedConnection : embeddedConnections) {
                        if (embeddedConnection == null) continue;
                        String embeddedConnectionGUID = this.connectionHandler.saveConnection(userId, null, null, assetGUID, null, "assetGUID", "GovernanceService", embeddedConnection.getEmbeddedConnection(), null, "createGovernanceService");
                        this.connectionHandler.addEmbeddedConnection(userId, null, null, connectionGUID, "connection.getGUID", embeddedConnection.getPosition(), embeddedConnection.getDisplayName(), embeddedConnection.getArguments(), embeddedConnectionGUID, "embeddedConnectionGUID ", "createGovernanceService");
                    }
                }
            } else {
                this.connectionHandler.createConnection(userId, null, null, assetGUID, "assetGUID", connection.getAssetSummary(), connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connectorTypeGUID, "connectorTypeGUID", null, null, null, null, "createGovernanceService");
            }
        }
        return assetGUID;
    }

    public GovernanceServiceElement getGovernanceServiceByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByGUID";
        String guidParameter = "guid";
        return (GovernanceServiceElement)this.governanceServiceHandler.getAssetWithConnection(userId, guid, "guid", "GovernanceService", null, "getGovernanceServiceByGUID");
    }

    public GovernanceServiceElement getGovernanceServiceByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByName";
        String nameParameter = "name";
        return (GovernanceServiceElement)this.governanceServiceHandler.getAssetByNameWithConnection(userId, name, "name", "191d870c-26f4-4310-a021-b8ca8772719d", "GovernanceService", null, "getGovernanceServiceByName");
    }

    public List<GovernanceServiceElement> getAllGovernanceServices(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        return this.governanceServiceHandler.getAllAssetsWithConnection(userId, "191d870c-26f4-4310-a021-b8ca8772719d", "GovernanceService", startingFrom, maximumResults, null, "getAllGovernanceServices");
    }

    public List<String> getGovernanceServiceRegistrations(String userId, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        String guidParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceServices");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getAllGovernanceServices");
        Date effectiveTime = new Date();
        this.connectionHandler.getBeanFromRepository(userId, governanceServiceGUID, "governanceServiceGUID", "GovernanceService", false, false, effectiveTime, "getAllGovernanceServices");
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, governanceServiceGUID, "GovernanceService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", false, 0, 0, effectiveTime, "getAllGovernanceServices");
        ArrayList<String> results = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getGUID() == null) continue;
                results.add(relationship.getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void updateGovernanceService(String userId, String guid, String qualifiedName, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceService";
        String guidParameter = "guid";
        this.governanceServiceHandler.updateAssetWithConnection(userId, null, null, guid, "guid", qualifiedName, displayName, description, additionalProperties, "191d870c-26f4-4310-a021-b8ca8772719d", "GovernanceService", extendedProperties, null, connection, "updateGovernanceService");
    }

    public void deleteGovernanceService(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceService";
        String qualifiedNameParameter = "qualifiedName";
        String guidParameter = "governanceServiceGUID";
        this.connectionHandler.deleteBeanInRepository(userId, null, null, guid, "governanceServiceGUID", "191d870c-26f4-4310-a021-b8ca8772719d", "GovernanceService", "qualifiedName", qualifiedName, false, false, new Date(), "deleteGovernanceService");
    }

    public void registerGovernanceServiceWithEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, Map<String, String> defaultAnalysisParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerGovernanceServiceWithEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String governanceRequestTypeParameter = "governanceRequestType";
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateName(governanceRequestType, "governanceRequestType", "registerGovernanceServiceWithEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, governanceEngineGUID, "GovernanceEngine", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "registerGovernanceServiceWithEngine");
        while (iterator.moreToReceive()) {
            String existingRequestType;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || !governanceRequestType.equals(existingRequestType = this.repositoryHelper.getStringProperty(this.serviceName, "requestType", supportedGovernanceService.getProperties(), "registerGovernanceServiceWithEngine"))) continue;
            EntityProxy existingGovernanceServiceProxy = supportedGovernanceService.getEntityTwoProxy();
            if (existingGovernanceServiceProxy != null && governanceServiceGUID.equals(existingGovernanceServiceProxy.getGUID())) {
                InstanceProperties properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, supportedGovernanceService.getProperties(), "requestParameters", defaultAnalysisParameters, "registerGovernanceServiceWithEngine");
                this.repositoryHandler.updateRelationshipProperties(userId, null, null, supportedGovernanceService, properties, "registerGovernanceServiceWithEngine");
                return;
            }
            this.repositoryHandler.removeRelationship(userId, null, null, supportedGovernanceService, "registerGovernanceServiceWithEngine");
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "requestType", governanceRequestType, "registerGovernanceServiceWithEngine");
        this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, instanceProperties, "requestParameters", defaultAnalysisParameters, "registerGovernanceServiceWithEngine");
        this.governanceEngineHandler.linkElementToElement(userId, null, null, governanceEngineGUID, "governanceEngineGUID", "GovernanceEngine", governanceServiceGUID, "governanceServiceGUID", "GovernanceService", false, false, "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", instanceProperties, "registerGovernanceServiceWithEngine");
    }

    public RegisteredGovernanceServiceElement getRegisteredGovernanceService(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceService";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getRegisteredGovernanceService");
        List relationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, governanceServiceGUID, "GovernanceService", governanceEngineGUID, "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", false, null, "getRegisteredGovernanceService");
        if (relationships != null) {
            RegisteredGovernanceServiceConverter converter = new RegisteredGovernanceServiceConverter(this.repositoryHelper, this.serviceName);
            return converter.getBean(this.getGovernanceServiceByGUID(userId, governanceServiceGUID), relationships);
        }
        return null;
    }

    public List<String> getRegisteredGovernanceServices(String userId, String governanceEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceServices";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        return this.governanceEngineHandler.getAttachedElementGUIDs(userId, governanceEngineGUID, "governanceEngineGUID", "GovernanceEngine", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", "GovernanceService", false, false, startingFrom, maximumResults, null, "getRegisteredGovernanceServices");
    }

    public void unregisterGovernanceServiceRequestFromEngine(String userId, String requestType, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, governanceEngineGUID, "GovernanceEngine", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "unregisterGovernanceServiceFromEngine");
        while (iterator.moreToReceive()) {
            String existingRequestType;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || !requestType.equals(existingRequestType = this.repositoryHelper.getStringProperty(this.serviceName, "requestType", supportedGovernanceService.getProperties(), "unregisterGovernanceServiceFromEngine"))) continue;
            this.governanceEngineHandler.unlinkElementFromElement(userId, false, null, null, governanceEngineGUID, "governanceEngineGUID", "GovernanceEngine", governanceServiceGUID, "governanceServiceGUID", "191d870c-26f4-4310-a021-b8ca8772719d", "GovernanceService", false, false, "SupportedGovernanceService", supportedGovernanceService, "unregisterGovernanceServiceFromEngine");
            return;
        }
    }

    public void unregisterGovernanceServiceFromEngine(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, userId, governanceEngineGUID, "GovernanceEngine", "2726df0e-4f3a-44e1-8433-4ca5301457fd", "SupportedGovernanceService", false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "unregisterGovernanceServiceFromEngine");
        while (iterator.moreToReceive()) {
            EntityProxy governanceServiceProxy;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || (governanceServiceProxy = supportedGovernanceService.getEntityTwoProxy()) == null || !governanceServiceProxy.getGUID().equals(governanceServiceGUID)) continue;
            this.governanceEngineHandler.unlinkElementFromElement(userId, false, null, null, governanceEngineGUID, "governanceEngineGUID", "GovernanceEngine", governanceServiceGUID, "governanceServiceGUID", "191d870c-26f4-4310-a021-b8ca8772719d", "GovernanceService", false, false, "SupportedGovernanceService", supportedGovernanceService, "unregisterGovernanceServiceFromEngine");
        }
    }
}

