/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionProcessElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.NextGovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionProcessProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.ProcessStatus;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionTypeElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NextGovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NextGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionTypeHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class GovernanceActionProcessRESTServices {
    private static GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceEngineRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GUIDResponse createGovernanceActionProcess(String serverName, String userId, NewGovernanceActionProcessRequestBody requestBody) {
        String methodName = "createGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceActionProcess");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionProcess");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "createGovernanceActionProcess");
                GovernanceActionProcessProperties processProperties = requestBody.getProperties();
                HashMap<String, String> extendedProperties = new HashMap<String, String>();
                extendedProperties.put("formula", processProperties.getFormula());
                extendedProperties.put("implementationLanguage", processProperties.getImplementationLanguage());
                response.setGUID(handler.createAssetInRepository(userId, null, null, processProperties.getQualifiedName(), processProperties.getTechnicalName(), processProperties.getTechnicalDescription(), processProperties.getAdditionalProperties(), "GovernanceActionProcess", extendedProperties, this.getProcessStatus(requestBody.getProcessStatus()), "createGovernanceActionProcess"));
                if (response.getGUID() != null) {
                    handler.maintainSupplementaryProperties(userId, response.getGUID(), processProperties.getQualifiedName(), processProperties.getDisplayName(), processProperties.getSummary(), processProperties.getDescription(), processProperties.getAbbreviation(), processProperties.getUsage(), false, "createGovernanceActionProcess");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private InstanceStatus getProcessStatus(ProcessStatus processStatus) {
        if (processStatus != null) {
            switch (processStatus) {
                case UNKNOWN: {
                    return InstanceStatus.UNKNOWN;
                }
                case DRAFT: {
                    return InstanceStatus.DRAFT;
                }
                case PROPOSED: {
                    return InstanceStatus.PROPOSED;
                }
                case APPROVED: {
                    return InstanceStatus.APPROVED;
                }
                case ACTIVE: {
                    return InstanceStatus.ACTIVE;
                }
            }
        }
        return InstanceStatus.ACTIVE;
    }

    public VoidResponse updateGovernanceActionProcess(String serverName, String userId, String processGUID, UpdateGovernanceActionProcessRequestBody requestBody) {
        String methodName = "updateGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        String newStatusParameterName = "requestBody.getProcessStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionProcess");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "updateGovernanceActionProcess");
                GovernanceActionProcessProperties processProperties = requestBody.getProperties();
                HashMap<String, String> extendedProperties = new HashMap<String, String>();
                extendedProperties.put("formula", processProperties.getFormula());
                extendedProperties.put("implementationLanguage", processProperties.getImplementationLanguage());
                handler.updateAsset(userId, null, null, processGUID, "processGUID", processProperties.getQualifiedName(), processProperties.getTechnicalName(), processProperties.getTechnicalDescription(), processProperties.getAdditionalProperties(), "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", extendedProperties, requestBody.getMergeUpdate(), "updateGovernanceActionProcess");
                if (requestBody.getProcessStatus() != null) {
                    handler.updateBeanStatusInRepository(userId, null, null, processGUID, "processGUID", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", false, false, this.getProcessStatus(requestBody.getProcessStatus()), "requestBody.getProcessStatus", new Date(), "updateGovernanceActionProcess");
                }
                handler.maintainSupplementaryProperties(userId, processGUID, processProperties.getQualifiedName(), processProperties.getDisplayName(), processProperties.getSummary(), processProperties.getDescription(), processProperties.getAbbreviation(), processProperties.getUsage(), requestBody.getMergeUpdate(), "updateGovernanceActionProcess");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishGovernanceActionProcess(String serverName, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "publishGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "publishGovernanceActionProcess");
            handler.publishAsset(userId, processGUID, "processGUID", "publishGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawGovernanceActionProcess(String serverName, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "withdrawGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "withdrawGovernanceActionProcess");
            handler.withdrawAsset(userId, processGUID, "processGUID", "withdrawGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionProcess(String serverName, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "removeGovernanceActionProcess");
            handler.deleteBeanInRepository(userId, null, null, processGUID, "processGUID", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", null, null, false, false, new Date(), "removeGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionProcesses";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionProcesses");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionProcesses");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "findGovernanceActionProcesses");
                response.setElements(handler.findAssets(userId, "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", requestBody.getSearchString(), "searchString", startFrom, pageSize, null, "findGovernanceActionProcesses"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionProcesses", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessesByName");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessesByName");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessesByName");
                response.setElements(handler.findAssetsByName(userId, "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", requestBody.getName(), "name", startFrom, pageSize, null, "getGovernanceActionProcessesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionProcessesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(String serverName, String userId, String processGUID) {
        String methodName = "getGovernanceActionProcessByGUID";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse response = new GovernanceActionProcessElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessByGUID");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessByGUID");
            handler.getBeanFromRepository(userId, processGUID, "processGUID", "GovernanceActionProcess", false, false, new Date(), "getGovernanceActionProcessByGUID");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceActionType(String serverName, String userId, GovernanceActionTypeProperties requestBody) {
        String methodName = "createGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceActionType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionType");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "createGovernanceActionType");
                response.setGUID(handler.createGovernanceActionType(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getSupportedGuards(), requestBody.getAdditionalProperties(), requestBody.getGovernanceEngineGUID(), requestBody.getRequestType(), requestBody.getRequestParameters(), null, null, "createGovernanceActionType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionType(String serverName, String userId, String actionTypeGUID, UpdateGovernanceActionTypeRequestBody requestBody) {
        String methodName = "updateGovernanceActionProcess";
        String propertiesParameterName = "requestBody.getProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionProcess");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "updateGovernanceActionProcess");
                GovernanceActionTypeProperties properties = requestBody.getProperties();
                this.invalidParameterHandler.validateObject((Object)properties, "requestBody.getProperties", "updateGovernanceActionProcess");
                handler.updateGovernanceActionType(userId, actionTypeGUID, requestBody.getMergeUpdate(), properties.getQualifiedName(), properties.getDomainIdentifier(), properties.getDisplayName(), properties.getDescription(), properties.getSupportedGuards(), properties.getAdditionalProperties(), properties.getGovernanceEngineGUID(), properties.getRequestType(), properties.getRequestParameters(), null, null, "updateGovernanceActionProcess");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionType(String serverName, String userId, String actionTypeGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionType");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "removeGovernanceActionType");
            handler.removeGovernanceActionType(userId, actionTypeGUID, "removeGovernanceActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementsResponse findGovernanceActionTypes(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionTypes");
        GovernanceActionTypeElementsResponse response = new GovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionTypes");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "findGovernanceActionTypes");
                if (requestBody.getSearchStringParameterName() != null) {
                    searchStringParameterName = requestBody.getSearchStringParameterName();
                }
                response.setElements(handler.findGovernanceActionTypes(userId, requestBody.getSearchString(), searchStringParameterName, startFrom, pageSize, null, "findGovernanceActionTypes"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionTypes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementsResponse getGovernanceActionTypesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionTypesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionTypesByName");
        GovernanceActionTypeElementsResponse response = new GovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypesByName");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getGovernanceActionTypesByName");
                if (requestBody.getNameParameterName() != null) {
                    nameParameterName = requestBody.getNameParameterName();
                }
                response.setElements(handler.getGovernanceActionTypesByName(userId, requestBody.getName(), nameParameterName, startFrom, pageSize, null, "getGovernanceActionTypesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionTypesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementResponse getGovernanceActionTypeByGUID(String serverName, String userId, String actionTypeGUID) {
        String methodName = "getGovernanceActionTypeByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionTypeByGUID");
        GovernanceActionTypeElementResponse response = new GovernanceActionTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypeByGUID");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getGovernanceActionTypeByGUID");
            response.setElement((GovernanceActionTypeElement)handler.getGovernanceActionTypeByGUID(userId, actionTypeGUID, null, "getGovernanceActionTypeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupFirstActionType(String serverName, String userId, String processGUID, String actionTypeGUID, String requestBody) {
        String methodName = "setupFirstActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupFirstActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupFirstActionType");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "setupFirstActionType");
            handler.setupFirstActionType(userId, processGUID, actionTypeGUID, requestBody, null, null, "setupFirstActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupFirstActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementResponse getFirstActionType(String serverName, String userId, String processGUID) {
        String methodName = "getFirstActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFirstActionType");
        GovernanceActionTypeElementResponse response = new GovernanceActionTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFirstActionType");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getFirstActionType");
            response.setElement((GovernanceActionTypeElement)handler.getFirstActionType(userId, processGUID, null, null, "getFirstActionType"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getFirstActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeFirstActionType(String serverName, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "removeFirstActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeFirstActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeFirstActionType");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "removeFirstActionType");
            handler.removeFirstActionType(userId, processGUID, null, "removeFirstActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeFirstActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupNextActionType(String serverName, String userId, String currentActionTypeGUID, String nextActionTypeGUID, NextGovernanceActionTypeRequestBody requestBody) {
        String methodName = "setupNextActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupNextActionType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "setupNextActionType");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "setupNextActionType");
                response.setGUID(handler.setupNextActionType(userId, currentActionTypeGUID, nextActionTypeGUID, requestBody.getGuard(), requestBody.getMandatoryGuard(), requestBody.getIgnoreMultipleTriggers(), null, null, "setupNextActionType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupNextActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupNextActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNextActionType(String serverName, String userId, String nextActionLinkGUID, NextGovernanceActionTypeRequestBody requestBody) {
        String methodName = "updateNextActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateNextActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNextActionType");
                GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "updateNextActionType");
                handler.updateNextActionType(userId, nextActionLinkGUID, requestBody.getGuard(), requestBody.getMandatoryGuard(), requestBody.getIgnoreMultipleTriggers(), null, null, "updateNextActionType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateNextActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNextActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NextGovernanceActionTypeElementsResponse getNextGovernanceActionTypes(String serverName, String userId, String actionTypeGUID, int startFrom, int pageSize) {
        String methodName = "getNextGovernanceActionTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNextGovernanceActionTypes");
        NextGovernanceActionTypeElementsResponse response = new NextGovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNextGovernanceActionTypes");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "getNextGovernanceActionTypes");
            List relationships = handler.getNextGovernanceActionTypes(userId, actionTypeGUID, startFrom, pageSize, null, "getNextGovernanceActionTypes");
            if (relationships != null) {
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getNextGovernanceActionTypes");
                ArrayList<NextGovernanceActionTypeElement> elements = new ArrayList<NextGovernanceActionTypeElement>();
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    NextGovernanceActionTypeElement element = new NextGovernanceActionTypeElement();
                    element.setNextActionLinkGUID(relationship.getGUID());
                    element.setGuard(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "guard", relationship.getProperties(), "getNextGovernanceActionTypes"));
                    element.setMandatoryGuard(repositoryHelper.getBooleanProperty(instanceHandler.getServiceName(), "mandatoryGuard", relationship.getProperties(), "getNextGovernanceActionTypes"));
                    element.setIgnoreMultipleTriggers(repositoryHelper.getBooleanProperty(instanceHandler.getServiceName(), "ignoreMultipleTriggers", relationship.getProperties(), "getNextGovernanceActionTypes"));
                    element.setNextActionType((GovernanceActionTypeElement)handler.getGovernanceActionTypeByGUID(userId, relationship.getEntityTwoProxy().getGUID(), null, "getNextGovernanceActionTypes"));
                    elements.add(element);
                }
                response.setElements(elements);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNextGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeNextActionType(String serverName, String userId, String actionLinkGUID, NullRequestBody requestBody) {
        String methodName = "removeFirstActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeFirstActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeFirstActionType");
            GovernanceActionTypeHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionTypeHandler(userId, serverName, "removeFirstActionType");
            handler.removeNextActionType(userId, actionLinkGUID, "removeFirstActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeFirstActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

