/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.converters;

import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.IntegrationConnectorElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RegisteredIntegrationConnectorConverter {
    private final OMRSRepositoryHelper repositoryHelper;
    private final String serviceName;

    public RegisteredIntegrationConnectorConverter(OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    public RegisteredIntegrationConnectorElement getBean(IntegrationConnectorElement integrationConnector, Relationship registrationRelationship) {
        InstanceProperties instanceProperties;
        String methodName = "getBean";
        RegisteredIntegrationConnectorElement bean = new RegisteredIntegrationConnectorElement(integrationConnector);
        if (registrationRelationship != null && (instanceProperties = registrationRelationship.getProperties()) != null) {
            RegisteredIntegrationConnectorProperties registrationProperties = new RegisteredIntegrationConnectorProperties();
            bean.setConnectorId(registrationRelationship.getGUID());
            registrationProperties.setConnectorName(this.repositoryHelper.getStringProperty(this.serviceName, "connectorName", instanceProperties, "getBean"));
            registrationProperties.setConnectorUserId(this.repositoryHelper.getStringProperty(this.serviceName, "connectorUserId", instanceProperties, "getBean"));
            registrationProperties.setMetadataSourceQualifiedName(this.repositoryHelper.getStringProperty(this.serviceName, "metadataSourceQualifiedName", instanceProperties, "getBean"));
            registrationProperties.setStartDate(this.repositoryHelper.getDateProperty(this.serviceName, "startDate", instanceProperties, "getBean"));
            registrationProperties.setRefreshTimeInterval(this.repositoryHelper.getLongProperty(this.serviceName, "refreshTimeInterval", instanceProperties, "getBean"));
            registrationProperties.setStopDate(this.repositoryHelper.getDateProperty(this.serviceName, "stopDate", instanceProperties, "getBean"));
            registrationProperties.setGenerateIntegrationReports(this.repositoryHelper.getBooleanProperty(this.serviceName, "generateIntegrationReport", instanceProperties, "getBean"));
            registrationProperties.setPermittedSynchronization(this.removePermittedSynchronization(instanceProperties));
            bean.setRegistrationProperties(registrationProperties);
        }
        return bean;
    }

    PermittedSynchronization removePermittedSynchronization(InstanceProperties instanceProperties) {
        String methodName = "removePermittedSynchronization";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, instanceProperties, "removePermittedSynchronization");
            for (PermittedSynchronization synchronizationDirection : PermittedSynchronization.values()) {
                if (synchronizationDirection.getOpenTypeOrdinal() != ordinal) continue;
                return synchronizationDirection;
            }
        }
        return PermittedSynchronization.BOTH_DIRECTIONS;
    }
}

