/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.converters.CatalogTargetConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceEngineConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceServiceConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.IntegrationConnectorConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.IntegrationGroupConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.RegisteredGovernanceServiceConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.RegisteredIntegrationConnectorConverter;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceEngineElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.IntegrationConnectorElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.IntegrationGroupElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.CatalogTargetProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredGovernanceServiceProperties;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelationshipsIterator;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class GovernanceConfigurationHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final SoftwareCapabilityHandler<GovernanceEngineElement> governanceEngineHandler;
    private final SoftwareCapabilityHandler<IntegrationGroupElement> integrationGroupHandler;
    private final AssetHandler<GovernanceServiceElement> governanceServiceHandler;
    private final AssetHandler<IntegrationConnectorElement> integrationConnectorHandler;
    private final ConnectionHandler<Connection> connectionHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final RegisteredIntegrationConnectorConverter registeredIntegrationConnectorConverter;
    private final CatalogTargetConverter<CatalogTarget> catalogTargetConverter;

    public GovernanceConfigurationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.registeredIntegrationConnectorConverter = new RegisteredIntegrationConnectorConverter(repositoryHelper, serviceName);
        this.catalogTargetConverter = new CatalogTargetConverter(repositoryHelper, serviceName, serverName);
        this.governanceEngineHandler = new SoftwareCapabilityHandler(new GovernanceEngineConverter(repositoryHelper, serviceName, serverName), GovernanceEngineElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.governanceServiceHandler = new AssetHandler(new GovernanceServiceConverter(repositoryHelper, serviceName, serverName), GovernanceServiceElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.integrationGroupHandler = new SoftwareCapabilityHandler(new IntegrationGroupConverter(repositoryHelper, serviceName, serverName), IntegrationGroupElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.integrationConnectorHandler = new AssetHandler(new IntegrationConnectorConverter(repositoryHelper, serviceName, serverName), IntegrationConnectorElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectionHandler = new ConnectionHandler((OpenMetadataAPIGenericConverter)new ConnectionConverter(repositoryHelper, serviceName, serverName), Connection.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceEngine(String userId, String typeName, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceEngine";
        String typeNameParameterName = "typeName";
        this.invalidParameterHandler.validateName(typeName, "typeName", "createGovernanceEngine");
        return this.governanceEngineHandler.createSoftwareCapability(userId, null, null, typeName, null, qualifiedName, displayName, description, DeployedImplementationType.GOVERNANCE_ENGINE.getDeployedImplementationType(), null, null, null, null, null, null, null, null, false, false, new Date(), "createGovernanceEngine");
    }

    public GovernanceEngineElement getGovernanceEngineByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByGUID";
        String guidParameter = "guid";
        return (GovernanceEngineElement)this.governanceEngineHandler.getBeanFromRepository(userId, guid, "guid", OpenMetadataType.GOVERNANCE_ENGINE.typeName, false, false, new Date(), "getGovernanceEngineByGUID");
    }

    public GovernanceEngineElement getGovernanceEngineByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineByName";
        String nameParameter = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        return (GovernanceEngineElement)this.governanceEngineHandler.getBeanByValue(userId, name, "name", OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, specificMatchPropertyNames, false, false, null, null, "getGovernanceEngineByName");
    }

    public List<GovernanceEngineElement> getAllGovernanceEngines(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceEngines";
        return this.governanceEngineHandler.getBeansByType(userId, OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, null, startingFrom, maximumResults, false, false, new Date(), "getAllGovernanceEngines");
    }

    public void updateGovernanceEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceEngine";
        String guidParameter = "guid";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateGovernanceEngine");
        SoftwareCapabilityBuilder builder = new SoftwareCapabilityBuilder(qualifiedName, displayName, description, typeDescription, version, patchLevel, source, additionalProperties, OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getInstanceProperties("updateGovernanceEngine");
        this.governanceEngineHandler.updateBeanInRepository(userId, null, null, guid, "guid", OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, properties, false, "updateGovernanceEngine");
    }

    public void deleteGovernanceEngine(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceEngine";
        String guidParameter = "governanceEngineGUID";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteGovernanceEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteGovernanceEngine");
        this.governanceEngineHandler.deleteBeanInRepository(userId, null, null, guid, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, "qualifiedName", qualifiedName, false, false, new Date(), "deleteGovernanceEngine");
    }

    public String createGovernanceService(String userId, String typeName, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGovernanceService";
        String connectionParameterName = "createGovernanceService";
        String assetGUIDParameterName = "assetGUID";
        String typeNameParameterName = "typeName";
        this.invalidParameterHandler.validateName(typeName, "typeName", "createGovernanceService");
        this.invalidParameterHandler.validateConnection(connection, "createGovernanceService", "createGovernanceService");
        Date effectiveTime = new Date();
        String assetGUID = this.governanceServiceHandler.createAssetInRepository(userId, null, null, qualifiedName, displayName, null, description, null, typeName, null, InstanceStatus.ACTIVE, null, null, effectiveTime, "createGovernanceService");
        if (assetGUID != null) {
            this.connectionHandler.saveConnection(userId, null, null, assetGUID, assetGUID, "assetGUID", typeName, qualifiedName, connection, "Connection to create governance service", false, false, this.governanceEngineHandler.getSupportedZones(), effectiveTime, "createGovernanceService");
        }
        return assetGUID;
    }

    public GovernanceServiceElement getGovernanceServiceByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByGUID";
        String guidParameter = "guid";
        return (GovernanceServiceElement)this.governanceServiceHandler.getAssetWithConnection(userId, guid, "guid", OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, this.governanceServiceHandler.getSupportedZones(), new Date(), "getGovernanceServiceByGUID");
    }

    public GovernanceServiceElement getGovernanceServiceByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServiceByName";
        String nameParameter = "name";
        return (GovernanceServiceElement)this.governanceServiceHandler.getAssetByNameWithConnection(userId, name, "name", OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, this.governanceServiceHandler.getSupportedZones(), new Date(), "getGovernanceServiceByName");
    }

    public List<GovernanceServiceElement> getAllGovernanceServices(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        return this.governanceServiceHandler.getAllAssetsWithConnection(userId, OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, startingFrom, maximumResults, false, false, this.governanceServiceHandler.getSupportedZones(), new Date(), "getAllGovernanceServices");
    }

    public List<String> getGovernanceServiceRegistrations(String userId, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllGovernanceServices";
        String guidParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAllGovernanceServices");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getAllGovernanceServices");
        Date effectiveTime = new Date();
        this.connectionHandler.getBeanFromRepository(userId, governanceServiceGUID, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, effectiveTime, "getAllGovernanceServices");
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, governanceServiceGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", 1, false, false, 0, 0, effectiveTime, "getAllGovernanceServices");
        ArrayList<String> results = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getGUID() == null) continue;
                results.add(relationship.getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void updateGovernanceService(String userId, String guid, String qualifiedName, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGovernanceService";
        String guidParameter = "guid";
        this.governanceServiceHandler.updateAssetWithConnection(userId, null, null, guid, "guid", qualifiedName, displayName, null, description, additionalProperties, OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, extendedProperties, null, null, false, null, connection, false, false, this.governanceServiceHandler.getSupportedZones(), new Date(), "updateGovernanceService");
    }

    public void deleteGovernanceService(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteGovernanceService";
        String qualifiedNameParameter = "qualifiedName";
        String guidParameter = "governanceServiceGUID";
        this.connectionHandler.deleteBeanInRepository(userId, null, null, guid, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, "qualifiedName", qualifiedName, false, false, new Date(), "deleteGovernanceService");
    }

    public void registerGovernanceServiceWithEngine(String userId, String governanceEngineGUID, String governanceServiceGUID, String governanceRequestType, String serviceRequestType, Map<String, String> defaultAnalysisParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerGovernanceServiceWithEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        String governanceRequestTypeParameter = "governanceRequestType";
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "registerGovernanceServiceWithEngine");
        this.invalidParameterHandler.validateName(governanceRequestType, "governanceRequestType", "registerGovernanceServiceWithEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, governanceEngineGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, 2, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "registerGovernanceServiceWithEngine");
        while (iterator.moreToReceive()) {
            String existingRequestType;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || !governanceRequestType.equals(existingRequestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, supportedGovernanceService.getProperties(), "registerGovernanceServiceWithEngine"))) continue;
            EntityProxy existingGovernanceServiceProxy = supportedGovernanceService.getEntityTwoProxy();
            if (existingGovernanceServiceProxy != null && governanceServiceGUID.equals(existingGovernanceServiceProxy.getGUID())) {
                InstanceProperties properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, supportedGovernanceService.getProperties(), OpenMetadataProperty.REQUEST_PARAMETERS.name, defaultAnalysisParameters, "registerGovernanceServiceWithEngine");
                properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, serviceRequestType, "registerGovernanceServiceWithEngine");
                this.repositoryHandler.updateRelationshipProperties(userId, null, null, supportedGovernanceService, properties, "registerGovernanceServiceWithEngine");
                return;
            }
            this.repositoryHandler.removeRelationship(userId, null, null, supportedGovernanceService, "registerGovernanceServiceWithEngine");
        }
        InstanceProperties instanceProperties = new InstanceProperties();
        this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.REQUEST_TYPE.name, governanceRequestType, "registerGovernanceServiceWithEngine");
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, serviceRequestType, "registerGovernanceServiceWithEngine");
        instanceProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.REQUEST_PARAMETERS.name, defaultAnalysisParameters, "registerGovernanceServiceWithEngine");
        this.governanceEngineHandler.multiLinkElementToElement(userId, null, null, governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, governanceServiceGUID, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, this.governanceEngineHandler.getSupportedZones(), OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, instanceProperties, new Date(), "registerGovernanceServiceWithEngine");
    }

    public RegisteredGovernanceServiceElement getRegisteredGovernanceService(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceService";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "getRegisteredGovernanceService");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "getRegisteredGovernanceService");
        List relationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, governanceServiceGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, governanceEngineGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, 1, false, false, null, "getRegisteredGovernanceService");
        if (relationships != null) {
            RegisteredGovernanceServiceConverter converter = new RegisteredGovernanceServiceConverter(this.repositoryHelper, this.serviceName);
            return converter.getBean(this.getGovernanceServiceByGUID(userId, governanceServiceGUID), relationships);
        }
        return null;
    }

    public List<RegisteredGovernanceServiceElement> getRegisteredGovernanceServices(String userId, String governanceEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredGovernanceServices";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        List relationships = this.governanceEngineHandler.getAttachmentLinks(userId, governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, null, OpenMetadataType.GOVERNANCE_SERVICE.typeName, 2, false, false, startingFrom, maximumResults, new Date(), "getRegisteredGovernanceServices");
        if (relationships != null) {
            HashMap<String, RegisteredGovernanceServiceElement> governanceServices = new HashMap<String, RegisteredGovernanceServiceElement>();
            for (Relationship relationship : relationships) {
                String requestType;
                EntityProxy end2 = relationship.getEntityTwoProxy();
                RegisteredGovernanceServiceElement governanceService = (RegisteredGovernanceServiceElement)governanceServices.get(end2.getGUID());
                if (governanceService == null) {
                    try {
                        GovernanceServiceElement newElement = this.getGovernanceServiceByGUID(userId, end2.getGUID());
                        if (newElement != null) {
                            governanceService = new RegisteredGovernanceServiceElement(newElement);
                            governanceServices.put(end2.getGUID(), governanceService);
                        }
                    }
                    catch (Exception newElement) {
                        // empty catch block
                    }
                }
                if (governanceService == null || (requestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, relationship.getProperties(), "getRegisteredGovernanceServices")) == null) continue;
                RegisteredGovernanceServiceProperties relationshipProperties = new RegisteredGovernanceServiceProperties();
                relationshipProperties.setServiceRequestType(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, relationship.getProperties(), "getRegisteredGovernanceServices"));
                relationshipProperties.setRequestParameters(this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, relationship.getProperties(), "getRegisteredGovernanceServices"));
                HashMap<String, RegisteredGovernanceServiceProperties> requestTypes = governanceService.getProperties().getRequestTypes();
                if (requestTypes == null) {
                    requestTypes = new HashMap<String, RegisteredGovernanceServiceProperties>();
                }
                requestTypes.put(requestType, relationshipProperties);
                governanceService.getProperties().setRequestTypes(requestTypes);
            }
            if (!governanceServices.isEmpty()) {
                return new ArrayList<RegisteredGovernanceServiceElement>(governanceServices.values());
            }
        }
        return null;
    }

    public void unregisterGovernanceServiceRequestFromEngine(String userId, String requestType, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, governanceEngineGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, 2, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "unregisterGovernanceServiceFromEngine");
        while (iterator.moreToReceive()) {
            String existingRequestType;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || !requestType.equals(existingRequestType = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, supportedGovernanceService.getProperties(), "unregisterGovernanceServiceFromEngine"))) continue;
            this.governanceEngineHandler.unlinkElementFromElement(userId, false, null, null, governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, governanceServiceGUID, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, supportedGovernanceService, new Date(), "unregisterGovernanceServiceFromEngine");
            return;
        }
    }

    public void unregisterGovernanceServiceFromEngine(String userId, String governanceEngineGUID, String governanceServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterGovernanceServiceFromEngine";
        String governanceEngineGUIDParameter = "governanceEngineGUID";
        String governanceServiceGUIDParameter = "governanceServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceEngineGUID, "governanceEngineGUID", "unregisterGovernanceServiceFromEngine");
        this.invalidParameterHandler.validateGUID(governanceServiceGUID, "governanceServiceGUID", "unregisterGovernanceServiceFromEngine");
        RepositoryRelationshipsIterator iterator = new RepositoryRelationshipsIterator(this.repositoryHandler, this.invalidParameterHandler, userId, governanceEngineGUID, OpenMetadataType.GOVERNANCE_ENGINE.typeName, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, 2, false, false, 0, this.invalidParameterHandler.getMaxPagingSize(), null, "unregisterGovernanceServiceFromEngine");
        while (iterator.moreToReceive()) {
            EntityProxy governanceServiceProxy;
            Relationship supportedGovernanceService = iterator.getNext();
            if (supportedGovernanceService == null || (governanceServiceProxy = supportedGovernanceService.getEntityTwoProxy()) == null || !governanceServiceProxy.getGUID().equals(governanceServiceGUID)) continue;
            this.governanceEngineHandler.unlinkElementFromElement(userId, false, null, null, governanceEngineGUID, "governanceEngineGUID", OpenMetadataType.GOVERNANCE_ENGINE.typeName, governanceServiceGUID, "governanceServiceGUID", OpenMetadataType.GOVERNANCE_SERVICE.typeGUID, OpenMetadataType.GOVERNANCE_SERVICE.typeName, false, false, OpenMetadataType.SUPPORTED_GOVERNANCE_SERVICE_RELATIONSHIP.typeName, supportedGovernanceService, new Date(), "unregisterGovernanceServiceFromEngine");
        }
    }

    public String createIntegrationGroup(String userId, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationGroup";
        return this.integrationGroupHandler.createSoftwareCapability(userId, null, null, OpenMetadataType.INTEGRATION_GROUP.typeName, null, properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), DeployedImplementationType.INTEGRATION_GROUP.getDeployedImplementationType(), properties.getVersion(), properties.getPatchLevel(), properties.getSource(), properties.getAdditionalProperties(), null, null, null, null, false, false, new Date(), "createIntegrationGroup");
    }

    public IntegrationGroupElement getIntegrationGroupByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByGUID";
        String guidParameter = "guid";
        return (IntegrationGroupElement)this.integrationGroupHandler.getBeanFromRepository(userId, guid, "guid", OpenMetadataType.INTEGRATION_GROUP.typeName, false, false, new Date(), "getIntegrationGroupByGUID");
    }

    public IntegrationGroupElement getIntegrationGroupByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByName";
        String nameParameter = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        return (IntegrationGroupElement)this.integrationGroupHandler.getBeanByValue(userId, name, "name", OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, specificMatchPropertyNames, false, false, null, null, "getIntegrationGroupByName");
    }

    public List<IntegrationGroupElement> getAllIntegrationGroups(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationGroups";
        return this.integrationGroupHandler.getBeansByType(userId, OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, null, startingFrom, maximumResults, false, false, new Date(), "getAllIntegrationGroups");
    }

    public void updateIntegrationGroup(String userId, String guid, boolean isMergeUpdate, IntegrationGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationGroup";
        String guidParameter = "guid";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateIntegrationGroup");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateIntegrationGroup");
        }
        SoftwareCapabilityBuilder builder = new SoftwareCapabilityBuilder(properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), properties.getTypeDescription(), properties.getVersion(), properties.getPatchLevel(), properties.getSource(), properties.getAdditionalProperties(), OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, null, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties instanceProperties = builder.getInstanceProperties("updateIntegrationGroup");
        this.integrationGroupHandler.updateBeanInRepository(userId, null, null, guid, "guid", OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, instanceProperties, isMergeUpdate, "updateIntegrationGroup");
    }

    public void deleteIntegrationGroup(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationGroup";
        String guidParameter = "integrationGroupGUID";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteIntegrationGroup");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteIntegrationGroup");
        this.integrationGroupHandler.deleteBeanInRepository(userId, null, null, guid, "integrationGroupGUID", OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, "qualifiedName", qualifiedName, false, false, new Date(), "deleteIntegrationGroup");
    }

    public String createIntegrationConnector(String userId, String qualifiedName, String versionIdentifier, String displayName, String description, boolean usesBlockingCalls, Map<String, String> additionalProperties, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationConnector";
        String connectionParameterName = "createIntegrationConnector";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateConnection(connection, "createIntegrationConnector", "createIntegrationConnector");
        Date effectiveTime = new Date();
        HashMap<String, Boolean> extendedProperties = new HashMap<String, Boolean>();
        extendedProperties.put("usesBlockingCalls", usesBlockingCalls);
        String assetGUID = this.integrationConnectorHandler.createAssetInRepository(userId, null, null, qualifiedName, displayName, versionIdentifier, description, additionalProperties, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, extendedProperties, InstanceStatus.ACTIVE, null, null, effectiveTime, "createIntegrationConnector");
        if (assetGUID != null) {
            this.connectionHandler.saveConnection(userId, null, null, assetGUID, assetGUID, "assetGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, qualifiedName, connection, "Connection to create integration connector", false, false, this.connectionHandler.getSupportedZones(), effectiveTime, "createIntegrationConnector");
        }
        return assetGUID;
    }

    public IntegrationConnectorElement getIntegrationConnectorByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByGUID";
        String guidParameter = "guid";
        return (IntegrationConnectorElement)this.integrationConnectorHandler.getAssetWithConnection(userId, guid, "guid", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, false, false, this.integrationConnectorHandler.getSupportedZones(), new Date(), "getIntegrationConnectorByGUID");
    }

    public IntegrationConnectorElement getIntegrationConnectorByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByName";
        String nameParameter = "name";
        return (IntegrationConnectorElement)this.integrationConnectorHandler.getAssetByNameWithConnection(userId, name, "name", OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, false, false, this.integrationConnectorHandler.getSupportedZones(), new Date(), "getIntegrationConnectorByName");
    }

    public List<IntegrationConnectorElement> getAllIntegrationConnectors(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationConnectors";
        return this.integrationConnectorHandler.getAllAssetsWithConnection(userId, OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, startingFrom, maximumResults, false, false, this.integrationConnectorHandler.getSupportedZones(), new Date(), "getAllIntegrationConnectors");
    }

    public List<String> getIntegrationConnectorRegistrations(String userId, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationConnectors";
        String guidParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAllIntegrationConnectors");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getAllIntegrationConnectors");
        Date effectiveTime = new Date();
        this.connectionHandler.getEntityFromRepository(userId, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, null, false, false, effectiveTime, "getAllIntegrationConnectors");
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, integrationConnectorGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", 1, false, false, 0, 0, effectiveTime, "getAllIntegrationConnectors");
        ArrayList<String> results = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getEntityOneProxy().getGUID() == null) continue;
                results.add(relationship.getEntityOneProxy().getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void updateIntegrationConnector(String userId, String guid, boolean isMergeUpdate, String qualifiedName, String versionIdentifier, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationConnector";
        String guidParameter = "guid";
        this.integrationConnectorHandler.updateAssetWithConnection(userId, null, null, guid, "guid", qualifiedName, displayName, versionIdentifier, description, additionalProperties, OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, extendedProperties, null, null, isMergeUpdate, null, connection, false, false, this.integrationConnectorHandler.getSupportedZones(), new Date(), "updateIntegrationConnector");
    }

    public void deleteIntegrationConnector(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationConnector";
        String qualifiedNameParameter = "qualifiedName";
        String guidParameter = "integrationConnectorGUID";
        this.connectionHandler.deleteBeanInRepository(userId, null, null, guid, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, "qualifiedName", qualifiedName, false, false, new Date(), "deleteIntegrationConnector");
    }

    public void registerIntegrationConnectorWithGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID, String connectorName, String connectorUserId, String metadataSourceQualifiedName, Date startDate, long refreshTimeInterval, Date stopDate, PermittedSynchronization permittedSynchronization) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerIntegrationConnectorWithGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String governanceRequestTypeParameter = "connectorName";
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateName(connectorName, "connectorName", "registerIntegrationConnectorWithGroup");
        InstanceProperties instanceProperties = new InstanceProperties();
        this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "connectorName", connectorName, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "connectorUserId", connectorUserId, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "metadataSourceQualifiedName", metadataSourceQualifiedName, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.START_DATE.name, startDate, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, instanceProperties, "refreshTimeInterval", refreshTimeInterval, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, instanceProperties, "stopDate", stopDate, "registerIntegrationConnectorWithGroup");
        if (permittedSynchronization != null) {
            try {
                instanceProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, "973a9f4c-93fa-43a5-a0c5-d97dbd164e78", "PermittedSynchronization", permittedSynchronization.getOpenTypeOrdinal(), "registerIntegrationConnectorWithGroup");
            }
            catch (TypeErrorException error) {
                throw new InvalidParameterException((OCFCheckedExceptionBase)error, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name);
            }
        }
        this.integrationGroupHandler.linkElementToElement(userId, null, null, integrationGroupGUID, "integrationGroupGUID", OpenMetadataType.INTEGRATION_GROUP.typeName, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, false, false, this.integrationGroupHandler.getSupportedZones(), "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", instanceProperties, null, null, new Date(), "registerIntegrationConnectorWithGroup");
    }

    public RegisteredIntegrationConnectorElement getRegisteredIntegrationConnector(String userId, String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnector";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getRegisteredIntegrationConnector");
        List relationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, integrationConnectorGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, integrationGroupGUID, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", 1, false, false, null, "getRegisteredIntegrationConnector");
        if (relationships != null && !relationships.isEmpty()) {
            return this.registeredIntegrationConnectorConverter.getBean(this.getIntegrationConnectorByGUID(userId, integrationConnectorGUID), (Relationship)relationships.get(0));
        }
        return null;
    }

    public List<RegisteredIntegrationConnectorElement> getRegisteredIntegrationConnectors(String userId, String integrationGroupGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnectors";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        List relationships = this.integrationGroupHandler.getAttachmentLinks(userId, integrationGroupGUID, "integrationGroupGUID", OpenMetadataType.INTEGRATION_GROUP.typeName, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", null, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, 2, false, false, startingFrom, maximumResults, new Date(), "getRegisteredIntegrationConnectors");
        if (relationships != null) {
            ArrayList<RegisteredIntegrationConnectorElement> results = new ArrayList<RegisteredIntegrationConnectorElement>();
            for (Relationship relationship : relationships) {
                IntegrationConnectorElement connectorElement = this.getIntegrationConnectorByGUID(userId, relationship.getEntityTwoProxy().getGUID());
                results.add(this.registeredIntegrationConnectorConverter.getBean(connectorElement, relationship));
            }
            return results;
        }
        return null;
    }

    public void unregisterIntegrationConnectorFromGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterIntegrationConnectorFromGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "unregisterIntegrationConnectorFromGroup");
        this.integrationGroupHandler.unlinkElementFromElement(userId, false, null, null, integrationGroupGUID, "integrationGroupGUID", OpenMetadataType.INTEGRATION_GROUP.typeName, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, false, false, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", new Date(), "unregisterIntegrationConnectorFromGroup");
    }

    public void addCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCatalogTarget";
        String propertiesParameterName = "properties";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "addCatalogTarget");
        InstanceProperties instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "catalogTargetName", properties.getCatalogTargetName(), "addCatalogTarget");
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "metadataSourceQualifiedName", properties.getMetadataSourceQualifiedName(), "addCatalogTarget");
        instanceProperties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, instanceProperties, "configurationProperties", properties.getConfigurationProperties(), "addCatalogTarget");
        this.integrationGroupHandler.linkElementToElement(userId, null, null, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, this.integrationGroupHandler.getSupportedZones(), "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", instanceProperties, null, null, new Date(), "addCatalogTarget");
    }

    public CatalogTarget getCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTarget");
        List relationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, integrationConnectorGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, metadataElementGUID, "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", 2, false, false, null, "getCatalogTarget");
        if (relationships != null && !relationships.isEmpty()) {
            return this.catalogTargetConverter.getNewBean(CatalogTarget.class, (Relationship)relationships.get(0), "getCatalogTarget");
        }
        return null;
    }

    public List<CatalogTarget> getCatalogTargets(String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTargets";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTargets");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTargets");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getCatalogTargets");
        List relationships = this.integrationGroupHandler.getAttachmentLinks(userId, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", null, OpenMetadataType.OPEN_METADATA_ROOT.typeName, 2, false, false, startingFrom, maximumResults, new Date(), "getCatalogTargets");
        if (relationships != null) {
            ArrayList<CatalogTarget> results = new ArrayList<CatalogTarget>();
            for (Relationship relationship : relationships) {
                results.add(this.catalogTargetConverter.getNewBean(CatalogTarget.class, relationship, "getCatalogTargets"));
            }
            return results;
        }
        return null;
    }

    public void removeCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "removeCatalogTarget");
        this.integrationGroupHandler.unlinkElementFromElement(userId, false, null, null, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", new Date(), "removeCatalogTarget");
    }
}

