/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.connectors.outtopic.GovernanceEngineOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceActionConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceActionProcessConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceActionTypeConverter;
import org.odpi.openmetadata.accessservices.governanceengine.converters.MetadataElementConverter;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineErrorCode;
import org.odpi.openmetadata.accessservices.governanceengine.handlers.GovernanceConfigurationHandler;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.EngineActionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionProcessStepHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class GovernanceEngineInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription myDescription = AccessServiceDescription.GOVERNANCE_ENGINE_OMAS;
    private final GovernanceConfigurationHandler governanceConfigurationHandler;
    private final MetadataElementHandler<OpenMetadataElement> metadataElementHandler;
    private final EngineActionHandler<GovernanceActionElement> engineActionHandler;
    private final AssetHandler<GovernanceActionProcessElement> governanceActionProcessHandler;
    private final GovernanceActionProcessStepHandler<GovernanceActionTypeElement> governanceActionProcessStepHandler;

    public GovernanceEngineInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, List<String> publishedZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection outTopicEventBusConnection) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, publishedZones, auditLog, localServerUserId, maxPageSize, null, null, GovernanceEngineOutTopicClientProvider.class.getName(), outTopicEventBusConnection);
        String methodName = "new ServiceInstance";
        if (this.repositoryHandler == null) {
            throw new NewInstanceException(GovernanceEngineErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.governanceConfigurationHandler = new GovernanceConfigurationHandler(this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.metadataElementHandler = new MetadataElementHandler(new MetadataElementConverter(this.repositoryHelper, this.serviceName, this.serverName), OpenMetadataElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.engineActionHandler = new EngineActionHandler(new GovernanceActionConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.governanceActionProcessHandler = new AssetHandler(new GovernanceActionProcessConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionProcessElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
        this.governanceActionProcessStepHandler = new GovernanceActionProcessStepHandler(new GovernanceActionTypeConverter(this.repositoryHelper, this.serviceName, this.serverName), GovernanceActionTypeElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, this.publishZones, auditLog);
    }

    GovernanceConfigurationHandler getGovernanceConfigurationHandler() {
        return this.governanceConfigurationHandler;
    }

    public MetadataElementHandler<OpenMetadataElement> getMetadataElementHandler() {
        return this.metadataElementHandler;
    }

    AssetHandler<GovernanceActionProcessElement> getGovernanceActionProcessHandler() {
        return this.governanceActionProcessHandler;
    }

    GovernanceActionProcessStepHandler<GovernanceActionTypeElement> getGovernanceActionProcessStepHandler() {
        return this.governanceActionProcessStepHandler;
    }

    public EngineActionHandler<GovernanceActionElement> getEngineActionHandler() {
        return this.engineActionHandler;
    }
}

