/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.outtopic;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.converters.GovernanceEngineOMASConverter;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.MetadataElement;
import org.odpi.openmetadata.accessservices.governanceengine.outtopic.GovernanceEngineOutTopicPublisher;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogClassificationEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementOrigin;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementVersions;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworkservices.gaf.handlers.MetadataElementHandler;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListenerBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceEngineOMRSTopicListener
extends OMRSTopicListenerBase {
    private final GovernanceEngineOutTopicPublisher eventPublisher;
    private final OMRSRepositoryHelper repositoryHelper;
    private final MetadataElementHandler<OpenMetadataElement> metadataElementHandler;
    private final String userId;
    private final String serverName;
    private final GovernanceEngineOMASConverter<MetadataElement> converter;

    public GovernanceEngineOMRSTopicListener(String serviceName, String serverName, String userId, MetadataElementHandler<OpenMetadataElement> metadataElementHandler, GovernanceEngineOutTopicPublisher eventPublisher, OMRSRepositoryHelper repositoryHelper, AuditLog auditLog) {
        super(serviceName, auditLog);
        this.metadataElementHandler = metadataElementHandler;
        this.userId = userId;
        this.serverName = serverName;
        this.eventPublisher = eventPublisher;
        this.repositoryHelper = repositoryHelper;
        this.converter = new GovernanceEngineOMASConverter(repositoryHelper, serviceName, metadataElementHandler.getServerName());
    }

    private AttachedClassification getClassification(Classification classification) {
        if (classification != null) {
            AttachedClassification beanClassification = new AttachedClassification();
            this.converter.fillElementControlHeader((ElementControlHeader)beanClassification, (InstanceAuditHeader)classification);
            beanClassification.setClassificationName(classification.getName());
            if (classification.getProperties() != null) {
                beanClassification.setClassificationProperties(this.converter.mapElementProperties(classification.getProperties()));
                beanClassification.setEffectiveFromTime(classification.getProperties().getEffectiveFromTime());
                beanClassification.setEffectiveToTime(classification.getProperties().getEffectiveToTime());
            }
            return beanClassification;
        }
        return null;
    }

    private OpenMetadataRelationship getRelatedElements(Relationship relationship) {
        if (relationship != null) {
            TypeDef typeDef;
            OpenMetadataRelationship openMetadataRelationship = new OpenMetadataRelationship();
            this.converter.fillElementControlHeader((ElementControlHeader)openMetadataRelationship, (InstanceAuditHeader)relationship);
            openMetadataRelationship.setRelationshipGUID(relationship.getGUID());
            openMetadataRelationship.setRelationshipType(this.converter.getElementType((InstanceAuditHeader)relationship));
            if (relationship.getProperties() != null) {
                openMetadataRelationship.setRelationshipProperties(this.converter.mapElementProperties(relationship.getProperties()));
                openMetadataRelationship.setEffectiveFromTime(relationship.getProperties().getEffectiveFromTime());
                openMetadataRelationship.setEffectiveToTime(relationship.getProperties().getEffectiveToTime());
            }
            if (relationship.getEntityOneProxy() != null) {
                openMetadataRelationship.setElementGUIDAtEnd1(relationship.getEntityOneProxy().getGUID());
                ElementStub elementStub = new ElementStub();
                this.fillElementControlHeader((ElementControlHeader)elementStub, (InstanceAuditHeader)relationship.getEntityOneProxy());
                elementStub.setUniqueName(this.getQualifiedName(relationship.getEntityOneProxy().getUniqueProperties()));
                openMetadataRelationship.setElementAtEnd1(elementStub);
            }
            if (relationship.getEntityTwoProxy() != null) {
                openMetadataRelationship.setElementGUIDAtEnd2(relationship.getEntityTwoProxy().getGUID());
            }
            if ((typeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, relationship.getType().getTypeDefName())) instanceof RelationshipDef) {
                RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                openMetadataRelationship.setLabelAtEnd1(relationshipDef.getEndDef1().getAttributeName());
                openMetadataRelationship.setLabelAtEnd2(relationshipDef.getEndDef2().getAttributeName());
            }
            return openMetadataRelationship;
        }
        return null;
    }

    public void fillElementControlHeader(ElementControlHeader elementControlHeader, InstanceAuditHeader header) {
        if (header != null) {
            elementControlHeader.setStatus(this.getElementStatus(header.getStatus()));
            elementControlHeader.setType(this.getElementType(header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementControlHeader.setOrigin(elementOrigin);
            elementControlHeader.setVersions(this.getElementVersions(header));
        }
    }

    protected ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case DELETED: {
                    return ElementStatus.DELETED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    public ElementType getElementType(InstanceAuditHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            String typeDefName = instanceType.getTypeDefName();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, typeDefName);
            elementType.setTypeId(instanceType.getTypeDefGUID());
            elementType.setTypeName(typeDefName);
            elementType.setTypeVersion(instanceType.getTypeDefVersion());
            elementType.setTypeDescription(typeDef.getDescription());
            List typeDefSuperTypes = this.repositoryHelper.getSuperTypes(this.serviceName, typeDefName);
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    protected ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            return switch (instanceProvenanceType) {
                default -> throw new IncompatibleClassChangeError();
                case InstanceProvenanceType.DEREGISTERED_REPOSITORY -> ElementOriginCategory.DEREGISTERED_REPOSITORY;
                case InstanceProvenanceType.EXTERNAL_SOURCE -> ElementOriginCategory.EXTERNAL_SOURCE;
                case InstanceProvenanceType.EXPORT_ARCHIVE -> ElementOriginCategory.EXPORT_ARCHIVE;
                case InstanceProvenanceType.LOCAL_COHORT -> ElementOriginCategory.LOCAL_COHORT;
                case InstanceProvenanceType.CONTENT_PACK -> ElementOriginCategory.CONTENT_PACK;
                case InstanceProvenanceType.CONFIGURATION -> ElementOriginCategory.CONFIGURATION;
                case InstanceProvenanceType.UNKNOWN -> ElementOriginCategory.UNKNOWN;
            };
        }
        return ElementOriginCategory.UNKNOWN;
    }

    protected ElementVersions getElementVersions(InstanceAuditHeader header) {
        ElementVersions elementVersions = new ElementVersions();
        elementVersions.setCreatedBy(header.getCreatedBy());
        elementVersions.setCreateTime(header.getCreateTime());
        elementVersions.setUpdatedBy(header.getUpdatedBy());
        elementVersions.setUpdateTime(header.getUpdateTime());
        elementVersions.setMaintainedBy(header.getMaintainedBy());
        elementVersions.setVersion(header.getVersion());
        return elementVersions;
    }

    protected String getQualifiedName(InstanceProperties instanceProperties) {
        String methodName = "getQualifiedName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, instanceProperties, "getQualifiedName");
        }
        return null;
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, EntityDetail entity, EntityDetail previousEntity, String methodName) {
        if (entity != null) {
            try {
                WatchdogMetadataElementEvent watchdogEvent = new WatchdogMetadataElementEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setMetadataElement((OpenMetadataElement)this.metadataElementHandler.getMetadataElementByGUID(this.userId, entity.getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName));
                if (previousEntity != null) {
                    watchdogEvent.setPreviousMetadataElement((OpenMetadataElement)this.metadataElementHandler.getMetadataElementByGUID(this.userId, previousEntity.getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, EntitySummary entity, Classification classification, Classification previousClassification, String methodName) {
        if (entity != null) {
            try {
                WatchdogClassificationEvent watchdogEvent = new WatchdogClassificationEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setMetadataElement((OpenMetadataElement)this.metadataElementHandler.getMetadataElementByGUID(this.userId, entity.getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName));
                watchdogEvent.setChangedClassification(this.getClassification(classification));
                if (previousClassification != null) {
                    watchdogEvent.setChangedClassification(this.getClassification(previousClassification));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, entity.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, entity.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    private void processWatchdogEvent(String sourceName, WatchdogEventType eventType, Relationship relationship, Relationship previousRelationship, String methodName) {
        if (relationship != null) {
            try {
                this.metadataElementHandler.getMetadataElementByGUID(this.userId, relationship.getEntityOneProxy().getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName);
                this.metadataElementHandler.getMetadataElementByGUID(this.userId, relationship.getEntityTwoProxy().getGUID(), true, false, this.metadataElementHandler.getSupportedZones(), null, new Date(), methodName);
                WatchdogRelatedElementsEvent watchdogEvent = new WatchdogRelatedElementsEvent();
                watchdogEvent.setEventType(eventType);
                watchdogEvent.setRelatedMetadataElements(this.getRelatedElements(relationship));
                if (previousRelationship != null) {
                    watchdogEvent.setPreviousRelatedMetadataElements(this.getRelatedElements(previousRelationship));
                }
                this.eventPublisher.publishWatchdogEvent((WatchdogGovernanceEvent)watchdogEvent);
            }
            catch (InvalidParameterException error) {
                this.auditLog.logMessage(methodName, GovernanceEngineAuditCode.SKIPPING_INSTANCE.getMessageDefinition(new String[]{sourceName, methodName, relationship.getGUID(), error.getMessage()}));
            }
            catch (Exception error) {
                this.auditLog.logException(methodName, GovernanceEngineAuditCode.EVENT_PROCESSING_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), sourceName, methodName, relationship.getGUID(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_ELEMENT, entity, null, "processNewEntityEvent");
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_ELEMENT_PROPERTIES, newEntity, oldEntity, "processUpdatedEntityEvent");
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_ELEMENT_PROPERTIES, entity, null, "processUndoneEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_CLASSIFICATION, (EntitySummary)entity, classification, null, "processClassifiedEntityEvent");
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent(proxy)";
        this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_CLASSIFICATION, (EntitySummary)entity, classification, null, "processClassifiedEntityEvent(proxy)");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_CLASSIFICATION, (EntitySummary)entity, originalClassification, null, "processDeclassifiedEntityEvent");
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_CLASSIFICATION, (EntitySummary)entity, originalClassification, null, "processDeclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES, (EntitySummary)entity, classification, originalClassification, "processReclassifiedEntityEvent");
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_CLASSIFICATION_PROPERTIES, (EntitySummary)entity, classification, originalClassification, "processReclassifiedEntityEvent");
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_ELEMENT, entity, null, "processDeletedEntityEvent");
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletePurgedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_ELEMENT, entity, null, "processDeletePurgedEntityEvent");
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processRestoredEntityEvent");
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processReIdentifiedEntityEvent");
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processReTypedEntityEvent");
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processReHomedEntityEvent");
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRefreshEntityEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_ELEMENT, entity, null, "processRefreshEntityEvent");
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.NEW_RELATIONSHIP, relationship, null, "processNewRelationshipEvent");
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.UPDATED_RELATIONSHIP_PROPERTIES, newRelationship, oldRelationship, "processUpdatedRelationshipEvent");
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processUndoneRelationshipEvent");
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_RELATIONSHIP, relationship, null, "processDeletedRelationshipEvent");
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletePurgedRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.DELETED_RELATIONSHIP, relationship, null, "processDeletePurgedRelationshipEvent");
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processRestoredRelationshipEvent");
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processReIdentifiedRelationshipEvent");
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processReTypedRelationshipEvent");
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processReHomedRelationshipEvent");
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRefreshRelationshipEvent";
        this.processWatchdogEvent(sourceName, WatchdogEventType.REFRESHED_RELATIONSHIP, relationship, null, "processRefreshRelationshipEvent");
    }
}

