/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.NextGovernanceActionTypeElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionTypeElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NextGovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NextGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceActionProcessStepHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class GovernanceActionProcessRESTServices {
    private static final GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceEngineRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GUIDResponse createGovernanceActionProcess(String serverName, String userId, NewGovernanceActionProcessRequestBody requestBody) {
        String methodName = "createGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceActionProcess");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionProcess");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "createGovernanceActionProcess");
                GovernanceActionProcessProperties processProperties = requestBody.getProperties();
                HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
                extendedProperties.put(OpenMetadataProperty.FORMULA.name, processProperties.getFormula());
                extendedProperties.put(OpenMetadataProperty.FORMULA_TYPE.name, processProperties.getFormulaType());
                extendedProperties.put("domainIdentifier", processProperties.getDomainIdentifier());
                Date effectiveTime = new Date();
                response.setGUID(handler.createAssetInRepository(userId, null, null, processProperties.getQualifiedName(), processProperties.getDisplayName(), processProperties.getVersionIdentifier(), processProperties.getDescription(), null, processProperties.getAdditionalProperties(), "GovernanceActionProcess", extendedProperties, this.getProcessStatus(requestBody.getProcessStatus()), null, null, effectiveTime, "createGovernanceActionProcess"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private InstanceStatus getProcessStatus(ProcessStatus processStatus) {
        if (processStatus != null) {
            return switch (processStatus) {
                default -> throw new IncompatibleClassChangeError();
                case ProcessStatus.UNKNOWN -> InstanceStatus.UNKNOWN;
                case ProcessStatus.DRAFT -> InstanceStatus.DRAFT;
                case ProcessStatus.PROPOSED -> InstanceStatus.PROPOSED;
                case ProcessStatus.APPROVED -> InstanceStatus.APPROVED;
                case ProcessStatus.ACTIVE -> InstanceStatus.ACTIVE;
            };
        }
        return InstanceStatus.ACTIVE;
    }

    public VoidResponse updateGovernanceActionProcess(String serverName, String userId, String processGUID, UpdateGovernanceActionProcessRequestBody requestBody) {
        String methodName = "updateGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        String newStatusParameterName = "requestBody.getProcessStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null && requestBody.getProperties() != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionProcess");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "updateGovernanceActionProcess");
                GovernanceActionProcessProperties processProperties = requestBody.getProperties();
                HashMap<String, String> extendedProperties = new HashMap<String, String>();
                extendedProperties.put(OpenMetadataProperty.FORMULA.name, processProperties.getFormula());
                extendedProperties.put(OpenMetadataProperty.FORMULA_TYPE.name, processProperties.getFormulaType());
                Date effectiveTime = new Date();
                handler.updateAsset(userId, null, null, processGUID, "processGUID", processProperties.getQualifiedName(), processProperties.getVersionIdentifier(), processProperties.getDisplayName(), processProperties.getDescription(), null, processProperties.getAdditionalProperties(), "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", extendedProperties, null, null, requestBody.getMergeUpdate(), false, false, effectiveTime, "updateGovernanceActionProcess");
                if (requestBody.getProcessStatus() != null) {
                    handler.updateBeanStatusInRepository(userId, null, null, processGUID, "processGUID", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", false, false, this.getProcessStatus(requestBody.getProcessStatus()), "requestBody.getProcessStatus", effectiveTime, "updateGovernanceActionProcess");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishGovernanceActionProcess(String serverName, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "publishGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "publishGovernanceActionProcess");
            handler.publishAsset(userId, processGUID, "processGUID", false, false, new Date(), "publishGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawGovernanceActionProcess(String serverName, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "withdrawGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "withdrawGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "withdrawGovernanceActionProcess");
            handler.withdrawAsset(userId, processGUID, "processGUID", false, false, new Date(), "withdrawGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionProcess(String serverName, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionProcess");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "removeGovernanceActionProcess");
            handler.deleteBeanInRepository(userId, null, null, processGUID, "processGUID", "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", null, null, false, false, new Date(), "removeGovernanceActionProcess");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionProcesses";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionProcesses");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionProcesses");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "findGovernanceActionProcesses");
                response.setElements(handler.findAssets(userId, "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findGovernanceActionProcesses"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionProcesses", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessesByName");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessesByName");
                AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessesByName");
                response.setElements(handler.findAssetsByName(userId, "4d3a2b8d-9e2e-4832-b338-21c74e45b238", "GovernanceActionProcess", requestBody.getName(), "name", startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getGovernanceActionProcessesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionProcessesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(String serverName, String userId, String processGUID) {
        String methodName = "getGovernanceActionProcessByGUID";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse response = new GovernanceActionProcessElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessByGUID");
            AssetHandler<GovernanceActionProcessElement> handler = instanceHandler.getGovernanceActionProcessHandler(userId, serverName, "getGovernanceActionProcessByGUID");
            handler.getBeanFromRepository(userId, processGUID, "processGUID", "GovernanceActionProcess", false, false, new Date(), "getGovernanceActionProcessByGUID");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceActionType(String serverName, String userId, GovernanceActionTypeProperties requestBody) {
        String methodName = "createGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGovernanceActionType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionType");
                GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "createGovernanceActionType");
                response.setGUID(handler.createGovernanceActionProcessStep(userId, requestBody.getQualifiedName(), requestBody.getDomainIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getAdditionalProperties(), requestBody.getGovernanceEngineGUID(), requestBody.getRequestType(), requestBody.getRequestParameters(), requestBody.getIgnoreMultipleTriggers(), requestBody.getWaitTime(), null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, "createGovernanceActionType"), new Date(), "createGovernanceActionType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionType(String serverName, String userId, String actionTypeGUID, UpdateGovernanceActionTypeRequestBody requestBody) {
        String methodName = "updateGovernanceActionProcess";
        String propertiesParameterName = "requestBody.getProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionProcess");
                GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "updateGovernanceActionProcess");
                GovernanceActionTypeProperties properties = requestBody.getProperties();
                this.invalidParameterHandler.validateObject((Object)properties, "requestBody.getProperties", "updateGovernanceActionProcess");
                handler.updateGovernanceActionProcessStep(userId, actionTypeGUID, requestBody.getMergeUpdate(), properties.getQualifiedName(), properties.getDomainIdentifier(), properties.getDisplayName(), properties.getDescription(), properties.getAdditionalProperties(), properties.getGovernanceEngineGUID(), properties.getRequestType(), properties.getRequestParameters(), properties.getIgnoreMultipleTriggers(), properties.getWaitTime(), null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, "updateGovernanceActionProcess"), new Date(), "updateGovernanceActionProcess");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionType(String serverName, String userId, String actionTypeGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeGovernanceActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionType");
            GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "removeGovernanceActionType");
            handler.removeGovernanceActionProcessStep(userId, actionTypeGUID, false, false, instanceHandler.getSupportedZones(userId, serverName, "removeGovernanceActionType"), new Date(), "removeGovernanceActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementsResponse findGovernanceActionTypes(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActionTypes";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActionTypes");
        GovernanceActionTypeElementsResponse response = new GovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionTypes");
                GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "findGovernanceActionTypes");
                if (requestBody.getSearchStringParameterName() != null) {
                    searchStringParameterName = requestBody.getSearchStringParameterName();
                }
                response.setElements(handler.findGovernanceActionProcessSteps(userId, requestBody.getSearchString(), searchStringParameterName, startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "findGovernanceActionTypes"), new Date(), "findGovernanceActionTypes"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionTypes", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementsResponse getGovernanceActionTypesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionTypesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionTypesByName");
        GovernanceActionTypeElementsResponse response = new GovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypesByName");
                GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "getGovernanceActionTypesByName");
                if (requestBody.getNameParameterName() != null) {
                    nameParameterName = requestBody.getNameParameterName();
                }
                response.setElements(handler.getGovernanceActionProcessStepsByName(userId, requestBody.getName(), nameParameterName, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, "getGovernanceActionTypesByName"), null, "getGovernanceActionTypesByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionTypesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementResponse getGovernanceActionTypeByGUID(String serverName, String userId, String actionTypeGUID) {
        String methodName = "getGovernanceActionTypeByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionTypeByGUID");
        GovernanceActionTypeElementResponse response = new GovernanceActionTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypeByGUID");
            GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "getGovernanceActionTypeByGUID");
            response.setElement((GovernanceActionTypeElement)handler.getGovernanceActionProcessStepByGUID(userId, actionTypeGUID, instanceHandler.getSupportedZones(userId, serverName, "getGovernanceActionTypeByGUID"), null, "getGovernanceActionTypeByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupFirstActionType(String serverName, String userId, String processGUID, String actionTypeGUID, String requestBody) {
        String methodName = "setupFirstActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupFirstActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupFirstActionType");
            GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "setupFirstActionType");
            handler.setupFirstProcessStep(userId, processGUID, actionTypeGUID, requestBody, null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, "setupFirstActionType"), new Date(), "setupFirstActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupFirstActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeElementResponse getFirstActionType(String serverName, String userId, String processGUID) {
        String methodName = "getFirstActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getFirstActionType");
        GovernanceActionTypeElementResponse response = new GovernanceActionTypeElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFirstActionType");
            GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "getFirstActionType");
            response.setElement((GovernanceActionTypeElement)handler.getFirstProcessStep(userId, processGUID, null, instanceHandler.getSupportedZones(userId, serverName, "getFirstActionType"), null, "getFirstActionType"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getFirstActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeFirstActionType(String serverName, String userId, String processGUID, NullRequestBody requestBody) {
        String methodName = "removeFirstActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeFirstActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeFirstActionType");
            GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "removeFirstActionType");
            handler.removeFirstProcessStep(userId, processGUID, instanceHandler.getSupportedZones(userId, serverName, "removeFirstActionType"), null, "removeFirstActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeFirstActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupNextActionType(String serverName, String userId, String currentActionTypeGUID, String nextActionTypeGUID, NextGovernanceActionTypeRequestBody requestBody) {
        String methodName = "setupNextActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupNextActionType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "setupNextActionType");
                GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "setupNextActionType");
                response.setGUID(handler.setupNextProcessStep(userId, currentActionTypeGUID, nextActionTypeGUID, requestBody.getGuard(), requestBody.getMandatoryGuard(), null, null, false, false, instanceHandler.getSupportedZones(userId, serverName, "setupNextActionType"), new Date(), "setupNextActionType"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "setupNextActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupNextActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNextActionType(String serverName, String userId, String nextActionLinkGUID, NextGovernanceActionTypeRequestBody requestBody) {
        String methodName = "updateNextActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateNextActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNextActionType");
                GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "updateNextActionType");
                handler.updateNextProcessStep(userId, nextActionLinkGUID, requestBody.getGuard(), requestBody.getMandatoryGuard(), null, null, "updateNextActionType");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateNextActionType", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNextActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NextGovernanceActionTypeElementsResponse getNextGovernanceActionTypes(String serverName, String userId, String actionTypeGUID, int startFrom, int pageSize) {
        String methodName = "getNextGovernanceActionTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNextGovernanceActionTypes");
        NextGovernanceActionTypeElementsResponse response = new NextGovernanceActionTypeElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNextGovernanceActionTypes");
            GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "getNextGovernanceActionTypes");
            List relationships = handler.getNextGovernanceActionProcessSteps(userId, actionTypeGUID, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, "getNextGovernanceActionTypes"), null, "getNextGovernanceActionTypes");
            if (relationships != null) {
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, "getNextGovernanceActionTypes");
                ArrayList<NextGovernanceActionTypeElement> elements = new ArrayList<NextGovernanceActionTypeElement>();
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    NextGovernanceActionTypeElement element = new NextGovernanceActionTypeElement();
                    element.setNextActionLinkGUID(relationship.getGUID());
                    element.setGuard(repositoryHelper.getStringProperty(instanceHandler.getServiceName(), "guard", relationship.getProperties(), "getNextGovernanceActionTypes"));
                    element.setMandatoryGuard(repositoryHelper.getBooleanProperty(instanceHandler.getServiceName(), "mandatoryGuard", relationship.getProperties(), "getNextGovernanceActionTypes"));
                    element.setNextActionType((GovernanceActionTypeElement)handler.getGovernanceActionProcessStepByGUID(userId, relationship.getEntityTwoProxy().getGUID(), instanceHandler.getSupportedZones(userId, serverName, "getNextGovernanceActionTypes"), null, "getNextGovernanceActionTypes"));
                    elements.add(element);
                }
                response.setElements(elements);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNextGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeNextActionType(String serverName, String userId, String actionLinkGUID, NullRequestBody requestBody) {
        String methodName = "removeNextActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeNextActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeNextActionType");
            GovernanceActionProcessStepHandler<GovernanceActionTypeElement> handler = instanceHandler.getGovernanceActionProcessStepHandler(userId, serverName, "removeNextActionType");
            handler.removeNextProcessStep(userId, actionLinkGUID, "removeNextActionType");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeNextActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

