/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.EngineActionHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.slf4j.LoggerFactory;

public class GovernanceEngineRESTServices {
    private static final GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceEngineRESTServices.class), instanceHandler.getServiceName());

    public OCFConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        OCFConnectionResponse response = new OCFConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse logAssetAuditMessage(String serverName, String userId, String assetGUID, String governanceService, String message) {
        String methodName = "logAssetAuditMessage";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "logAssetAuditMessage");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "logAssetAuditMessage");
            auditLog.logMessage("logAssetAuditMessage", GovernanceEngineAuditCode.ASSET_AUDIT_LOG.getMessageDefinition(new String[]{assetGUID, governanceService, message}));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "logAssetAuditMessage", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionStatus(String serverName, String userId, String governanceActionGUID, StatusRequestBody requestBody) {
        String methodName = "updateGovernanceActionStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGovernanceActionStatus");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionStatus");
            if (requestBody != null) {
                EngineActionHandler<GovernanceActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "updateGovernanceActionStatus");
                int statusOrdinal = GovernanceActionStatus.ACTIONED.getOpenTypeOrdinal();
                if (requestBody.getStatus() != null) {
                    statusOrdinal = requestBody.getStatus().getOpenTypeOrdinal();
                }
                handler.updateEngineActionStatus(userId, governanceActionGUID, statusOrdinal, instanceHandler.getSupportedZones(userId, serverName, "updateGovernanceActionStatus"), new Date(), "updateGovernanceActionStatus");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionStatus", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementResponse getGovernanceAction(String serverName, String userId, String governanceActionGUID) {
        String methodName = "getGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceAction");
        AuditLog auditLog = null;
        GovernanceActionElementResponse response = new GovernanceActionElementResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceAction");
            EngineActionHandler<GovernanceActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getGovernanceAction");
            response.setElement((GovernanceActionElement)handler.getEngineAction(userId, governanceActionGUID, instanceHandler.getSupportedZones(userId, serverName, "getGovernanceAction"), new Date(), "getGovernanceAction"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse claimGovernanceAction(String serverName, String userId, String governanceActionGUID, NullRequestBody requestBody) {
        String methodName = "claimGovernanceAction";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "claimGovernanceAction");
        AuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "claimGovernanceAction");
            EngineActionHandler<GovernanceActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "claimGovernanceAction");
            handler.claimEngineAction(userId, governanceActionGUID, instanceHandler.getSupportedZones(userId, serverName, "claimGovernanceAction"), new Date(), "claimGovernanceAction");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "claimGovernanceAction", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getGovernanceActions(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActions");
            EngineActionHandler<GovernanceActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getGovernanceActions");
            response.setElements(handler.getEngineActions(userId, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, "getGovernanceActions"), new Date(), "getGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getActiveGovernanceActions(String serverName, String userId, int startFrom, int pageSize) {
        String methodName = "getActiveGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveGovernanceActions");
            EngineActionHandler<GovernanceActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getActiveGovernanceActions");
            response.setElements(handler.getActiveEngineActions(userId, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, "getActiveGovernanceActions"), new Date(), "getActiveGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getActiveClaimedGovernanceActions(String serverName, String userId, String governanceEngineGUID, int startFrom, int pageSize) {
        String methodName = "getActiveClaimedGovernanceActions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveClaimedGovernanceActions");
        AuditLog auditLog = null;
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActiveClaimedGovernanceActions");
            EngineActionHandler<GovernanceActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getActiveClaimedGovernanceActions");
            response.setElements(handler.getActiveClaimedEngineActions(userId, governanceEngineGUID, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, "getActiveClaimedGovernanceActions"), new Date(), "getActiveClaimedGovernanceActions"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveClaimedGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse findGovernanceActions(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findGovernanceActions";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGovernanceActions");
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActions");
                EngineActionHandler<GovernanceActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "findGovernanceActions");
                if (requestBody.getSearchStringParameterName() != null) {
                    searchStringParameterName = requestBody.getSearchStringParameterName();
                }
                response.setElements(handler.findEngineActions(userId, requestBody.getSearchString(), searchStringParameterName, startFrom, pageSize, false, false, instanceHandler.getSupportedZones(userId, serverName, "findGovernanceActions"), new Date(), "findGovernanceActions"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActions", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionElementsResponse getGovernanceActionsByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getGovernanceActionsByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceActionsByName");
        GovernanceActionElementsResponse response = new GovernanceActionElementsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionsByName");
                EngineActionHandler<GovernanceActionElement> handler = instanceHandler.getEngineActionHandler(userId, serverName, "getGovernanceActionsByName");
                if (requestBody.getNameParameterName() != null) {
                    nameParameterName = requestBody.getNameParameterName();
                }
                response.setElements(handler.getEngineActionsByName(userId, requestBody.getName(), nameParameterName, startFrom, pageSize, instanceHandler.getSupportedZones(userId, serverName, "getGovernanceActionsByName"), null, "getGovernanceActionsByName"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionsByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

