/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server;

import org.odpi.openmetadata.accessservices.governanceengine.handlers.GovernanceConfigurationHandler;
import org.odpi.openmetadata.accessservices.governanceengine.properties.CatalogTargetProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CatalogTargetResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredIntegrationConnectorsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class IntegrationConfigRESTServices {
    private static final GovernanceEngineInstanceHandler instanceHandler = new GovernanceEngineInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(IntegrationConfigRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createIntegrationGroup(String serverName, String userId, IntegrationGroupProperties requestBody) {
        String methodName = "createIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIntegrationGroup");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "createIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createIntegrationGroup");
            if (requestBody != null) {
                response.setGUID(handler.createIntegrationGroup(userId, requestBody));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementResponse getIntegrationGroupByGUID(String serverName, String userId, String guid) {
        String methodName = "getIntegrationGroupByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupByGUID");
        IntegrationGroupElementResponse response = new IntegrationGroupElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getIntegrationGroupByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupByGUID");
            response.setElement(handler.getIntegrationGroupByGUID(userId, guid));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementResponse getIntegrationGroupByName(String serverName, String userId, String name) {
        String methodName = "getIntegrationGroupByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupByName");
        IntegrationGroupElementResponse response = new IntegrationGroupElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getIntegrationGroupByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupByName");
            response.setElement(handler.getIntegrationGroupByName(userId, name));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementsResponse getAllIntegrationGroups(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllIntegrationGroups";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllIntegrationGroups");
        IntegrationGroupElementsResponse response = new IntegrationGroupElementsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getAllIntegrationGroups");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllIntegrationGroups");
            response.setElements(handler.getAllIntegrationGroups(userId, startingFrom, maximumResults));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllIntegrationGroups", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateIntegrationGroup(String serverName, String userId, String guid, boolean isMergeUpdate, IntegrationGroupProperties requestBody) {
        String methodName = "updateIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateIntegrationGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "updateIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateIntegrationGroup");
            if (requestBody != null) {
                handler.updateIntegrationGroup(userId, guid, isMergeUpdate, requestBody);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteIntegrationGroup(String serverName, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteIntegrationGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "deleteIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteIntegrationGroup");
            if (requestBody != null) {
                handler.deleteIntegrationGroup(userId, guid, requestBody.getQualifiedName());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createIntegrationConnector(String serverName, String userId, IntegrationConnectorProperties requestBody) {
        String methodName = "createIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIntegrationConnector");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "createIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createIntegrationConnector");
            if (requestBody != null) {
                response.setGUID(handler.createIntegrationConnector(userId, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getDeployedImplementationType(), requestBody.getUsesBlockingCalls(), requestBody.getAdditionalProperties(), requestBody.getConnection()));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementResponse getIntegrationConnectorByGUID(String serverName, String userId, String guid) {
        String methodName = "getIntegrationConnectorByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorByGUID");
        IntegrationConnectorElementResponse response = new IntegrationConnectorElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getIntegrationConnectorByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorByGUID");
            response.setElement(handler.getIntegrationConnectorByGUID(userId, guid));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementResponse getIntegrationConnectorByName(String serverName, String userId, String name) {
        String methodName = "getIntegrationConnectorByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorByName");
        IntegrationConnectorElementResponse response = new IntegrationConnectorElementResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getIntegrationConnectorByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorByName");
            response.setElement(handler.getIntegrationConnectorByName(userId, name));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementsResponse getAllIntegrationConnectors(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllIntegrationConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllIntegrationConnectors");
        IntegrationConnectorElementsResponse response = new IntegrationConnectorElementsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getAllIntegrationConnectors");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllIntegrationConnectors");
            response.setElements(handler.getAllIntegrationConnectors(userId, startingFrom, maximumResults));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllIntegrationConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getIntegrationConnectorRegistrations(String serverName, String userId, String integrationConnectorGUID) {
        String methodName = "getIntegrationConnectorRegistrations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorRegistrations");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getIntegrationConnectorRegistrations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorRegistrations");
            response.setGUIDs(handler.getIntegrationConnectorRegistrations(userId, integrationConnectorGUID));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorRegistrations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateIntegrationConnector(String serverName, String userId, String guid, boolean isMergeUpdate, IntegrationConnectorProperties requestBody) {
        String methodName = "updateIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateIntegrationConnector");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "updateIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateIntegrationConnector");
            if (requestBody != null) {
                handler.updateIntegrationConnector(userId, guid, isMergeUpdate, requestBody.getQualifiedName(), requestBody.getName(), requestBody.getVersionIdentifier(), requestBody.getDescription(), requestBody.getDeployedImplementationType(), requestBody.getConnection(), requestBody.getAdditionalProperties(), null);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteIntegrationConnector(String serverName, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteIntegrationConnector");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "deleteIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteIntegrationConnector");
            if (requestBody != null) {
                handler.deleteIntegrationConnector(userId, guid, requestBody.getQualifiedName());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse registerIntegrationConnectorWithGroup(String serverName, String userId, String integrationGroupGUID, String integrationConnectorGUID, RegisteredIntegrationConnectorProperties requestBody) {
        String methodName = "registerIntegrationConnectorWithEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "registerIntegrationConnectorWithEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "registerIntegrationConnectorWithEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "registerIntegrationConnectorWithEngine");
            if (requestBody != null) {
                handler.registerIntegrationConnectorWithGroup(userId, integrationGroupGUID, integrationConnectorGUID, requestBody.getConnectorName(), requestBody.getConnectorUserId(), requestBody.getMetadataSourceQualifiedName(), requestBody.getStartDate(), requestBody.getRefreshTimeInterval(), requestBody.getStopDate(), requestBody.getPermittedSynchronization());
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "registerIntegrationConnectorWithEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "registerIntegrationConnectorWithEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredIntegrationConnectorResponse getRegisteredIntegrationConnector(String serverName, String userId, String integrationGroupGUID, String integrationConnectorGUID) {
        String methodName = "getRegisteredIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredIntegrationConnector");
        RegisteredIntegrationConnectorResponse response = new RegisteredIntegrationConnectorResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getRegisteredIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredIntegrationConnector");
            response.setRegisteredIntegrationConnector(handler.getRegisteredIntegrationConnector(userId, integrationGroupGUID, integrationConnectorGUID));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredIntegrationConnectorsResponse getRegisteredIntegrationConnectors(String serverName, String userId, String integrationGroupGUID, int startingFrom, int maximumResults) {
        String methodName = "getRegisteredIntegrationConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredIntegrationConnectors");
        RegisteredIntegrationConnectorsResponse response = new RegisteredIntegrationConnectorsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getRegisteredIntegrationConnectors");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredIntegrationConnectors");
            response.setElements(handler.getRegisteredIntegrationConnectors(userId, integrationGroupGUID, startingFrom, maximumResults));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredIntegrationConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterIntegrationConnectorFromGroup(String serverName, String userId, String integrationGroupGUID, String integrationConnectorGUID, NullRequestBody requestBody) {
        String methodName = "unregisterIntegrationConnectorFromGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterIntegrationConnectorFromGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "unregisterIntegrationConnectorFromGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterIntegrationConnectorFromGroup");
            handler.unregisterIntegrationConnectorFromGroup(userId, integrationGroupGUID, integrationConnectorGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unregisterIntegrationConnectorFromGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCatalogTarget(String serverName, String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties requestBody) {
        String methodName = "addCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCatalogTarget");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "addCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCatalogTarget");
            if (requestBody != null) {
                response.setGUID(handler.addCatalogTarget(userId, integrationConnectorGUID, metadataElementGUID, requestBody));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCatalogTarget", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCatalogTarget(String serverName, String userId, String relationshipGUID, CatalogTargetProperties requestBody) {
        String methodName = "updateCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCatalogTarget");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "updateCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCatalogTarget");
            if (requestBody != null) {
                handler.updateCatalogTarget(userId, relationshipGUID, requestBody);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateCatalogTarget", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetResponse getCatalogTarget(String serverName, String userId, String relationshipGUID) {
        String methodName = "getCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCatalogTarget");
        CatalogTargetResponse response = new CatalogTargetResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTarget");
            response.setElement(handler.getCatalogTarget(userId, relationshipGUID));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetsResponse getCatalogTargets(String serverName, String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) {
        String methodName = "getCatalogTargets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCatalogTargets");
        CatalogTargetsResponse response = new CatalogTargetsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "getCatalogTargets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTargets");
            response.setElements(handler.getCatalogTargets(userId, integrationConnectorGUID, startingFrom, maximumResults));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTargets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCatalogTarget(String serverName, String userId, String relationshipGUID, NullRequestBody requestBody) {
        String methodName = "removeCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeCatalogTarget");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            GovernanceConfigurationHandler handler = instanceHandler.getGovernanceConfigurationHandler(userId, serverName, "removeCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeCatalogTarget");
            handler.removeCatalogTarget(userId, relationshipGUID);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

