/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.spring;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDefAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernanceClassificationDefListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRESTServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/governance-engine/users/{userId}"})
public class GovernanceEngineOMASResource {
    private GovernanceEngineRESTServices restAPI = new GovernanceEngineRESTServices();
    private static final Logger log = LoggerFactory.getLogger(GovernanceEngineOMASResource.class);

    public GovernanceEngineOMASResource() {
        String methodName = "initialize";
        log.debug(">>initialize");
        log.debug("<<initialize");
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/classificationdefs"})
    public GovernanceClassificationDefListAPIResponse getGovernanceClassificationDefs(@PathVariable String userId, @RequestParam(value="classification", required=false) List<String> classification) {
        return this.restAPI.getGovernanceClassificationDefs(userId, classification);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/classificationdefs/{classificationGuid}"})
    GovernanceClassificationDefAPIResponse getGovernanceClassificationDef(@PathVariable String userId, @PathVariable String classificationGuid) {
        return this.restAPI.getClassificationDefs(userId, classificationGuid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets"})
    GovernedAssetListAPIResponse getGovernedAssets(@PathVariable String userId, @RequestParam(value="classification", required=false) List<String> classification, @RequestParam(value="type", required=false) List<String> type) {
        return this.restAPI.getGovernedAssets(userId, classification, type);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetComponentGuid}"})
    public GovernedAssetAPIResponse getGovernedAsset(@PathVariable String userId, @PathVariable String assetGuid) {
        return this.restAPI.getGovernedAsset(userId, assetGuid);
    }
}

