/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.spring;

import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.GovernedAssetListAPIResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.SoftwareServerCapabilityRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.api.objects.SoftwareServerCapabilityResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-engine/users/{userId}"})
public class GovernanceEngineOMASResource {
    private GovernanceEngineRESTServices restAPI = new GovernanceEngineRESTServices();

    @GetMapping(path={"/assets"}, produces={"application/json"})
    public GovernedAssetListAPIResponse getGovernedAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="type", required=false) List<String> type) {
        return this.restAPI.getGovernedAssets(serverName, userId, type);
    }

    @GetMapping(path={"/assets/{assetGuid}"}, produces={"application/json"})
    public GovernedAssetAPIResponse getGovernedAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGuid) {
        return this.restAPI.getGovernedAsset(serverName, userId, assetGuid);
    }

    @PostMapping(path={"/software-server-capabilities"})
    public SoftwareServerCapabilityResponse createSoftwareServerCapability(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody SoftwareServerCapabilityRequestBody requestBody) {
        return this.restAPI.createSoftwareServer(serverName, userId, requestBody);
    }

    @GetMapping(path={"/software-server-capabilities/{guid}"})
    public SoftwareServerCapabilityResponse getSoftwareServerCapabilityByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSoftwareServerByGUID(serverName, userId, guid);
    }
}

