/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.GovernedAssetListResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.GovernedAssetResponse;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.SoftwareServerCapabilityRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.api.model.SoftwareServerCapabilityResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.services.GovernanceEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-engine/users/{userId}"})
@Tag(name="Governance Engine OMAS", description="The Governance Engine Open Metadata Access Service (OMAS) provides access to metadata for policy enforcement frameworks such as Apache Ranger.", externalDocs=@ExternalDocumentation(description="Governance Engine Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/governance-engine/"))
public class GovernanceEngineOMASResource {
    private GovernanceEngineRESTServices restAPI = new GovernanceEngineRESTServices();

    @GetMapping(path={"/assets"}, produces={"application/json"})
    public GovernedAssetListResponse getGovernedAssets(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="entityTypes", required=false) List<String> entityTypes, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return this.restAPI.getGovernedAssets(serverName, userId, entityTypes, offset, pageSize);
    }

    @GetMapping(path={"/assets/{assetGuid}"}, produces={"application/json"})
    public GovernedAssetResponse getGovernedAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGuid) {
        return this.restAPI.getGovernedAsset(serverName, userId, assetGuid);
    }

    @PostMapping(path={"/software-server-capabilities"})
    public StringResponse createSoftwareServerCapability(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody SoftwareServerCapabilityRequestBody requestBody) {
        return this.restAPI.createSoftwareServer(serverName, userId, requestBody);
    }

    @GetMapping(path={"/software-server-capabilities/{guid}"})
    public SoftwareServerCapabilityResponse getSoftwareServerCapabilityByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSoftwareServerByGUID(serverName, userId, guid);
    }
}

