/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ConsolidatedDuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.PeerDuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-engine/users/{userId}"})
@Tag(name="Governance Engine OMAS", description="The Governance Engine Open Metadata Access Service (OMAS) provides support for governance engines, services and actions.", externalDocs=@ExternalDocumentation(description="Governance Engine Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-engine/overview/"))
public class GovernanceEngineOMASResource {
    private final GovernanceEngineRESTServices restAPI = new GovernanceEngineRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/assets/{assetGUID}/log-records/{governanceService}"})
    public VoidResponse logAssetAuditMessage(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String governanceService, @RequestBody String message) {
        return this.restAPI.logAssetAuditMessage(serverName, userId, assetGUID, governanceService, message);
    }

    @PostMapping(path={"/governance-actions/action-targets/update"})
    public VoidResponse updateActionTargetStatus(@PathVariable String serverName, @PathVariable String userId, @RequestBody ActionTargetStatusRequestBody requestBody) {
        return this.restAPI.updateActionTargetStatus(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-actions/{governanceActionGUID}/status/update"})
    public VoidResponse updateGovernanceActionStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID, @RequestBody StatusRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionStatus(serverName, userId, governanceActionGUID, requestBody);
    }

    @PostMapping(path={"/governance-actions/{governanceActionGUID}/completion-status"})
    public VoidResponse recordCompletionStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID, @RequestBody CompletionStatusRequestBody requestBody) {
        return this.restAPI.recordCompletionStatus(serverName, userId, governanceActionGUID, requestBody);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineName}/governance-actions/initiate"})
    public GUIDResponse initiateGovernanceAction(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineName, @RequestBody GovernanceActionRequestBody requestBody) {
        return this.restAPI.initiateGovernanceAction(serverName, userId, governanceEngineName, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/initiate"})
    public GUIDResponse initiateGovernanceActionProcess(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionProcess(serverName, userId, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/related-elements/link-as-peer-duplicate"})
    public VoidResponse linkElementsAsPeerDuplicates(@PathVariable String serverName, @PathVariable String userId, @RequestBody PeerDuplicatesRequestBody requestBody) {
        return this.restAPI.linkElementsAsDuplicates(serverName, userId, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/related-elements/link-as-consolidated-duplicate"})
    public VoidResponse linkConsolidatedDuplicate(@PathVariable String serverName, @PathVariable String userId, @RequestBody ConsolidatedDuplicatesRequestBody requestBody) {
        return this.restAPI.linkConsolidatedDuplicate(serverName, userId, requestBody);
    }

    @GetMapping(path={"/governance-actions/{governanceActionGUID}"})
    public GovernanceActionElementResponse getGovernanceAction(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID) {
        return this.restAPI.getGovernanceAction(serverName, userId, governanceActionGUID);
    }

    @PostMapping(path={"/governance-actions/{governanceActionGUID}/claim"})
    public VoidResponse claimGovernanceAction(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.claimGovernanceAction(serverName, userId, governanceActionGUID, requestBody);
    }

    @GetMapping(path={"/governance-actions"})
    public GovernanceActionElementsResponse getGovernanceActions(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceActions(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-actions/active"})
    public GovernanceActionElementsResponse getActiveGovernanceActions(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveGovernanceActions(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/active-governance-actions"})
    public GovernanceActionElementsResponse getActiveClaimedGovernanceActions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveClaimedGovernanceActions(serverName, userId, governanceEngineGUID, startFrom, pageSize);
    }
}

