/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceEngineElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceEngineElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceServiceRegistrationRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceEngineRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceServiceRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredGovernanceServiceResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceEngineRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceServiceRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceConfigRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-engine/users/{userId}"})
@Tag(name="Governance Engine OMAS", description="The Governance Engine Open Metadata Access Service (OMAS) provides support for governance engines, services and actions.", externalDocs=@ExternalDocumentation(description="Governance Engine Open Metadata Access Service (OMAS)", url="https://odpi.github.io/egeria-docs/services/omas/governance-engine/overview/"))
public class EngineConfigurationResource {
    private GovernanceConfigRESTServices restAPI = new GovernanceConfigRESTServices();

    @PostMapping(path={"/governance-engines/new/{typeName}"})
    public GUIDResponse createGovernanceEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @RequestBody NewGovernanceEngineRequestBody requestBody) {
        return this.restAPI.createGovernanceEngine(serverName, userId, typeName, requestBody);
    }

    @GetMapping(path={"/governance-engines/{guid}"})
    public GovernanceEngineElementResponse getGovernanceEngineByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceEngineByGUID(serverName, userId, guid);
    }

    @GetMapping(path={"/governance-engines/by-name/{name}"})
    public GovernanceEngineElementResponse getGovernanceEngineByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getGovernanceEngineByName(serverName, userId, name);
    }

    @GetMapping(path={"/governance-engines"})
    public GovernanceEngineElementsResponse getAllGovernanceEngines(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllGovernanceEngines(serverName, userId, startingFrom, maximumResults);
    }

    @PostMapping(path={"/governance-engines/{guid}/update"})
    public VoidResponse updateGovernanceEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody UpdateGovernanceEngineRequestBody requestBody) {
        return this.restAPI.updateGovernanceEngine(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-engines/{guid}/delete"})
    public VoidResponse deleteGovernanceEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteGovernanceEngine(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-services/new/{typeName}"})
    public GUIDResponse createGovernanceService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String typeName, @RequestBody NewGovernanceServiceRequestBody requestBody) {
        return this.restAPI.createGovernanceService(serverName, userId, typeName, requestBody);
    }

    @GetMapping(path={"/governance-services/{guid}"})
    public GovernanceServiceElementResponse getGovernanceServiceByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceServiceByGUID(serverName, userId, guid);
    }

    @GetMapping(path={"/governance-services/by-name/{name}"})
    public GovernanceServiceElementResponse getGovernanceServiceByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getGovernanceServiceByName(serverName, userId, name);
    }

    @GetMapping(path={"/governance-services"})
    public GovernanceServiceElementsResponse getAllGovernanceServices(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllGovernanceServices(serverName, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/governance-services/{guid}/registrations"})
    public GUIDListResponse getGovernanceServiceRegistrations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGovernanceServiceRegistrations(serverName, userId, guid);
    }

    @PostMapping(path={"/governance-services/{guid}/update"})
    public VoidResponse updateGovernanceService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody UpdateGovernanceServiceRequestBody requestBody) {
        return this.restAPI.updateGovernanceService(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-services/{guid}/delete"})
    public VoidResponse deleteGovernanceService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteGovernanceService(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/governance-engines/{guid}/governance-services"})
    public VoidResponse registerGovernanceServiceWithEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody GovernanceServiceRegistrationRequestBody requestBody) {
        return this.restAPI.registerGovernanceServiceWithEngine(serverName, userId, guid, requestBody);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services/{governanceServiceGUID}"})
    public RegisteredGovernanceServiceResponse getRegisteredGovernanceService(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineGUID, @PathVariable String governanceServiceGUID) {
        return this.restAPI.getRegisteredGovernanceService(serverName, userId, governanceEngineGUID, governanceServiceGUID);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services"})
    public GUIDListResponse getRegisteredGovernanceServices(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getRegisteredGovernanceServices(serverName, userId, governanceEngineGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineGUID}/governance-services/{governanceServiceGUID}/delete"})
    public VoidResponse unregisterGovernanceServiceFromEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineGUID, @PathVariable String governanceServiceGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unregisterGovernanceServiceFromEngine(serverName, userId, governanceEngineGUID, governanceServiceGUID, requestBody);
    }
}

