/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceengine.rest.ActionTargetStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CompletionStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.DuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.FindRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IncidentReportRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewClassificationRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewMetadataElementRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewRelatedElementsRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.OpenMetadataElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RelatedMetadataElementListResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RelatedMetadataElementsListResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.StatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateEffectivityDatesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdatePropertiesRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateStatusRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceEngineRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-engine/users/{userId}"})
@Tag(name="Governance Engine OMAS", description="The Governance Engine Open Metadata Access Service (OMAS) provides support for governance engines, services and actions.", externalDocs=@ExternalDocumentation(description="Governance Engine Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-engine/overview/"))
public class GovernanceEngineOMASResource {
    private GovernanceEngineRESTServices restAPI = new GovernanceEngineRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/assets/{assetGUID}/log-records/{governanceService}"})
    public VoidResponse logAssetAuditMessage(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String governanceService, @RequestBody String message) {
        return this.restAPI.logAssetAuditMessage(serverName, userId, assetGUID, governanceService, message);
    }

    @GetMapping(path={"/open-metadata-store/metadata-elements/{elementGUID}"})
    public OpenMetadataElementResponse getMetadataElementByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime) {
        return this.restAPI.getMetadataElementByGUID(serverName, userId, elementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/by-unique-name"})
    public OpenMetadataElementResponse getMetadataElementByUniqueName(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementByUniqueName(serverName, userId, forLineage, forDuplicateProcessing, effectiveTime, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/guid-by-unique-name"})
    public GUIDResponse getMetadataElementGUIDByUniqueName(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementGUIDByUniqueName(serverName, userId, forLineage, forDuplicateProcessing, effectiveTime, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/by-search-string"})
    public OpenMetadataElementsResponse findMetadataElementsWithString(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMetadataElementsWithString(serverName, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/open-metadata-store/related-elements/{elementGUID}/type/{relationshipTypeName}"})
    public RelatedMetadataElementListResponse getRelatedMetadataElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String relationshipTypeName, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startingAtEnd, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getRelatedMetadataElements(serverName, userId, elementGUID, relationshipTypeName, forLineage, forDuplicateProcessing, effectiveTime, startingAtEnd, startFrom, pageSize);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/by-search-specification"})
    public OpenMetadataElementsResponse findMetadataElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FindRequestBody requestBody) {
        return this.restAPI.findMetadataElements(serverName, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/related-elements/by-search-specification"})
    public RelatedMetadataElementsListResponse findRelationshipsBetweenMetadataElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam boolean forLineage, @RequestParam boolean forDuplicateProcessing, @RequestParam long effectiveTime, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FindRequestBody requestBody) {
        return this.restAPI.findRelationshipsBetweenMetadataElements(serverName, userId, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/new"})
    public GUIDResponse createMetadataElementInStore(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewMetadataElementRequestBody requestBody) {
        return this.restAPI.createMetadataElementInStore(serverName, userId, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/{metadataElementGUID}/update-properties"})
    public VoidResponse updateMetadataElementInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.updateMetadataElementInStore(serverName, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/{metadataElementGUID}/update-status"})
    public VoidResponse updateMetadataElementStatusInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdateStatusRequestBody requestBody) {
        return this.restAPI.updateMetadataElementStatusInStore(serverName, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/{metadataElementGUID}/delete"})
    public VoidResponse deleteMetadataElementInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataElementGUID, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.deleteMetadataElementInStore(serverName, userId, metadataElementGUID, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/new"})
    public VoidResponse classifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody NewClassificationRequestBody requestBody) {
        return this.restAPI.classifyMetadataElementInStore(serverName, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/update-properties"})
    public VoidResponse reclassifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.reclassifyMetadataElementInStore(serverName, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/update-status"})
    public VoidResponse updateClassificationStatusInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateClassificationStatusInStore(serverName, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/metadata-elements/{metadataElementGUID}/classifications/{classificationName}/delete"})
    public VoidResponse unclassifyMetadataElementInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String metadataElementGUID, @PathVariable String classificationName, @RequestBody UpdateRequestBody requestBody) {
        return this.restAPI.unclassifyMetadataElementInStore(serverName, userId, metadataElementGUID, classificationName, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/related-elements/new"})
    public GUIDResponse createRelatedElementsInStore(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewRelatedElementsRequestBody requestBody) {
        return this.restAPI.createRelatedElementsInStore(serverName, userId, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/related-elements/link-as-peer-duplicate"})
    public VoidResponse linkElementsAsPeerDuplicates(@PathVariable String serverName, @PathVariable String userId, @RequestBody DuplicatesRequestBody requestBody) {
        return this.restAPI.linkElementsAsDuplicates(serverName, userId, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/related-elements/{relationshipGUID}/update-properties"})
    public VoidResponse updateRelatedElementsInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody UpdatePropertiesRequestBody requestBody) {
        return this.restAPI.updateRelatedElementsInStore(serverName, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/related-elements/{relationshipGUID}/update-status"})
    public VoidResponse updateRelatedElementsStatusInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody UpdateEffectivityDatesRequestBody requestBody) {
        return this.restAPI.updateRelatedElementsStatusInStore(serverName, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/open-metadata-store/related-elements/{relationshipGUID}/delete"})
    public VoidResponse deleteRelatedElementsInStore(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteRelatedElementsInStore(serverName, userId, relationshipGUID, requestBody);
    }

    @PostMapping(path={"/governance-actions/action-targets/update"})
    public VoidResponse updateActionTargetStatus(@PathVariable String serverName, @PathVariable String userId, @RequestBody ActionTargetStatusRequestBody requestBody) {
        return this.restAPI.updateActionTargetStatus(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-actions/{governanceActionGUID}/status/update"})
    public VoidResponse updateGovernanceActionStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID, @RequestBody StatusRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionStatus(serverName, userId, governanceActionGUID, requestBody);
    }

    @PostMapping(path={"/governance-actions/{governanceActionGUID}/completion-status"})
    public VoidResponse recordCompletionStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID, @RequestBody CompletionStatusRequestBody requestBody) {
        return this.restAPI.recordCompletionStatus(serverName, userId, governanceActionGUID, requestBody);
    }

    @PostMapping(path={"/governance-engines/{governanceEngineName}/governance-actions/initiate"})
    public GUIDResponse initiateGovernanceAction(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineName, @RequestBody GovernanceActionRequestBody requestBody) {
        return this.restAPI.initiateGovernanceAction(serverName, userId, governanceEngineName, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/initiate"})
    public GUIDResponse initiateGovernanceActionProcess(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.initiateGovernanceActionProcess(serverName, userId, requestBody);
    }

    @PostMapping(path={"/incident-reports"})
    public GUIDResponse createIncidentReport(@PathVariable String serverName, @PathVariable String userId, @RequestBody IncidentReportRequestBody requestBody) {
        return this.restAPI.createIncidentReport(serverName, userId, requestBody);
    }

    @GetMapping(path={"/governance-actions/{governanceActionGUID}"})
    public GovernanceActionElementResponse getGovernanceAction(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID) {
        return this.restAPI.getGovernanceAction(serverName, userId, governanceActionGUID);
    }

    @PostMapping(path={"/governance-actions/{governanceActionGUID}/claim"})
    public VoidResponse claimGovernanceAction(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceActionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.claimGovernanceAction(serverName, userId, governanceActionGUID, requestBody);
    }

    @GetMapping(path={"/governance-actions"})
    public GovernanceActionElementsResponse getGovernanceActions(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGovernanceActions(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-actions/active"})
    public GovernanceActionElementsResponse getActiveGovernanceActions(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveGovernanceActions(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineGUID}/active-governance-actions"})
    public GovernanceActionElementsResponse getActiveClaimedGovernanceActions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getActiveClaimedGovernanceActions(serverName, userId, governanceEngineGUID, startFrom, pageSize);
    }
}

