/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionTypeElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.GovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NextGovernanceActionTypeElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.NextGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.server.GovernanceActionProcessRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-engine/users/{userId}"})
@Tag(name="Governance Engine OMAS", description="The Governance Engine Open Metadata Access Service (OMAS) provides support for governance engines, services and actions.", externalDocs=@ExternalDocumentation(description="Governance Engine Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-engine/overview/"))
public class GovernanceActionProcessResource {
    private final GovernanceActionProcessRESTServices restAPI = new GovernanceActionProcessRESTServices();

    @PostMapping(path={"/governance-action-processes/new"})
    public GUIDResponse createGovernanceActionProcess(@PathVariable String serverName, @PathVariable String userId, @RequestBody NewGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.createGovernanceActionProcess(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/update"})
    public VoidResponse updateGovernanceActionProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody UpdateGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionProcess(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/publish"})
    public VoidResponse publishGovernanceActionProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.publishGovernanceActionProcess(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/withdraw"})
    public VoidResponse withdrawGovernanceActionProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.withdrawGovernanceActionProcess(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/remove"})
    public VoidResponse removeGovernanceActionProcess(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeGovernanceActionProcess(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-search-string"})
    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceActionProcesses(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-name"})
    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}"})
    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID) {
        return this.restAPI.getGovernanceActionProcessByGUID(serverName, userId, processGUID);
    }

    @PostMapping(path={"/governance-action-types/new"})
    public GUIDResponse createGovernanceActionType(@PathVariable String serverName, @PathVariable String userId, @RequestBody GovernanceActionTypeProperties requestBody) {
        return this.restAPI.createGovernanceActionType(serverName, userId, requestBody);
    }

    @PostMapping(path={"/governance-action-types/{actionTypeGUID}/update"})
    public VoidResponse updateGovernanceActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actionTypeGUID, @RequestBody UpdateGovernanceActionTypeRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionType(serverName, userId, actionTypeGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/{actionTypeGUID}/remove"})
    public VoidResponse removeGovernanceActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actionTypeGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeGovernanceActionType(serverName, userId, actionTypeGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-search-string"})
    public GovernanceActionTypeElementsResponse findGovernanceActionTypes(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGovernanceActionTypes(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-name"})
    public GovernanceActionTypeElementsResponse getGovernanceActionTypesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGovernanceActionTypesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-types/{actionTypeGUID}"})
    public GovernanceActionTypeElementResponse getGovernanceActionTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actionTypeGUID) {
        return this.restAPI.getGovernanceActionTypeByGUID(serverName, userId, actionTypeGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/first-action-type/{actionTypeGUID}/new"})
    public VoidResponse setupFirstActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @PathVariable String actionTypeGUID, @RequestBody(required=false) String requestBody) {
        return this.restAPI.setupFirstActionType(serverName, userId, processGUID, actionTypeGUID, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}/first-action-type"})
    public GovernanceActionTypeElementResponse getFirstActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID) {
        return this.restAPI.getFirstActionType(serverName, userId, processGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/first-action-type/remove"})
    public VoidResponse removeFirstActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeFirstActionType(serverName, userId, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/{currentActionTypeGUID}/next-action-types/{nextActionTypeGUID}/new"})
    public GUIDResponse setupNextActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String currentActionTypeGUID, @PathVariable String nextActionTypeGUID, @RequestBody NextGovernanceActionTypeRequestBody requestBody) {
        return this.restAPI.setupNextActionType(serverName, userId, currentActionTypeGUID, nextActionTypeGUID, requestBody);
    }

    @PostMapping(path={"/next-action-types/{nextActionLinkGUID}/update"})
    public VoidResponse updateNextActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String nextActionLinkGUID, @RequestBody NextGovernanceActionTypeRequestBody requestBody) {
        return this.restAPI.updateNextActionType(serverName, userId, nextActionLinkGUID, requestBody);
    }

    @GetMapping(path={"/governance-action-types/{actionTypeGUID}/next-action-type"})
    public NextGovernanceActionTypeElementsResponse getNextGovernanceActionTypes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actionTypeGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getNextGovernanceActionTypes(serverName, userId, actionTypeGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/governance-action-types/next-action-type/{actionLinkGUID}/remove"})
    public VoidResponse removeNextActionType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actionLinkGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeNextActionType(serverName, userId, actionLinkGUID, requestBody);
    }
}

