/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.governanceengine.properties.CatalogTargetProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CatalogTargetResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.DeleteRequestBody;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.accessservices.governanceengine.rest.RegisteredIntegrationConnectorsResponse;
import org.odpi.openmetadata.accessservices.governanceengine.server.IntegrationConfigRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/governance-engine/users/{userId}"})
@Tag(name="Governance Engine OMAS", description="The Governance Engine Open Metadata Access Service (OMAS) provides support for governance engines, services and actions.", externalDocs=@ExternalDocumentation(description="Governance Engine Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/governance-engine/overview/"))
public class GroupConfigurationResource {
    private final IntegrationConfigRESTServices restAPI = new IntegrationConfigRESTServices();

    @PostMapping(path={"/integration-groups/new"})
    public GUIDResponse createIntegrationGroup(@PathVariable String serverName, @PathVariable String userId, @RequestBody IntegrationGroupProperties requestBody) {
        return this.restAPI.createIntegrationGroup(serverName, userId, requestBody);
    }

    @GetMapping(path={"/integration-groups/{guid}"})
    public IntegrationGroupElementResponse getIntegrationGroupByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationGroupByGUID(serverName, userId, guid);
    }

    @GetMapping(path={"/integration-groups/by-name/{name}"})
    public IntegrationGroupElementResponse getIntegrationGroupByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getIntegrationGroupByName(serverName, userId, name);
    }

    @GetMapping(path={"/integration-groups"})
    public IntegrationGroupElementsResponse getAllIntegrationGroups(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllIntegrationGroups(serverName, userId, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-groups/{guid}/update"})
    public VoidResponse updateIntegrationGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam boolean isMergeUpdate, @RequestBody IntegrationGroupProperties requestBody) {
        return this.restAPI.updateIntegrationGroup(serverName, userId, guid, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/integration-groups/{guid}/delete"})
    public VoidResponse deleteIntegrationGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteIntegrationGroup(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/integration-connectors/new"})
    public GUIDResponse createIntegrationConnector(@PathVariable String serverName, @PathVariable String userId, @RequestBody IntegrationConnectorProperties requestBody) {
        return this.restAPI.createIntegrationConnector(serverName, userId, requestBody);
    }

    @GetMapping(path={"/integration-connectors/{guid}"})
    public IntegrationConnectorElementResponse getIntegrationConnectorByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationConnectorByGUID(serverName, userId, guid);
    }

    @GetMapping(path={"/integration-connectors/by-name/{name}"})
    public IntegrationConnectorElementResponse getIntegrationConnectorByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getIntegrationConnectorByName(serverName, userId, name);
    }

    @GetMapping(path={"/integration-connectors"})
    public IntegrationConnectorElementsResponse getAllIntegrationConnectors(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllIntegrationConnectors(serverName, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/integration-connectors/{guid}/registrations"})
    public GUIDListResponse getIntegrationConnectorRegistrations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationConnectorRegistrations(serverName, userId, guid);
    }

    @PostMapping(path={"/integration-connectors/{guid}/update"})
    public VoidResponse updateIntegrationConnector(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam boolean isMergeUpdate, @RequestBody IntegrationConnectorProperties requestBody) {
        return this.restAPI.updateIntegrationConnector(serverName, userId, guid, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{guid}/delete"})
    public VoidResponse deleteIntegrationConnector(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteIntegrationConnector(serverName, userId, guid, requestBody);
    }

    @PostMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}"})
    public VoidResponse registerIntegrationConnectorWithGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID, @RequestBody RegisteredIntegrationConnectorProperties requestBody) {
        return this.restAPI.registerIntegrationConnectorWithGroup(serverName, userId, integrationGroupGUID, integrationConnectorGUID, requestBody);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}"})
    public RegisteredIntegrationConnectorResponse getRegisteredIntegrationConnector(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID) {
        return this.restAPI.getRegisteredIntegrationConnector(serverName, userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors"})
    public RegisteredIntegrationConnectorsResponse getRegisteredIntegrationConnectors(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationGroupGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getRegisteredIntegrationConnectors(serverName, userId, integrationGroupGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}/delete"})
    public VoidResponse unregisterIntegrationConnectorFromEngine(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unregisterIntegrationConnectorFromEngine(serverName, userId, integrationGroupGUID, integrationConnectorGUID, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}"})
    public VoidResponse addCatalogTarget(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID, @RequestBody CatalogTargetProperties requestBody) {
        return this.restAPI.addCatalogTarget(serverName, userId, integrationConnectorGUID, metadataElementGUID, requestBody);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}"})
    public CatalogTargetResponse getCatalogTarget(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID) {
        return this.restAPI.getCatalogTarget(serverName, userId, integrationConnectorGUID, metadataElementGUID);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets"})
    public CatalogTargetsResponse getCatalogTargets(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getCatalogTargets(serverName, userId, integrationConnectorGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}/delete"})
    public VoidResponse removeCatalogTarget(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeCatalogTarget(serverName, userId, integrationConnectorGUID, metadataElementGUID, requestBody);
    }
}

