/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceengine.connectors.outtopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.concurrent.CompletionException;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.WatchdogGovernanceServiceEvent;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineAuditCode;
import org.odpi.openmetadata.accessservices.governanceengine.ffdc.GovernanceEngineErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogMetadataElementEvent;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogRelatedElementsEvent;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicSenderConnectorBase;

public class GovernanceEngineOutTopicServerConnector
extends OpenMetadataTopicSenderConnectorBase {
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer();

    public void sendEvent(GovernanceEngineEvent event) throws InvalidParameterException, ConnectorCheckedException {
        String methodName = "sendEvent";
        try {
            String eventString = OBJECT_WRITER.writeValueAsString((Object)event);
            super.sendEvent(eventString).join();
            if (this.auditLog != null) {
                if (event instanceof WatchdogGovernanceServiceEvent) {
                    WatchdogGovernanceServiceEvent watchdogGovernanceServiceEvent = (WatchdogGovernanceServiceEvent)event;
                    WatchdogGovernanceEvent watchdogGovernanceEvent = watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent();
                    if (watchdogGovernanceEvent instanceof WatchdogMetadataElementEvent) {
                        WatchdogMetadataElementEvent watchdogMetadataElementEvent = (WatchdogMetadataElementEvent)watchdogGovernanceEvent;
                        this.auditLog.logMessage("sendEvent", GovernanceEngineAuditCode.OUT_TOPIC_WATCHDOG_EVENT.getMessageDefinition(new String[]{event.getEventType().getEventTypeName(), watchdogMetadataElementEvent.getMetadataElement().getElementGUID(), watchdogMetadataElementEvent.getMetadataElement().getType().getTypeName()}), eventString);
                    } else {
                        watchdogGovernanceEvent = watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent();
                        if (watchdogGovernanceEvent instanceof WatchdogRelatedElementsEvent) {
                            WatchdogRelatedElementsEvent watchdogRelatedElementsEvent = (WatchdogRelatedElementsEvent)watchdogGovernanceEvent;
                            this.auditLog.logMessage("sendEvent", GovernanceEngineAuditCode.OUT_TOPIC_WATCHDOG_EVENT.getMessageDefinition(new String[]{event.getEventType().getEventTypeName(), watchdogRelatedElementsEvent.getRelatedMetadataElements().getRelationshipGUID(), watchdogRelatedElementsEvent.getRelatedMetadataElements().getType().getTypeName()}), eventString);
                        } else {
                            this.auditLog.logMessage("sendEvent", GovernanceEngineAuditCode.OUT_TOPIC_EVENT.getMessageDefinition(new String[]{event.getEventType().getEventTypeName()}), eventString);
                        }
                    }
                } else {
                    this.auditLog.logMessage("sendEvent", GovernanceEngineAuditCode.OUT_TOPIC_EVENT.getMessageDefinition(new String[]{event.getEventType().getEventTypeName()}), eventString);
                }
            }
        }
        catch (CompletionException error) {
            if (error.getCause() instanceof ConnectorCheckedException) {
                throw (ConnectorCheckedException)error.getCause();
            }
            if (error.getCause() instanceof InvalidParameterException) {
                throw (InvalidParameterException)error.getCause();
            }
        }
        catch (ConnectorCheckedException | InvalidParameterException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceEngineErrorCode.UNABLE_TO_SEND_EVENT.getMessageDefinition(new String[]{this.connectionName, event.toString(), error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "sendEvent", (Throwable)error);
        }
    }
}

