/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.samples.leadership;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.client.PersonalProfileManagement;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.PersonalProfileUniverse;
import org.odpi.openmetadata.accessservices.communityprofile.metadataelement.UserIdentityElement;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceRoleManager;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleHistory;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceRoleProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.http.HttpHelper;

public class GovernanceLeadershipSample {
    private static final String cdoAppointmentId = "EXEC-CDO";
    private static final String cpoAppointmentId = "EXEC-CPO";
    private static final String csoAppointmentId = "EXEC-CSO";
    private static final String corpAppointmentId = "EXEC-CORP-GOV";
    private static final String cdoForITAppointmentId = "CHIEF-INFO-ARCH";
    private static final String infraGovForITAppointmentId = "CHIEF-SYS-ARCH";
    private static final String projLeadForITAppointmentId = "CHIEF-SW-PROJ-MGR";
    private static final String julesKeeperEmpNo = "026";
    private static final String ivorPadlockEmpNo = "008";
    private static final String faithBrokerEmpNo = "010";
    private static final String erinOverviewEmpNo = "013";
    private static final String garyGeekeEmpNo = "015";
    private static final String pollyTaskerEmpNo = "005";
    private static final String reggieMintEmpNo = "018";
    private static final String julesKeeperUserId = "julesKeeper";
    private static final String ivorPadlockUserId = "ivorPadlock";
    private static final String faithBrokerUserId = "faithBroker";
    private static final String erinOverviewUserId = "erinOverview";
    private static final String garyGeekeUserId = "garyGeeke";
    private static final String pollyTaskerUserId = "pollyTasker";
    private static final String reggieMintUserId = "reggieMint";
    private static final String workLocationPropertyName = "WorkLocation";
    private static final String contactTypePropertyName = "ContactType";
    private String serverName;
    private String serverURLRoot;
    private String clientUserId;

    private GovernanceLeadershipSample(String serverName, String serverURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    private void printPersonalProfile(PersonalProfileManagement client, String clientUserId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        PersonalProfileUniverse profile = client.getPersonalProfileByGUID(clientUserId, guid);
        System.out.println("----------------------------");
        System.out.println("Profile: " + guid);
        List userIdentities = profile.getUserIdentities();
        if (userIdentities == null) {
            System.out.println("  UserId: null <ERROR>");
        } else if (userIdentities.size() == 0) {
            System.out.println("  UserIds: empty <ERROR>");
        } else if (userIdentities.size() == 1) {
            UserIdentityElement userIdentity = (UserIdentityElement)userIdentities.get(0);
            if (userIdentity == null) {
                System.out.println("  UserId: empty <ERROR>");
            } else {
                System.out.println("  UserId: " + userIdentity.getProperties().getQualifiedName());
            }
        } else {
            System.out.print("  UserIds:");
            for (UserIdentityElement userIdentity : userIdentities) {
                if (userIdentity == null) {
                    System.out.print(" <empty ERROR>");
                    continue;
                }
                System.out.print(" " + userIdentity.getProperties().getQualifiedName());
            }
            System.out.println();
        }
        System.out.println("  Employee Id: " + profile.getProfileProperties().getQualifiedName());
        System.out.println("  Full Name: " + profile.getProfileProperties().getFullName());
        System.out.println("  Known Name: " + profile.getProfileProperties().getKnownName());
        System.out.println("  Job Title: " + profile.getProfileProperties().getJobTitle());
        System.out.println("  Job Description: " + profile.getProfileProperties().getJobTitle());
        if (profile.getProfileProperties().getAdditionalProperties() != null) {
            System.out.println("  Work Location: " + (String)profile.getProfileProperties().getAdditionalProperties().get(workLocationPropertyName));
            System.out.println("  Contact Type: " + (String)profile.getProfileProperties().getAdditionalProperties().get(contactTypePropertyName));
        }
        System.out.println("----------------------------");
    }

    private void printGovernanceRole(GovernanceRoleManager client, String clientUserId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GovernanceRoleHistory governanceRoleElement = client.getGovernanceRoleHistoryByGUID(clientUserId, guid);
        GovernanceRoleProperties governanceRole = governanceRoleElement.getRole();
        System.out.println("----------------------------");
        System.out.println("Governance Role: " + guid);
        System.out.println("  Domain: " + governanceRole.getDomainIdentifier());
        System.out.println("  Appointment Id: " + governanceRole.getRoleId());
        System.out.println("  Appointment Scope: " + governanceRole.getScope());
        System.out.println("  Title: " + governanceRole.getTitle());
        GovernanceAppointee appointee = governanceRoleElement.getAppointee();
        if (appointee != null) {
            System.out.println("  Appointee: " + appointee.getProfile().getProfileProperties().getKnownName());
            System.out.println("  Start Date: " + appointee.getStartDate());
            System.out.println("  End Date: " + appointee.getEndDate());
        } else {
            System.out.println("  Appointee: <None> ");
        }
        System.out.println("----------------------------");
    }

    private void run() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        PersonalProfileManagement ppmClient = new PersonalProfileManagement(this.serverName, this.serverURLRoot);
        GovernanceRoleManager gplClient = new GovernanceRoleManager(this.serverName, this.serverURLRoot);
        System.out.println("Creating profiles for Jules and Ivor");
        HashMap<String, String> julesAdditionalProperties = new HashMap<String, String>();
        julesAdditionalProperties.put(workLocationPropertyName, "2");
        julesAdditionalProperties.put(contactTypePropertyName, "Employee");
        String julesKeeperProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, null, null, julesKeeperUserId, julesKeeperEmpNo, "Julian Keeper", "Jules Keeper", "Chief Data and Privacy Role", "Ensuring CocoP makes the best use of data.", julesAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, julesKeeperProfileGUID);
        HashMap<String, String> ivorAdditionalProperties = new HashMap<String, String>();
        ivorAdditionalProperties.put(workLocationPropertyName, "1");
        ivorAdditionalProperties.put(contactTypePropertyName, "Employee");
        String ivorPadlockProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, null, null, ivorPadlockUserId, ivorPadlockEmpNo, null, "Ivor Padlock", "Security Executive", "Manages security for Coco Pharmaceuticals.", ivorAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, ivorPadlockProfileGUID);
        System.out.println("Creating CDO, CPO and CSO governance officers");
        GovernanceRoleProperties governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.DATA.getOrdinal());
        governanceRoleProperties.setRoleId(cdoAppointmentId);
        governanceRoleProperties.setTitle("Chief Data Role (CDO)");
        String cdoGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        this.printGovernanceRole(gplClient, this.clientUserId, cdoGUID);
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.PRIVACY.getOrdinal());
        governanceRoleProperties.setRoleId(cpoAppointmentId);
        governanceRoleProperties.setTitle("Chief Privacy Role (CPO)");
        String cpoGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        this.printGovernanceRole(gplClient, this.clientUserId, cpoGUID);
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.SECURITY.getOrdinal());
        governanceRoleProperties.setRoleId(csoAppointmentId);
        governanceRoleProperties.setTitle("Chief Security Role (CSO)");
        String csoGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        this.printGovernanceRole(gplClient, this.clientUserId, csoGUID);
        List governanceRoles = gplClient.getGovernanceRolesByDomainId(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " governance officers");
        System.out.println("Appointing CDO, CPO and CSO governance officers");
        gplClient.appointGovernanceRole(this.clientUserId, cdoGUID, julesKeeperProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, cdoGUID);
        String julesAsCPOAppointmentId = gplClient.appointGovernanceRole(this.clientUserId, cpoGUID, julesKeeperProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, cpoGUID);
        gplClient.appointGovernanceRole(this.clientUserId, csoGUID, ivorPadlockProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, csoGUID);
        System.out.println("Changing CPO to Faith");
        HashMap<String, String> faithAdditionalProperties = new HashMap<String, String>();
        faithAdditionalProperties.put(workLocationPropertyName, "1");
        faithAdditionalProperties.put(contactTypePropertyName, "Employee");
        String faithBrokerProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, null, null, faithBrokerUserId, faithBrokerEmpNo, "Faith Charity Broker", "Faith Broker", "Human Resources Director", "Providing support to Coco Pharmaceutical employees.", faithAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, faithBrokerProfileGUID);
        long handoverTime = new Date().getTime();
        Date handoverDate = new Date(handoverTime + 100L);
        gplClient.relieveGovernanceRole(this.clientUserId, cpoGUID, julesKeeperProfileGUID, julesAsCPOAppointmentId, handoverDate);
        this.printGovernanceRole(gplClient, this.clientUserId, cpoGUID);
        gplClient.appointGovernanceRole(this.clientUserId, cpoGUID, faithBrokerProfileGUID, handoverDate);
        this.printGovernanceRole(gplClient, this.clientUserId, cpoGUID);
        governanceRoles = gplClient.getGovernanceRolesByDomainId(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " governance officers");
        List governanceRoleAppointees = gplClient.getCurrentGovernanceRoleAppointments(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " active governance officers");
        for (GovernanceRoleAppointee governanceRole : governanceRoleAppointees) {
            System.out.println(governanceRole.getAppointee().getProfile().getProfileProperties().getKnownName() + " is the " + governanceRole.getRole().getRoleId());
        }
        governanceRoleAppointees = gplClient.getCurrentGovernanceRoleAppointments(this.clientUserId, GovernanceDomain.PRIVACY.getOrdinal(), 0, 0);
        System.out.println(governanceRoles.size() + " privacy governance officers");
        for (GovernanceRoleAppointee governanceRole : governanceRoleAppointees) {
            System.out.println(governanceRole.getAppointee().getProfile().getProfileProperties().getKnownName() + " is the privacy officer from " + governanceRole.getAppointee().getStartDate() + " to " + governanceRole.getAppointee().getEndDate());
        }
        try {
            System.out.println("Sleeping ... until after Faith's appointment becomes active");
            Thread.sleep(15L);
        }
        catch (InterruptedException exc) {
            System.out.println("Sleep interrupted");
        }
        governanceRoleAppointees = gplClient.getCurrentGovernanceRoleAppointments(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " active governance officers");
        for (GovernanceRoleAppointee governanceRole : governanceRoleAppointees) {
            System.out.println(governanceRole.getAppointee().getProfile().getProfileProperties().getKnownName() + " is the " + governanceRole.getRole().getTitle());
        }
        ppmClient.updatePersonalProfile(this.clientUserId, null, null, julesKeeperProfileGUID, julesKeeperEmpNo, "Julian Keeper", "Jules Keeper", "Chief Data Role", "Ensuring CocoP makes the best use of data.", null, julesAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, julesKeeperProfileGUID);
        System.out.println("Creating profile for Erin");
        HashMap<String, String> erinAdditionalProperties = new HashMap<String, String>();
        erinAdditionalProperties.put(workLocationPropertyName, "2");
        erinAdditionalProperties.put(contactTypePropertyName, "Employee");
        String erinOverviewProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, null, null, erinOverviewUserId, erinOverviewEmpNo, null, "Erin Overview", "Information Architect", "Manages all information architecture and standards for Coco Pharmaceuticals IT systems.", erinAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, erinOverviewProfileGUID);
        System.out.println("Creating CDO for IT governance officer");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.DATA.getOrdinal());
        governanceRoleProperties.setRoleId(cdoForITAppointmentId);
        governanceRoleProperties.setScope("IT Systems");
        governanceRoleProperties.setTitle("Chief Data Role (CDO) for IT");
        String cdoForITGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        System.out.println("Appointing Erin as CDO for IT");
        gplClient.appointGovernanceRole(this.clientUserId, cdoForITGUID, erinOverviewProfileGUID, new Date());
        this.printGovernanceRole(gplClient, this.clientUserId, cdoForITGUID);
        System.out.println("Creating profile for Gary");
        HashMap<String, String> garyAdditionalProperties = new HashMap<String, String>();
        garyAdditionalProperties.put(workLocationPropertyName, "1");
        garyAdditionalProperties.put(contactTypePropertyName, "Employee");
        String garyGeekeProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, null, null, garyGeekeUserId, garyGeekeEmpNo, null, "Gary Geeke", "Infrastructure Architect", "Manages all the IT infrastructure for Coco Pharmaceuticals.", garyAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, garyGeekeProfileGUID);
        System.out.println("Creating IT governance officer");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.IT_INFRASTRUCTURE.getOrdinal());
        governanceRoleProperties.setRoleId(infraGovForITAppointmentId);
        governanceRoleProperties.setTitle("Chief Infrastructure Architect");
        String infraGovForITGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        System.out.println("Appointing Gary as gov officer for IT");
        gplClient.appointGovernanceRole(this.clientUserId, infraGovForITGUID, garyGeekeProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, infraGovForITGUID);
        System.out.println("Creating profile for Polly");
        HashMap<String, String> pollyAdditionalProperties = new HashMap<String, String>();
        pollyAdditionalProperties.put(workLocationPropertyName, "1");
        pollyAdditionalProperties.put(contactTypePropertyName, "Employee");
        String pollyTaskerProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, null, null, pollyTaskerUserId, pollyTaskerEmpNo, null, "Polly Tasker", "Lead Project Manager for IT", "Manages IT projects for Coco Pharmaceuticals.", pollyAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, pollyTaskerProfileGUID);
        System.out.println("Creating SDLC governance officer");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.SOFTWARE_DEVELOPMENT.getOrdinal());
        governanceRoleProperties.setRoleId(projLeadForITAppointmentId);
        governanceRoleProperties.setTitle("Chief Project Lead for Software");
        String projLeadForITGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        System.out.println("Appointing Polly as gov officer for Software Development");
        gplClient.appointGovernanceRole(this.clientUserId, projLeadForITGUID, pollyTaskerProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, projLeadForITGUID);
        System.out.println("Creating profile for Reggie");
        HashMap<String, String> reggieAdditionalProperties = new HashMap<String, String>();
        reggieAdditionalProperties.put(workLocationPropertyName, "1");
        reggieAdditionalProperties.put(contactTypePropertyName, "Employee");
        String reggieMintProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, null, null, reggieMintUserId, reggieMintEmpNo, "Reginald S P Mint", "Reggie Mint", "Chief Finance Role", "Manages finance for Coco Pharmaceuticals.", reggieAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, pollyTaskerProfileGUID);
        System.out.println("Creating corporate governance officer");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.CORPORATE.getOrdinal());
        governanceRoleProperties.setRoleId(corpAppointmentId);
        governanceRoleProperties.setTitle("Corporate Governance Role");
        String corpGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        System.out.println("Appointing Reggie as corporate gov officer");
        gplClient.appointGovernanceRole(this.clientUserId, corpGUID, reggieMintProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, corpGUID);
        System.out.println("Update the CSO to the CISO");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTitle("Chief Information Security Role (CISO)");
        gplClient.updateGovernanceRole(this.clientUserId, csoGUID, true, governanceRoleProperties);
        governanceRoles = gplClient.getGovernanceRolesByDomainId(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " governance officers");
        for (GovernanceRoleAppointee governanceRole : governanceRoleAppointees) {
            System.out.println(governanceRole.getAppointee().getProfile().getProfileProperties().getKnownName() + " is the " + governanceRole.getRole().getTitle());
        }
        System.out.println("Deleting all profiles and governance officers");
        gplClient.deleteGovernanceRole(this.clientUserId, cdoGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, cdoForITGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, cpoGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, csoGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, corpGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, projLeadForITGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, infraGovForITGUID);
        ppmClient.deletePersonalProfile(this.clientUserId, null, null, julesKeeperProfileGUID, julesKeeperEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, null, null, ivorPadlockProfileGUID, ivorPadlockEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, null, null, faithBrokerProfileGUID, faithBrokerEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, null, null, erinOverviewProfileGUID, erinOverviewEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, null, null, garyGeekeProfileGUID, garyGeekeEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, null, null, reggieMintProfileGUID, reggieMintEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, null, null, pollyTaskerProfileGUID, pollyTaskerEmpNo);
        try {
            System.out.println("Sleeping ... to allow deletes to propagate");
            Thread.sleep(5000L);
        }
        catch (InterruptedException exc) {
            System.out.println("Sleep interrupted");
        }
        governanceRoles = gplClient.getGovernanceRolesByDomainId(this.clientUserId, 0, 0, 0);
        if (governanceRoles != null) {
            System.out.println(governanceRoles.size() + " governance officers");
            for (GovernanceRoleAppointee governanceRole : governanceRoles) {
                System.out.println(governanceRole.toString() + " is still defined");
            }
            System.exit(-1);
        } else {
            System.out.println("All governance officers gone");
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.out.println("Please specify the server's name in the first parameter, the server's platform URL root in the second parameter and the caller's userId in the third parameter");
            System.exit(-1);
        }
        String serverName = args[0];
        String serverURLRoot = args[1];
        String clientUserId = args[2];
        HttpHelper.noStrictSSLIfConfigured();
        System.out.println("===============================");
        System.out.println("Governance Leadership Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        try {
            GovernanceLeadershipSample sample = new GovernanceLeadershipSample(serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Throwable error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

