/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.samples.leadership;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.client.PersonalProfileManagement;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.communityprofile.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.communityprofile.properties.UserIdentity;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramLeadership;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficerAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficerProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.http.HttpHelper;

public class GovernanceLeadershipSample {
    private static final String cdoAppointmentId = "EXEC-CDO";
    private static final String cpoAppointmentId = "EXEC-CPO";
    private static final String csoAppointmentId = "EXEC-CSO";
    private static final String corpAppointmentId = "EXEC-CORP-GOV";
    private static final String cdoForITAppointmentId = "CHIEF-INFO-ARCH";
    private static final String infraGovForITAppointmentId = "CHIEF-SYS-ARCH";
    private static final String projLeadForITAppointmentId = "CHIEF-SW-PROJ-MGR";
    private static final String julesKeeperEmpNo = "026";
    private static final String ivorPadlockEmpNo = "008";
    private static final String faithBrokerEmpNo = "010";
    private static final String erinOverviewEmpNo = "013";
    private static final String garyGeekeEmpNo = "015";
    private static final String pollyTaskerEmpNo = "005";
    private static final String reggieMintEmpNo = "018";
    private static final String julesKeeperUserId = "julesKeeper";
    private static final String ivorPadlockUserId = "ivorPadlock";
    private static final String faithBrokerUserId = "faithBroker";
    private static final String erinOverviewUserId = "erinOverview";
    private static final String garyGeekeUserId = "garyGeeke";
    private static final String pollyTaskerUserId = "pollyTasker";
    private static final String reggieMintUserId = "reggieMint";
    private static final String workLocationPropertyName = "WorkLocation";
    private static final String contactTypePropertyName = "ContactType";
    private String serverName;
    private String serverURLRoot;
    private String clientUserId;

    private GovernanceLeadershipSample(String serverName, String serverURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    private void printPersonalProfile(PersonalProfileManagement client, String clientUserId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        PersonalProfile profile = client.getPersonalProfileByGUID(clientUserId, guid);
        System.out.println("----------------------------");
        System.out.println("Profile: " + guid);
        List userIdentities = profile.getAssociatedUserIds();
        if (userIdentities == null) {
            System.out.println("  UserId: null <ERROR>");
        } else if (userIdentities.size() == 0) {
            System.out.println("  UserIds: empty <ERROR>");
        } else if (userIdentities.size() == 1) {
            UserIdentity userIdentity = (UserIdentity)userIdentities.get(0);
            if (userIdentity == null) {
                System.out.println("  UserId: empty <ERROR>");
            } else {
                System.out.println("  UserId: " + userIdentity.getUserId());
            }
        } else {
            System.out.print("  UserIds:");
            for (UserIdentity userIdentity : userIdentities) {
                if (userIdentity == null) {
                    System.out.print(" <empty ERROR>");
                    continue;
                }
                System.out.print(" " + userIdentity.getUserId());
            }
            System.out.println();
        }
        System.out.println("  Employee Id: " + profile.getQualifiedName());
        System.out.println("  Full Name: " + profile.getFullName());
        System.out.println("  Known Name: " + profile.getName());
        System.out.println("  Job Title: " + profile.getJobTitle());
        System.out.println("  Job Description: " + profile.getJobTitle());
        System.out.println("  Work Location: " + (String)profile.getAdditionalProperties().get(workLocationPropertyName));
        System.out.println("  Contact Type: " + (String)profile.getAdditionalProperties().get(contactTypePropertyName));
        System.out.println("----------------------------");
    }

    private void printGovernanceOfficer(GovernanceProgramLeadership client, String clientUserId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GovernanceOfficerProperties governanceOfficer = client.getGovernanceOfficerByGUID(clientUserId, guid);
        System.out.println("----------------------------");
        System.out.println("Governance Officer: " + guid);
        System.out.println("  Domain: " + governanceOfficer.getGovernanceDomain());
        System.out.println("  Appointment Id: " + governanceOfficer.getAppointmentId());
        System.out.println("  Appointment Context: " + governanceOfficer.getAppointmentContext());
        System.out.println("  Title: " + governanceOfficer.getQualifiedName());
        GovernanceOfficerAppointee appointee = governanceOfficer.getAppointee();
        if (appointee != null) {
            System.out.println("  Appointee: " + appointee.getProfile().getKnownName());
            System.out.println("  Start Date: " + appointee.getStartDate());
            System.out.println("  End Date: " + appointee.getEndDate());
        } else {
            System.out.println("  Appointee: <None> ");
        }
        System.out.println("----------------------------");
    }

    private void run() throws InvalidParameterException, PropertyServerException, NoProfileForUserException, UserNotAuthorizedException {
        PersonalProfileManagement ppmClient = new PersonalProfileManagement(this.serverName, this.serverURLRoot);
        GovernanceProgramLeadership gplClient = new GovernanceProgramLeadership(this.serverName, this.serverURLRoot);
        System.out.println("Creating profiles for Jules and Ivor");
        HashMap<String, String> julesAdditionalProperties = new HashMap<String, String>();
        julesAdditionalProperties.put(workLocationPropertyName, "2");
        julesAdditionalProperties.put(contactTypePropertyName, "Employee");
        String julesKeeperProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, julesKeeperUserId, julesKeeperEmpNo, "Julian Keeper", "Jules Keeper", "Chief Data and Privacy Officer", "Ensuring CocoP makes the best use of data.", julesAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, julesKeeperProfileGUID);
        HashMap<String, String> ivorAdditionalProperties = new HashMap<String, String>();
        ivorAdditionalProperties.put(workLocationPropertyName, "1");
        ivorAdditionalProperties.put(contactTypePropertyName, "Employee");
        String ivorPadlockProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, ivorPadlockUserId, ivorPadlockEmpNo, null, "Ivor Padlock", "Security Executive", "Manages security for Coco Pharmaceuticals.", ivorAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, ivorPadlockProfileGUID);
        System.out.println("Creating CDO, CPO and CSO governance officers");
        String cdoGUID = gplClient.createGovernanceOfficer(this.clientUserId, GovernanceDomain.DATA, cdoAppointmentId, null, "Chief Data Officer (CDO)", null, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, cdoGUID);
        String cpoGUID = gplClient.createGovernanceOfficer(this.clientUserId, GovernanceDomain.PRIVACY, cpoAppointmentId, null, "Chief Privacy Officer (CPO)", null, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, cpoGUID);
        String csoGUID = gplClient.createGovernanceOfficer(this.clientUserId, GovernanceDomain.SECURITY, csoAppointmentId, null, "Chief Security Officer (CSO)", null, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, csoGUID);
        List governanceOfficers = gplClient.getGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " governance officers");
        System.out.println("Appointing CDO, CPO and CSO governance officers");
        gplClient.appointGovernanceOfficer(this.clientUserId, cdoGUID, julesKeeperProfileGUID, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, cdoGUID);
        gplClient.appointGovernanceOfficer(this.clientUserId, cpoGUID, julesKeeperProfileGUID, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, cpoGUID);
        gplClient.appointGovernanceOfficer(this.clientUserId, csoGUID, ivorPadlockProfileGUID, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, csoGUID);
        System.out.println("Changing CPO to Faith");
        HashMap<String, String> faithAdditionalProperties = new HashMap<String, String>();
        faithAdditionalProperties.put(workLocationPropertyName, "1");
        faithAdditionalProperties.put(contactTypePropertyName, "Employee");
        String faithBrokerProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, faithBrokerUserId, faithBrokerEmpNo, "Faith Charity Broker", "Faith Broker", "Human Resources Director", "Providing support to Coco Pharmaceutical employees.", faithAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, faithBrokerProfileGUID);
        long handoverTime = new Date().getTime();
        Date handoverDate = new Date(handoverTime + 100L);
        gplClient.relieveGovernanceOfficer(this.clientUserId, cpoGUID, julesKeeperProfileGUID, handoverDate);
        this.printGovernanceOfficer(gplClient, this.clientUserId, cpoGUID);
        gplClient.appointGovernanceOfficer(this.clientUserId, cpoGUID, faithBrokerProfileGUID, handoverDate);
        this.printGovernanceOfficer(gplClient, this.clientUserId, cpoGUID);
        governanceOfficers = gplClient.getGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " governance officers");
        governanceOfficers = gplClient.getActiveGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " active governance officers");
        for (GovernanceOfficerProperties governanceOfficer : governanceOfficers) {
            System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the " + governanceOfficer.getQualifiedName());
        }
        governanceOfficers = gplClient.getGovernanceOfficersByDomain(this.clientUserId, GovernanceDomain.PRIVACY);
        System.out.println(governanceOfficers.size() + " privacy governance officers");
        for (GovernanceOfficerProperties governanceOfficer : governanceOfficers) {
            System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the privacy officer from " + governanceOfficer.getAppointee().getStartDate() + " to " + governanceOfficer.getAppointee().getEndDate());
        }
        try {
            System.out.println("Sleeping ... until after Faith's appointment becomes active");
            Thread.sleep(15L);
        }
        catch (InterruptedException exc) {
            System.out.println("Sleep interrupted");
        }
        governanceOfficers = gplClient.getActiveGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " active governance officers");
        for (GovernanceOfficerProperties governanceOfficer : governanceOfficers) {
            System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the " + governanceOfficer.getQualifiedName());
        }
        ppmClient.updatePersonalProfile(this.clientUserId, julesKeeperProfileGUID, julesKeeperEmpNo, "Julian Keeper", "Jules Keeper", "Chief Data Officer", "Ensuring CocoP makes the best use of data.", null, julesAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, julesKeeperProfileGUID);
        System.out.println("Creating profile for Erin");
        HashMap<String, String> erinAdditionalProperties = new HashMap<String, String>();
        erinAdditionalProperties.put(workLocationPropertyName, "2");
        erinAdditionalProperties.put(contactTypePropertyName, "Employee");
        String erinOverviewProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, erinOverviewUserId, erinOverviewEmpNo, null, "Erin Overview", "Information Architect", "Manages all information architecture and standards for Coco Pharmaceuticals IT systems.", erinAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, erinOverviewProfileGUID);
        System.out.println("Creating CDO for IT governance officer");
        String cdoForITGUID = gplClient.createGovernanceOfficer(this.clientUserId, GovernanceDomain.DATA, cdoForITAppointmentId, "IT Systems", "Chief Data Officer (CDO) for IT", null, null);
        System.out.println("Appointing Erin as CDO for IT");
        gplClient.appointGovernanceOfficer(this.clientUserId, cdoForITGUID, erinOverviewProfileGUID, new Date());
        this.printGovernanceOfficer(gplClient, this.clientUserId, cdoForITGUID);
        System.out.println("Creating profile for Gary");
        HashMap<String, String> garyAdditionalProperties = new HashMap<String, String>();
        garyAdditionalProperties.put(workLocationPropertyName, "1");
        garyAdditionalProperties.put(contactTypePropertyName, "Employee");
        String garyGeekeProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, garyGeekeUserId, garyGeekeEmpNo, null, "Gary Geeke", "Infrastructure Architect", "Manages all the IT infrastructure for Coco Pharmaceuticals.", garyAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, garyGeekeProfileGUID);
        System.out.println("Creating IT governance officer");
        String infraGovForITGUID = gplClient.createGovernanceOfficer(this.clientUserId, GovernanceDomain.IT_INFRASTRUCTURE, infraGovForITAppointmentId, null, "Chief Infrastructure Architect", null, null);
        System.out.println("Appointing Gary as gov officer for IT");
        gplClient.appointGovernanceOfficer(this.clientUserId, infraGovForITGUID, garyGeekeProfileGUID, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, infraGovForITGUID);
        System.out.println("Creating profile for Gary");
        HashMap<String, String> pollyAdditionalProperties = new HashMap<String, String>();
        pollyAdditionalProperties.put(workLocationPropertyName, "1");
        pollyAdditionalProperties.put(contactTypePropertyName, "Employee");
        String pollyTaskerProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, pollyTaskerUserId, pollyTaskerEmpNo, null, "Polly Tasker", "Lead Project Manager for IT", "Manages IT projects for Coco Pharmaceuticals.", pollyAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, pollyTaskerProfileGUID);
        System.out.println("Creating SDLC governance officer");
        String projLeadForITGUID = gplClient.createGovernanceOfficer(this.clientUserId, GovernanceDomain.SOFTWARE_DEVELOPMENT, projLeadForITAppointmentId, null, "Chief Project Lead for Software", null, null);
        System.out.println("Appointing Polly as gov officer for Software Development");
        gplClient.appointGovernanceOfficer(this.clientUserId, projLeadForITGUID, pollyTaskerProfileGUID, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, projLeadForITGUID);
        System.out.println("Creating profile for Reggie");
        HashMap<String, String> reggieAdditionalProperties = new HashMap<String, String>();
        reggieAdditionalProperties.put(workLocationPropertyName, "1");
        reggieAdditionalProperties.put(contactTypePropertyName, "Employee");
        String reggieMintProfileGUID = ppmClient.createPersonalProfile(this.clientUserId, reggieMintUserId, reggieMintEmpNo, "Reginald S P Mint", "Reggie Mint", "Chief Finance Officer", "Manages finance for Coco Pharmaceuticals.", reggieAdditionalProperties);
        this.printPersonalProfile(ppmClient, this.clientUserId, pollyTaskerProfileGUID);
        System.out.println("Creating corporate governance officer");
        String corpGUID = gplClient.createGovernanceOfficer(this.clientUserId, GovernanceDomain.CORPORATE, corpAppointmentId, null, "Corporate Governance Officer", null, null);
        System.out.println("Appointing Reggie as corporate gov officer");
        gplClient.appointGovernanceOfficer(this.clientUserId, corpGUID, reggieMintProfileGUID, null);
        this.printGovernanceOfficer(gplClient, this.clientUserId, corpGUID);
        System.out.println("Update the CSO to the CISO");
        gplClient.updateGovernanceOfficer(this.clientUserId, csoGUID, GovernanceDomain.SECURITY, csoAppointmentId, null, "Chief Information Security Officer (CISO)", null, null);
        governanceOfficers = gplClient.getGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " governance officers");
        for (GovernanceOfficerProperties governanceOfficer : governanceOfficers) {
            System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the " + governanceOfficer.getQualifiedName());
        }
        System.out.println("Deleting all profiles and governance officers");
        gplClient.deleteGovernanceOfficer(this.clientUserId, cdoGUID, cdoAppointmentId, GovernanceDomain.DATA);
        gplClient.deleteGovernanceOfficer(this.clientUserId, cdoForITGUID, cdoForITAppointmentId, GovernanceDomain.DATA);
        gplClient.deleteGovernanceOfficer(this.clientUserId, cpoGUID, cpoAppointmentId, GovernanceDomain.PRIVACY);
        gplClient.deleteGovernanceOfficer(this.clientUserId, csoGUID, csoAppointmentId, GovernanceDomain.SECURITY);
        gplClient.deleteGovernanceOfficer(this.clientUserId, corpGUID, corpAppointmentId, GovernanceDomain.CORPORATE);
        gplClient.deleteGovernanceOfficer(this.clientUserId, projLeadForITGUID, projLeadForITAppointmentId, GovernanceDomain.SOFTWARE_DEVELOPMENT);
        gplClient.deleteGovernanceOfficer(this.clientUserId, infraGovForITGUID, infraGovForITAppointmentId, GovernanceDomain.IT_INFRASTRUCTURE);
        ppmClient.deletePersonalProfile(this.clientUserId, julesKeeperProfileGUID, julesKeeperEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, ivorPadlockProfileGUID, ivorPadlockEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, faithBrokerProfileGUID, faithBrokerEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, erinOverviewProfileGUID, erinOverviewEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, garyGeekeProfileGUID, garyGeekeEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, reggieMintProfileGUID, reggieMintEmpNo);
        ppmClient.deletePersonalProfile(this.clientUserId, pollyTaskerProfileGUID, pollyTaskerEmpNo);
        try {
            System.out.println("Sleeping ... to allow deletes to propagate");
            Thread.sleep(5000L);
        }
        catch (InterruptedException exc) {
            System.out.println("Sleep interrupted");
        }
        governanceOfficers = gplClient.getGovernanceOfficers(this.clientUserId);
        if (governanceOfficers != null) {
            System.out.println(governanceOfficers.size() + " governance officers");
            for (GovernanceOfficerProperties governanceOfficer : governanceOfficers) {
                System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the " + governanceOfficer.getQualifiedName());
            }
            System.exit(-1);
        } else {
            System.out.println("All governance officers gone");
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.out.println("Please specify the server's name in the first parameter, the server's platform URL root in the second parameter and the caller's userId in the third parameter");
            System.exit(-1);
        }
        String serverName = args[0];
        String serverURLRoot = args[1];
        String clientUserId = args[2];
        HttpHelper.noStrictSSLIfConfigured();
        System.out.println("===============================");
        System.out.println("Governance Leadership Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        try {
            GovernanceLeadershipSample sample = new GovernanceLeadershipSample(serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Throwable error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

