/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.samples.leadership;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.client.OrganizationManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.UserIdentityManagement;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceRoleManager;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceDomain;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceAppointee;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceRoleAppointee;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceRoleHistory;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProfileIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ActorProfileProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceRoleProperties;
import org.odpi.openmetadata.http.HttpHelper;

public class GovernanceLeadershipSample {
    private static final String cdoAppointmentId = "EXEC-CDO";
    private static final String cpoAppointmentId = "EXEC-CPO";
    private static final String csoAppointmentId = "EXEC-CSO";
    private static final String corpAppointmentId = "EXEC-CORP-GOV";
    private static final String cdoForITAppointmentId = "CHIEF-INFO-ARCH";
    private static final String infraGovForITAppointmentId = "CHIEF-SYS-ARCH";
    private static final String projLeadForITAppointmentId = "CHIEF-SW-PROJ-MGR";
    private static final String julesKeeperEmpNo = "026";
    private static final String ivorPadlockEmpNo = "008";
    private static final String faithBrokerEmpNo = "010";
    private static final String erinOverviewEmpNo = "013";
    private static final String garyGeekeEmpNo = "015";
    private static final String pollyTaskerEmpNo = "005";
    private static final String reggieMintEmpNo = "018";
    private static final String julesKeeperUserId = "julesKeeper";
    private static final String ivorPadlockUserId = "ivorPadlock";
    private static final String faithBrokerUserId = "faithBroker";
    private static final String erinOverviewUserId = "erinOverview";
    private static final String garyGeekeUserId = "garyGeeke";
    private static final String pollyTaskerUserId = "pollyTasker";
    private static final String reggieMintUserId = "reggieMint";
    private static final String titlePropertyName = "title";
    private static final String initialsPropertyName = "initials";
    private static final String givenNamesPropertyName = "givenNames";
    private static final String surnamePropertyName = "surname";
    private static final String fullNamePropertyName = "fullName";
    private static final String pronounsPropertyName = "pronouns";
    private static final String jobTitlePropertyName = "jobTitle";
    private static final String employeeNumberPropertyName = "employeeNumber";
    private static final String employeeTypePropertyName = "employeeType";
    private static final String preferredLanguagePropertyName = "preferredLanguage";
    private static final String isPublicPropertyName = "isPublic";
    private static final String workLocationPropertyName = "workLocation";
    private final String serverName;
    private final String serverURLRoot;
    private final String clientUserId;

    public GovernanceLeadershipSample(String serverName, String serverURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    private void printPersonalProfile(OrganizationManagement client, String clientUserId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ActorProfileElement profile = client.getActorProfileByGUID(clientUserId, guid);
        System.out.println("----------------------------");
        System.out.println("Profile: " + guid);
        List userIdentities = profile.getUserIdentities();
        if (userIdentities == null) {
            System.out.println("  UserId: null <ERROR>");
        } else if (userIdentities.isEmpty()) {
            System.out.println("  UserIds: empty <ERROR>");
        } else if (userIdentities.size() == 1) {
            ProfileIdentityElement firstUser = (ProfileIdentityElement)userIdentities.get(0);
            UserIdentityElement userIdentity = firstUser.getUserIdentity();
            if (userIdentity == null) {
                System.out.println("  UserId: empty <ERROR>");
            } else {
                System.out.println("  UserId: " + userIdentity.getProperties().getQualifiedName());
            }
        } else {
            System.out.print("  UserIds:");
            for (ProfileIdentityElement userIdentity : userIdentities) {
                if (userIdentity == null) {
                    System.out.print(" <empty ERROR>");
                    continue;
                }
                System.out.print(" " + userIdentity.getUserIdentity().getProperties().getQualifiedName());
            }
            System.out.println();
        }
        Map extendedProperties = profile.getProfileProperties().getExtendedProperties();
        System.out.println("  Employee Id: " + String.valueOf(extendedProperties.get(employeeNumberPropertyName)));
        System.out.println("  Full Name: " + String.valueOf(extendedProperties.get(fullNamePropertyName)));
        System.out.println("  Known Name: " + profile.getProfileProperties().getKnownName());
        System.out.println("  Job Title: " + String.valueOf(extendedProperties.get(jobTitlePropertyName)));
        System.out.println("  Job Description: " + profile.getProfileProperties().getDescription());
        if (profile.getProfileProperties().getAdditionalProperties() != null) {
            System.out.println("  Work Location: " + (String)profile.getProfileProperties().getAdditionalProperties().get(workLocationPropertyName));
        }
        System.out.println("  Employee Type: " + String.valueOf(extendedProperties.get(employeeTypePropertyName)));
        System.out.println("----------------------------");
    }

    private void printGovernanceRole(GovernanceRoleManager client, String clientUserId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GovernanceRoleHistory governanceRoleElement = client.getGovernanceRoleHistoryByGUID(clientUserId, guid);
        this.printGovernanceRoleHistory(governanceRoleElement);
    }

    private void printGovernanceRoleHistory(GovernanceRoleHistory governanceRoleElement) {
        this.printGovernanceRole((GovernanceRoleElement)governanceRoleElement);
        System.out.println("  -- Current Appointees-----");
        this.printGovernanceAppointees(governanceRoleElement.getCurrentAppointees());
        System.out.println("  -- Predecessors ----------");
        this.printGovernanceAppointees(governanceRoleElement.getPredecessors());
        System.out.println("  -- Planned Successors-----");
        this.printGovernanceAppointees(governanceRoleElement.getSuccessors());
        System.out.println("----------------------------");
    }

    private void printGovernanceRoleAppointee(GovernanceRoleAppointee governanceRoleElement) {
        this.printGovernanceRole((GovernanceRoleElement)governanceRoleElement);
        this.printGovernanceAppointees(governanceRoleElement.getCurrentAppointees());
    }

    private void printGovernanceRole(GovernanceRoleElement governanceRoleElement) {
        GovernanceRoleProperties governanceRole = governanceRoleElement.getRole();
        System.out.println("----------------------------");
        System.out.println("Governance Role: " + governanceRoleElement.getElementHeader().getGUID());
        if (governanceRole != null) {
            System.out.println("  Domain: " + governanceRole.getDomainIdentifier());
            System.out.println("  Appointment Id: " + governanceRole.getRoleId());
            System.out.println("  Appointment Scope: " + governanceRole.getScope());
            System.out.println("  Title: " + governanceRole.getTitle());
        } else {
            System.out.println("  <no properties>");
        }
    }

    private void printGovernanceAppointees(List<GovernanceAppointee> appointees) {
        if (appointees == null) {
            System.out.println("  Appointee: <None> ");
        } else {
            for (GovernanceAppointee appointee : appointees) {
                if (appointee != null) {
                    System.out.println("  Appointee: " + appointee.getProfile().getProfileProperties().getKnownName());
                    System.out.println("     Start Date: " + String.valueOf(appointee.getStartDate()));
                    System.out.println("     End Date: " + String.valueOf(appointee.getEndDate()));
                    continue;
                }
                System.out.println("  Appointee: <Null> ");
            }
        }
        System.out.println("----------------------------");
    }

    private String createPersonalProfile(OrganizationManagement orgClient, UserIdentityManagement uidClient, String clientUserId, String actorUserId, String actorEmployeeNo, String pronouns, String title, String initials, String givenNames, String surname, String fullName, String knownName, String jobTitle, String jobDescription, String workLocation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = "Person";
        ActorProfileProperties actorProfileProperties = new ActorProfileProperties();
        actorProfileProperties.setTypeName("Person");
        actorProfileProperties.setQualifiedName("Person::" + actorEmployeeNo);
        actorProfileProperties.setKnownName(knownName);
        actorProfileProperties.setDescription(jobDescription);
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put(workLocationPropertyName, workLocation);
        actorProfileProperties.setAdditionalProperties(additionalProperties);
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        extendedProperties.put(titlePropertyName, title);
        extendedProperties.put(initialsPropertyName, initials);
        extendedProperties.put(givenNamesPropertyName, givenNames);
        extendedProperties.put(surnamePropertyName, surname);
        extendedProperties.put(fullNamePropertyName, fullName);
        extendedProperties.put(pronounsPropertyName, pronouns);
        extendedProperties.put(jobTitlePropertyName, jobTitle);
        extendedProperties.put(employeeNumberPropertyName, actorEmployeeNo);
        extendedProperties.put(employeeTypePropertyName, "Employee");
        extendedProperties.put(preferredLanguagePropertyName, "English");
        extendedProperties.put(isPublicPropertyName, true);
        actorProfileProperties.setExtendedProperties(extendedProperties);
        String profileGUID = orgClient.createActorProfile(clientUserId, null, null, actorProfileProperties, null);
        UserIdentityProperties userIdentityProperties = new UserIdentityProperties();
        userIdentityProperties.setQualifiedName("UserIdentity:" + actorUserId);
        userIdentityProperties.setUserId(actorUserId);
        uidClient.createUserIdentityForProfile(clientUserId, null, null, profileGUID, userIdentityProperties);
        return profileGUID;
    }

    private void deleteUserIdentity(UserIdentityManagement uidClient, String clientUserId, String actorUserId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List userIdentityElements = uidClient.getUserIdentitiesByName(clientUserId, actorUserId, 0, 0);
        for (UserIdentityElement userIdentity : userIdentityElements) {
            uidClient.deleteUserIdentity(clientUserId, null, null, userIdentity.getElementHeader().getGUID());
        }
    }

    public void run() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OrganizationManagement orgClient = new OrganizationManagement(this.serverName, this.serverURLRoot, 100);
        UserIdentityManagement uidClient = new UserIdentityManagement(this.serverName, this.serverURLRoot, 100);
        GovernanceRoleManager gplClient = new GovernanceRoleManager(this.serverName, this.serverURLRoot);
        System.out.println("Creating profiles for Jules and Ivor");
        String julesKeeperProfileGUID = this.createPersonalProfile(orgClient, uidClient, this.clientUserId, julesKeeperUserId, julesKeeperEmpNo, "He/him/his", "Mr", "J", "Julian", "Keeper", "Mr Julian Keeper", "Jules Keeper", "Chief Data and Privacy Role", "Ensuring CocoP makes the best use of data.", "2");
        this.printPersonalProfile(orgClient, this.clientUserId, julesKeeperProfileGUID);
        String ivorPadlockProfileGUID = this.createPersonalProfile(orgClient, uidClient, this.clientUserId, ivorPadlockUserId, ivorPadlockEmpNo, "He/him/his", "Mr", "I", "Ivor", "Padlock", "Mr Ivor Padlock", "Ivor Padlock", "Security Executive", "Manages security for Coco Pharmaceuticals.", "1");
        this.printPersonalProfile(orgClient, this.clientUserId, ivorPadlockProfileGUID);
        System.out.println("Creating CDO, CPO and CSO governance officers");
        GovernanceRoleProperties governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTypeName("GovernanceOfficer");
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.DATA.getOrdinal());
        governanceRoleProperties.setQualifiedName("GovernanceOfficer:EXEC-CDO");
        governanceRoleProperties.setRoleId(cdoAppointmentId);
        governanceRoleProperties.setTitle("Chief Data Role (CDO)");
        String cdoGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        this.printGovernanceRole(gplClient, this.clientUserId, cdoGUID);
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTypeName("GovernanceOfficer");
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.PRIVACY.getOrdinal());
        governanceRoleProperties.setQualifiedName("GovernanceOfficer:EXEC-CPO");
        governanceRoleProperties.setRoleId(cpoAppointmentId);
        governanceRoleProperties.setTitle("Chief Privacy Role (CPO)");
        String cpoGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        this.printGovernanceRole(gplClient, this.clientUserId, cpoGUID);
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTypeName("GovernanceOfficer");
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.SECURITY.getOrdinal());
        governanceRoleProperties.setQualifiedName("GovernanceOfficer:EXEC-CSO");
        governanceRoleProperties.setRoleId(csoAppointmentId);
        governanceRoleProperties.setTitle("Chief Security Role (CSO)");
        String csoGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        this.printGovernanceRole(gplClient, this.clientUserId, csoGUID);
        List governanceRoles = gplClient.getGovernanceRolesByDomainId(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " governance officers");
        System.out.println("Appointing CDO, CPO and CSO governance officers");
        gplClient.appointGovernanceRole(this.clientUserId, cdoGUID, julesKeeperProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, cdoGUID);
        String julesAsCPOAppointmentId = gplClient.appointGovernanceRole(this.clientUserId, cpoGUID, julesKeeperProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, cpoGUID);
        gplClient.appointGovernanceRole(this.clientUserId, csoGUID, ivorPadlockProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, csoGUID);
        System.out.println("Changing CPO to Faith");
        String faithBrokerProfileGUID = this.createPersonalProfile(orgClient, uidClient, this.clientUserId, faithBrokerUserId, faithBrokerEmpNo, "She/her/hers", "Mrs", "F C J", "Faith Charity Jean", "Broker", "Mrs Faith Charity Jean Broker", "Faith Broker", "Human Resources Director", "Providing support to Coco Pharmaceutical employees.", "1");
        this.printPersonalProfile(orgClient, this.clientUserId, faithBrokerProfileGUID);
        long handoverTime = new Date().getTime();
        Date handoverDate = new Date(handoverTime + 100L);
        gplClient.relieveGovernanceRole(this.clientUserId, cpoGUID, julesKeeperProfileGUID, julesAsCPOAppointmentId, handoverDate);
        this.printGovernanceRole(gplClient, this.clientUserId, cpoGUID);
        gplClient.appointGovernanceRole(this.clientUserId, cpoGUID, faithBrokerProfileGUID, handoverDate);
        this.printGovernanceRole(gplClient, this.clientUserId, cpoGUID);
        governanceRoles = gplClient.getGovernanceRolesByDomainId(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " governance officers");
        List governanceRoleAppointees = gplClient.getCurrentGovernanceRoleAppointments(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoleAppointees.size() + " active governance officers\n");
        for (GovernanceRoleAppointee governanceRole : governanceRoleAppointees) {
            this.printGovernanceRoleAppointee(governanceRole);
        }
        governanceRoleAppointees = gplClient.getCurrentGovernanceRoleAppointments(this.clientUserId, GovernanceDomain.PRIVACY.getOrdinal(), 0, 0);
        System.out.println(governanceRoles.size() + " privacy governance officers");
        for (GovernanceRoleAppointee governanceRole : governanceRoleAppointees) {
            this.printGovernanceRoleAppointee(governanceRole);
        }
        try {
            System.out.println("Sleeping ... until after Faith's appointment becomes active");
            Thread.sleep(15L);
        }
        catch (InterruptedException exc) {
            System.out.println("Sleep interrupted");
        }
        governanceRoleAppointees = gplClient.getCurrentGovernanceRoleAppointments(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " active governance officers");
        for (GovernanceRoleAppointee governanceRole : governanceRoleAppointees) {
            this.printGovernanceRoleAppointee(governanceRole);
        }
        ActorProfileProperties updateProperties = new ActorProfileProperties();
        HashMap<String, String> updateExtendedProperties = new HashMap<String, String>();
        updateExtendedProperties.put(jobTitlePropertyName, "Chief Data Role");
        updateProperties.setExtendedProperties(updateExtendedProperties);
        orgClient.updateActorProfile(this.clientUserId, null, null, julesKeeperProfileGUID, true, updateProperties, null);
        this.printPersonalProfile(orgClient, this.clientUserId, julesKeeperProfileGUID);
        System.out.println("Creating profile for Erin");
        String erinOverviewProfileGUID = this.createPersonalProfile(orgClient, uidClient, this.clientUserId, erinOverviewUserId, erinOverviewEmpNo, "She/her/hers", "Dr", "E", "Erin", "Overview", "Dr Erin Overview", "Erin Overview", "Information Architect", "Manages all information architecture and standards for Coco Pharmaceuticals IT systems.", "2");
        this.printPersonalProfile(orgClient, this.clientUserId, erinOverviewProfileGUID);
        System.out.println("Creating CDO for IT governance officer");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTypeName("GovernanceOfficer");
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.DATA.getOrdinal());
        governanceRoleProperties.setQualifiedName("GovernanceOfficer:CHIEF-INFO-ARCH");
        governanceRoleProperties.setRoleId(cdoForITAppointmentId);
        governanceRoleProperties.setScope("IT Systems");
        governanceRoleProperties.setTitle("Chief Data Role (CDO) for IT");
        String cdoForInfoTechGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        System.out.println("Appointing Erin as CDO for IT");
        gplClient.appointGovernanceRole(this.clientUserId, cdoForInfoTechGUID, erinOverviewProfileGUID, new Date());
        this.printGovernanceRole(gplClient, this.clientUserId, cdoForInfoTechGUID);
        System.out.println("Creating profile for Gary");
        String garyGeekeProfileGUID = this.createPersonalProfile(orgClient, uidClient, this.clientUserId, garyGeekeUserId, garyGeekeEmpNo, "He/him/his", "Mr", "G", "Gary", "Geeke", "Mr Gary Geeke", "Gary Geeke", "Infrastructure Architect", "Manages all the IT infrastructure for Coco Pharmaceuticals.", "1");
        this.printPersonalProfile(orgClient, this.clientUserId, garyGeekeProfileGUID);
        System.out.println("Creating IT governance officer");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTypeName("GovernanceOfficer");
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.IT_INFRASTRUCTURE.getOrdinal());
        governanceRoleProperties.setQualifiedName("GovernanceOfficer:CHIEF-SYS-ARCH");
        governanceRoleProperties.setRoleId(infraGovForITAppointmentId);
        governanceRoleProperties.setTitle("Chief Infrastructure Architect");
        String infraGovForITGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        System.out.println("Appointing Gary as gov officer for IT");
        gplClient.appointGovernanceRole(this.clientUserId, infraGovForITGUID, garyGeekeProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, infraGovForITGUID);
        System.out.println("Creating profile for Polly");
        String pollyTaskerProfileGUID = this.createPersonalProfile(orgClient, uidClient, this.clientUserId, pollyTaskerUserId, pollyTaskerEmpNo, "She/her/hers", "Ms", "P", "Polly", "Tasker", "Ms Polly Tasker", "Polly Tasker", "Lead Project Manager for IT", "Manages IT projects for Coco Pharmaceuticals.", "1");
        this.printPersonalProfile(orgClient, this.clientUserId, pollyTaskerProfileGUID);
        System.out.println("Creating SDLC governance officer");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTypeName("GovernanceOfficer");
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.SOFTWARE_DEVELOPMENT.getOrdinal());
        governanceRoleProperties.setQualifiedName("GovernanceOfficer:CHIEF-SW-PROJ-MGR");
        governanceRoleProperties.setRoleId(projLeadForITAppointmentId);
        governanceRoleProperties.setTitle("Chief Project Lead for Software");
        String projLeadForITGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        System.out.println("Appointing Polly as gov officer for Software Development");
        gplClient.appointGovernanceRole(this.clientUserId, projLeadForITGUID, pollyTaskerProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, projLeadForITGUID);
        System.out.println("Creating profile for Reggie");
        String reggieMintProfileGUID = this.createPersonalProfile(orgClient, uidClient, this.clientUserId, reggieMintUserId, reggieMintEmpNo, "He/him/his", "Mr", "R S P", "Reginald Sidney", "Mint", "Mr Reginald S Mint", "Reggie Mint", "Chief Finance Role", "Manages finance for Coco Pharmaceuticals.", "1");
        this.printPersonalProfile(orgClient, this.clientUserId, pollyTaskerProfileGUID);
        System.out.println("Creating corporate governance officer");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTypeName("GovernanceOfficer");
        governanceRoleProperties.setDomainIdentifier(GovernanceDomain.CORPORATE.getOrdinal());
        governanceRoleProperties.setQualifiedName("GovernanceOfficer:EXEC-CORP-GOV");
        governanceRoleProperties.setRoleId(corpAppointmentId);
        governanceRoleProperties.setTitle("Corporate Governance Role");
        String corpGUID = gplClient.createGovernanceRole(this.clientUserId, governanceRoleProperties);
        System.out.println("Appointing Reggie as corporate gov officer");
        gplClient.appointGovernanceRole(this.clientUserId, corpGUID, reggieMintProfileGUID, null);
        this.printGovernanceRole(gplClient, this.clientUserId, corpGUID);
        System.out.println("Update the CSO to the CISO");
        governanceRoleProperties = new GovernanceRoleProperties();
        governanceRoleProperties.setTitle("Chief Information Security Role (CISO)");
        gplClient.updateGovernanceRole(this.clientUserId, csoGUID, true, governanceRoleProperties);
        governanceRoles = gplClient.getGovernanceRolesByDomainId(this.clientUserId, 0, 0, 0);
        System.out.println(governanceRoles.size() + " governance officers");
        for (GovernanceRoleAppointee governanceRole : governanceRoleAppointees) {
            this.printGovernanceRoleAppointee(governanceRole);
        }
        List activeUserIdentities = uidClient.findUserIdentities(this.clientUserId, ".*", 0, 0);
        if (activeUserIdentities == null) {
            System.out.println("No user identities have been created");
            System.exit(-1);
        } else if (activeUserIdentities.size() != 7) {
            System.out.println(activeUserIdentities.size() + " number of active user identities rather than 7: " + String.valueOf(activeUserIdentities));
            System.exit(-1);
        }
        System.out.println("Deleting all profiles and governance officers");
        gplClient.deleteGovernanceRole(this.clientUserId, cdoGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, cdoForInfoTechGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, cpoGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, csoGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, corpGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, projLeadForITGUID);
        gplClient.deleteGovernanceRole(this.clientUserId, infraGovForITGUID);
        this.deleteUserIdentity(uidClient, this.clientUserId, julesKeeperUserId);
        this.deleteUserIdentity(uidClient, this.clientUserId, ivorPadlockUserId);
        this.deleteUserIdentity(uidClient, this.clientUserId, faithBrokerUserId);
        this.deleteUserIdentity(uidClient, this.clientUserId, erinOverviewUserId);
        this.deleteUserIdentity(uidClient, this.clientUserId, garyGeekeUserId);
        this.deleteUserIdentity(uidClient, this.clientUserId, reggieMintUserId);
        this.deleteUserIdentity(uidClient, this.clientUserId, pollyTaskerUserId);
        orgClient.deleteActorProfile(this.clientUserId, null, null, julesKeeperProfileGUID);
        orgClient.deleteActorProfile(this.clientUserId, null, null, ivorPadlockProfileGUID);
        orgClient.deleteActorProfile(this.clientUserId, null, null, faithBrokerProfileGUID);
        orgClient.deleteActorProfile(this.clientUserId, null, null, erinOverviewProfileGUID);
        orgClient.deleteActorProfile(this.clientUserId, null, null, garyGeekeProfileGUID);
        orgClient.deleteActorProfile(this.clientUserId, null, null, reggieMintProfileGUID);
        orgClient.deleteActorProfile(this.clientUserId, null, null, pollyTaskerProfileGUID);
        try {
            System.out.println("Sleeping ... to allow deletes to propagate");
            Thread.sleep(5000L);
        }
        catch (InterruptedException exc) {
            System.out.println("Sleep interrupted");
        }
        governanceRoles = gplClient.getGovernanceRolesByDomainId(this.clientUserId, 0, 0, 0);
        if (governanceRoles != null) {
            System.out.println(governanceRoles.size() + " governance officers");
            for (GovernanceRoleElement governanceRole : governanceRoles) {
                System.out.println(governanceRole.toString() + " is still defined");
            }
            System.exit(-1);
        } else {
            System.out.println("All governance officers gone");
        }
        List abandonedUserIdentities = uidClient.findUserIdentities(this.clientUserId, ".*", 0, 0);
        if (abandonedUserIdentities != null) {
            System.out.println(abandonedUserIdentities.size() + " abandoned user identities: " + String.valueOf(abandonedUserIdentities));
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.out.println("Please specify the server's name in the first parameter, the server's platform URL root in the second parameter and the caller's userId in the third parameter");
            System.exit(-1);
        }
        String serverName = args[0];
        String serverURLRoot = args[1];
        String clientUserId = args[2];
        HttpHelper.noStrictSSL();
        System.out.println("===============================");
        System.out.println("Governance Leadership Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        try {
            GovernanceLeadershipSample sample = new GovernanceLeadershipSample(serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

