/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.governanceofficer.admin;

import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.ViewServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.governanceofficer.ffdc.GovernanceOfficerAuditCode;
import org.odpi.openmetadata.viewservices.governanceofficer.server.GovernanceOfficerInstance;

public class GovernanceOfficerAdmin
extends ViewServiceAdmin {
    private AuditLog auditLog = null;
    private GovernanceOfficerInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfig, AuditLog auditLog, String serverUserName, int maxPageSize) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", GovernanceOfficerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        this.serverName = serverName;
        try {
            this.instance = new GovernanceOfficerInstance(serverName, auditLog, serverUserName, maxPageSize, viewServiceConfig.getOMAGServerName(), viewServiceConfig.getOMAGServerPlatformRootURL());
            auditLog.logMessage("initialize", GovernanceOfficerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(), viewServiceConfig.toString());
        }
        catch (Exception error) {
            auditLog.logException("initialize", GovernanceOfficerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(error.getMessage()), viewServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", ViewServiceDescription.GOVERNANCE_OFFICER.getViewServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", GovernanceOfficerAuditCode.SERVICE_TERMINATING.getMessageDefinition(this.serverName));
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", GovernanceOfficerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
    }
}

