/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.CertificationType;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDriver;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Regulation
extends GovernanceDriver {
    private String jurisdiction = null;
    private List<CertificationType> certificationTypes = null;

    public Regulation() {
        this.setType("Regulation");
    }

    public Regulation(Regulation template) {
        super(template);
        if (template != null) {
            this.jurisdiction = template.getJurisdiction();
            this.certificationTypes = template.getCertificationTypes();
        }
    }

    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    public List<CertificationType> getCertificationTypes() {
        return this.certificationTypes;
    }

    public void setCertificationTypes(List<CertificationType> certificationTypes) {
        this.certificationTypes = certificationTypes;
    }

    @Override
    public String toString() {
        return "Regulation{jurisdiction='" + this.jurisdiction + '\'' + ", certificationTypes=" + this.certificationTypes + ", relatedGovernanceDrivers=" + this.getRelatedGovernanceDrivers() + ", governancePolicies=" + this.getGovernancePolicies() + ", description='" + this.getDescription() + '\'' + ", scope='" + this.getScope() + '\'' + ", status=" + this.getStatus() + ", priority='" + this.getPriority() + '\'' + ", implications=" + this.getImplications() + ", outcomes=" + this.getOutcomes() + ", externalReferences=" + this.getExternalReferences() + ", additionalProperties=" + this.getAdditionalProperties() + ", governanceMetrics=" + this.getGovernanceMetrics() + ", governanceZones=" + this.getGovernanceZones() + ", GUID='" + this.getGUID() + '\'' + ", type='" + this.getType() + '\'' + ", documentId='" + this.getDocumentId() + '\'' + ", title='" + this.getTitle() + '\'' + ", summary='" + this.getSummary() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Regulation)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Regulation that = (Regulation)objectToCompare;
        return Objects.equals(this.getJurisdiction(), that.getJurisdiction()) && Objects.equals(this.getCertificationTypes(), that.getCertificationTypes());
    }
}

