/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions;

import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.GovernanceProgramCheckedExceptionBase;

public class InvalidParameterException
extends GovernanceProgramCheckedExceptionBase {
    private String parameterName;

    public InvalidParameterException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, String parameterName) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction);
        this.parameterName = parameterName;
    }

    public InvalidParameterException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, String parameterName) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, caughtError);
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public String toString() {
        return "InvalidParameterException{parameterName='" + this.parameterName + '\'' + ", reportedHTTPCode=" + this.getReportedHTTPCode() + ", reportingClassName='" + this.getReportingClassName() + '\'' + ", reportingActionDescription='" + this.getReportingActionDescription() + '\'' + ", errorMessage='" + this.getErrorMessage() + '\'' + ", reportedSystemAction='" + this.getReportedSystemAction() + '\'' + ", reportedUserAction='" + this.getReportedUserAction() + '\'' + ", reportedCaughtException=" + this.getReportedCaughtException() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InvalidParameterException)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InvalidParameterException that = (InvalidParameterException)objectToCompare;
        return Objects.equals(this.getParameterName(), that.getParameterName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getParameterName());
    }
}

