/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceRoleElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceRoleHistory
extends GovernanceRoleAppointee {
    private static final long serialVersionUID = 1L;
    private List<GovernanceAppointee> predecessors = null;
    private List<GovernanceAppointee> successors = null;

    public GovernanceRoleHistory() {
    }

    public GovernanceRoleHistory(GovernanceRoleHistory template) {
        super(template);
        if (template != null) {
            this.predecessors = template.getPredecessors();
            this.successors = template.getSuccessors();
        }
    }

    public GovernanceRoleHistory(GovernanceRoleElement template) {
        super(template);
    }

    public List<GovernanceAppointee> getPredecessors() {
        return this.predecessors;
    }

    public void setPredecessors(List<GovernanceAppointee> predecessors) {
        this.predecessors = predecessors;
    }

    public List<GovernanceAppointee> getSuccessors() {
        return this.successors;
    }

    public void setSuccessors(List<GovernanceAppointee> successors) {
        this.successors = successors;
    }

    @Override
    public String toString() {
        return "GovernanceRoleHistory{currentAppointees=" + this.getCurrentAppointees() + ", predecessors=" + this.predecessors + ", successors=" + this.successors + ", elementHeader=" + this.getElementHeader() + ", role=" + this.getRole() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceRoleHistory that = (GovernanceRoleHistory)objectToCompare;
        return Objects.equals(this.predecessors, that.predecessors) && Objects.equals(this.successors, that.successors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predecessors, this.successors);
    }
}

