/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinition;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceRelationship;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.OrganizationalControl;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.TechnicalControl;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TechnicalControl.class, name="TechnicalControl"), @JsonSubTypes.Type(value=OrganizationalControl.class, name="OrganizationalControl")})
public abstract class GovernanceControl
extends GovernanceDefinition {
    private static final long serialVersionUID = 1L;
    private List<GovernanceRelationship> relatedGovernanceDrivers = null;
    private List<GovernanceRelationship> governanceControls = null;

    public GovernanceControl() {
    }

    public GovernanceControl(GovernanceControl template) {
        super(template);
        if (template != null) {
            this.relatedGovernanceDrivers = template.getRelatedGovernanceDrivers();
            this.governanceControls = template.getGovernanceControls();
        }
    }

    public List<GovernanceRelationship> getRelatedGovernanceDrivers() {
        if (this.relatedGovernanceDrivers == null) {
            return null;
        }
        if (this.relatedGovernanceDrivers.isEmpty()) {
            return null;
        }
        return this.relatedGovernanceDrivers;
    }

    public void setRelatedGovernanceDrivers(List<GovernanceRelationship> relatedGovernanceDrivers) {
        this.relatedGovernanceDrivers = relatedGovernanceDrivers;
    }

    public List<GovernanceRelationship> getGovernanceControls() {
        if (this.governanceControls == null) {
            return null;
        }
        if (this.governanceControls.isEmpty()) {
            return null;
        }
        return this.governanceControls;
    }

    public void setGovernanceControls(List<GovernanceRelationship> governanceControls) {
        this.governanceControls = governanceControls;
    }

    @Override
    public String toString() {
        return "GovernanceControl{relatedGovernanceDrivers=" + this.relatedGovernanceDrivers + ", governanceControls=" + this.governanceControls + ", description='" + this.getDescription() + '\'' + ", scope='" + this.getScope() + '\'' + ", status=" + this.getStatus() + ", priority='" + this.getPriority() + '\'' + ", implications=" + this.getImplications() + ", outcomes=" + this.getOutcomes() + ", externalReferences=" + this.getExternalReferences() + ", additionalProperties=" + this.getAdditionalProperties() + ", governanceMetrics=" + this.getGovernanceMetrics() + ", governanceZones=" + this.getGovernanceZones() + ", GUID='" + this.getGUID() + '\'' + ", type='" + this.getType() + '\'' + ", documentId='" + this.getDocumentId() + '\'' + ", title='" + this.getTitle() + '\'' + ", summary='" + this.getSummary() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof GovernanceControl)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceControl that = (GovernanceControl)objectToCompare;
        return Objects.equals(this.getRelatedGovernanceDrivers(), that.getRelatedGovernanceDrivers()) && Objects.equals(this.getGovernanceControls(), that.getGovernanceControls());
    }
}

