/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.DataStrategy;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinition;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceRelationship;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.Regulation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataStrategy.class, name="DataStrategy"), @JsonSubTypes.Type(value=Regulation.class, name="Regulation")})
public abstract class GovernanceDriver
extends GovernanceDefinition {
    private static final long serialVersionUID = 1L;
    private List<GovernanceRelationship> relatedGovernanceDrivers = null;
    private List<GovernanceRelationship> governancePolicies = null;

    public GovernanceDriver() {
    }

    public GovernanceDriver(GovernanceDriver template) {
        super(template);
        if (template != null) {
            this.relatedGovernanceDrivers = template.getRelatedGovernanceDrivers();
            this.governancePolicies = template.getGovernancePolicies();
        }
    }

    public List<GovernanceRelationship> getRelatedGovernanceDrivers() {
        if (this.relatedGovernanceDrivers == null) {
            return null;
        }
        if (this.relatedGovernanceDrivers.isEmpty()) {
            return null;
        }
        return this.relatedGovernanceDrivers;
    }

    public void setRelatedGovernanceDrivers(List<GovernanceRelationship> relatedGovernanceDrivers) {
        this.relatedGovernanceDrivers = relatedGovernanceDrivers;
    }

    public List<GovernanceRelationship> getGovernancePolicies() {
        if (this.governancePolicies == null) {
            return null;
        }
        if (this.governancePolicies.isEmpty()) {
            return null;
        }
        return this.governancePolicies;
    }

    public void setGovernancePolicies(List<GovernanceRelationship> governancePolicies) {
        this.governancePolicies = governancePolicies;
    }

    @Override
    public String toString() {
        return "GovernanceDriver{relatedGovernanceDrivers=" + this.relatedGovernanceDrivers + ", governancePolicies=" + this.governancePolicies + ", description='" + this.getDescription() + '\'' + ", scope='" + this.getScope() + '\'' + ", status=" + this.getStatus() + ", priority='" + this.getPriority() + '\'' + ", implications=" + this.getImplications() + ", outcomes=" + this.getOutcomes() + ", externalReferences=" + this.getExternalReferences() + ", additionalProperties=" + this.getAdditionalProperties() + ", governanceMetrics=" + this.getGovernanceMetrics() + ", governanceZones=" + this.getGovernanceZones() + ", GUID='" + this.getGUID() + '\'' + ", type='" + this.getType() + '\'' + ", documentId='" + this.getDocumentId() + '\'' + ", title='" + this.getTitle() + '\'' + ", summary='" + this.getSummary() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof GovernanceDriver)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceDriver that = (GovernanceDriver)objectToCompare;
        return Objects.equals(this.getRelatedGovernanceDrivers(), that.getRelatedGovernanceDrivers()) && Objects.equals(this.getGovernancePolicies(), that.getGovernancePolicies());
    }
}

