/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.CertificationType;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceControlProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionMetric;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDefinitionStatus;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDriverProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernancePolicyProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceZoneDefinition;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.LicenseType;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=GovernanceDriverProperties.class, name="GovernanceDriverProperties"), @JsonSubTypes.Type(value=GovernancePolicyProperties.class, name="GovernancePolicyProperties"), @JsonSubTypes.Type(value=GovernanceControlProperties.class, name="GovernanceControlProperties"), @JsonSubTypes.Type(value=LicenseType.class, name="LicenseType"), @JsonSubTypes.Type(value=CertificationType.class, name="CertificationType")})
public abstract class GovernanceDefinitionProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private String summary = null;
    private String description = null;
    private String scope = null;
    private GovernanceDefinitionStatus status = null;
    private String priority = null;
    private List<String> implications = null;
    private List<String> outcomes = null;
    private List<GovernanceDefinitionMetric> governanceMetrics = null;
    private List<GovernanceZoneDefinition> governanceZones = null;

    public GovernanceDefinitionProperties() {
    }

    public GovernanceDefinitionProperties(GovernanceDefinitionProperties template) {
        super(template);
        if (template != null) {
            this.title = template.getTitle();
            this.summary = template.getSummary();
            this.description = template.getDescription();
            this.scope = template.getScope();
            this.status = template.getStatus();
            this.priority = template.getPriority();
            this.implications = template.getImplications();
            this.outcomes = template.getOutcomes();
            this.governanceMetrics = template.getGovernanceMetrics();
            this.governanceZones = template.getGovernanceZones();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public GovernanceDefinitionStatus getStatus() {
        return this.status;
    }

    public void setStatus(GovernanceDefinitionStatus status) {
        this.status = status;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public List<String> getImplications() {
        return this.implications;
    }

    public void setImplications(List<String> implications) {
        this.implications = implications;
    }

    public List<String> getOutcomes() {
        if (this.outcomes == null) {
            return null;
        }
        if (this.outcomes.isEmpty()) {
            return null;
        }
        return this.outcomes;
    }

    public void setOutcomes(List<String> outcomes) {
        this.outcomes = outcomes;
    }

    public List<GovernanceDefinitionMetric> getGovernanceMetrics() {
        return this.governanceMetrics;
    }

    public void setGovernanceMetrics(List<GovernanceDefinitionMetric> governanceMetrics) {
        this.governanceMetrics = governanceMetrics;
    }

    public List<GovernanceZoneDefinition> getGovernanceZones() {
        if (this.governanceZones == null) {
            return null;
        }
        if (this.governanceZones.isEmpty()) {
            return null;
        }
        return this.governanceZones;
    }

    public void setGovernanceZones(List<GovernanceZoneDefinition> governanceZones) {
        this.governanceZones = governanceZones;
    }

    @Override
    public String toString() {
        return "GovernanceDefinitionProperties{title='" + this.title + '\'' + ", summary='" + this.summary + '\'' + ", description='" + this.description + '\'' + ", scope='" + this.scope + '\'' + ", status=" + this.status + ", priority='" + this.priority + '\'' + ", implications=" + this.implications + ", outcomes=" + this.outcomes + ", governanceMetrics=" + this.governanceMetrics + ", governanceZones=" + this.governanceZones + ", typeName='" + this.getTypeName() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof GovernanceDefinitionProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceDefinitionProperties that = (GovernanceDefinitionProperties)objectToCompare;
        return Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getScope(), that.getScope()) && this.getStatus() == that.getStatus() && Objects.equals(this.getPriority(), that.getPriority()) && Objects.equals(this.getImplications(), that.getImplications()) && Objects.equals(this.getOutcomes(), that.getOutcomes()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties()) && Objects.equals(this.getGovernanceMetrics(), that.getGovernanceMetrics()) && Objects.equals(this.getGovernanceZones(), that.getGovernanceZones());
    }
}

