/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ExternalReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private String type = null;
    private List<String> classifications = null;
    private String externalReferenceId = null;
    private String localReferenceId = null;
    private String displayName = null;
    private String linkDescription = null;
    private String resourceDescription = null;
    private String uri = null;
    private String version = null;
    private String organization = null;
    private Map<String, Object> additionalProperties = null;

    public ExternalReference() {
    }

    public ExternalReference(ExternalReference template) {
        if (template != null) {
            this.guid = template.getGUID();
            this.type = template.getType();
            this.classifications = template.getClassifications();
            this.localReferenceId = template.getLocalReferenceId();
            this.additionalProperties = template.getAdditionalProperties();
            this.externalReferenceId = template.getExternalReferenceId();
            this.linkDescription = template.getLinkDescription();
            this.displayName = template.getDisplayName();
            this.uri = template.getURI();
            this.resourceDescription = template.getResourceDescription();
            this.version = template.getVersion();
            this.organization = template.getOrganization();
        }
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.classifications);
    }

    public void setClassifications(List<String> classifications) {
        this.classifications = classifications;
    }

    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public String getLocalReferenceId() {
        return this.localReferenceId;
    }

    public void setLocalReferenceId(String localReferenceId) {
        this.localReferenceId = localReferenceId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getLinkDescription() {
        return this.linkDescription;
    }

    public void setLinkDescription(String linkDescription) {
        this.linkDescription = linkDescription;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Map<String, Object> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.additionalProperties);
    }

    public String toString() {
        return "ExternalReference{guid='" + this.guid + '\'' + ", type=" + this.type + ", displayName='" + this.displayName + '\'' + ", externalReferenceId='" + this.externalReferenceId + '\'' + ", localReferenceId='" + this.localReferenceId + '\'' + ", URI='" + this.uri + '\'' + ", classifications=" + this.classifications + ", linkDescription='" + this.linkDescription + '\'' + ", uri='" + this.uri + '\'' + ", resourceDescription='" + this.resourceDescription + '\'' + ", version='" + this.version + '\'' + ", organization='" + this.organization + '\'' + ", additionalProperties=" + this.additionalProperties + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ExternalReference)) {
            return false;
        }
        ExternalReference that = (ExternalReference)objectToCompare;
        return Objects.equals(this.getGUID(), that.getGUID()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getClassifications(), that.getClassifications()) && Objects.equals(this.getLocalReferenceId(), that.getLocalReferenceId()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties()) && Objects.equals(this.getExternalReferenceId(), that.getExternalReferenceId()) && Objects.equals(this.getLinkDescription(), that.getLinkDescription()) && Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.uri, that.uri) && Objects.equals(this.getResourceDescription(), that.getResourceDescription()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getOrganization(), that.getOrganization());
    }

    public int hashCode() {
        return Objects.hash(this.guid);
    }
}

