/* SPDX-License-Identifier: Apache 2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
/**
 * Governance Program OMAS Java API defined the means to maintain and query the definitions that make up the governance program.
 *
 * <ul>
 *   <li>
 *       GovernanceDomainInterface - Describes the different focus areas of governance in the organization.
 *   </li>
 *   <li>
 *       GovernanceDefinitionsInterface - Supports the definition of the governance drivers, policies and controls
 *       that define the motivation, goals and implementation approach for the governance program.
 *   </li>
 *   <li>
 *       GovernanceMetricsInterface - Defines the metrics that measure the success of the governance program.  Typically a
 *       metric is associated with a governance definition.
 *   </li>
 *   <li>
 *       GovernanceClassificationLevelInterface - Defines the means of the standard governance classifications of Impact, Criticality,
 *       Retention, Confidence and Confidentiality.
 *   </li>
 *   <li>
 *       GovernanceRolesInterface - Defines the roles for the governance organization and the means to appoint people to them.
 *   </li>
 *   <li>
 *       GovernanceZonesInterface - Defines the governance zones for organizing assets so they can be governed.
 *   </li>
 *   <li>
 *       SubjectAreasInterface - Defines the subject areas for organizing data definitions so they can be governed.
 *   </li>
 *   <li>
 *       CertificationManagementInterface - Defines the types of certifications that form part of the governance program and the means
 *       to certify elements.
 *   </li>
 *   <li>
 *       RightsManagementInterface - Defines the types of licenses that form part of the governance program and the means
 *       to license elements.
 *   </li>
 *   <li>
 *       ExternalReferencesInterface - for managing external references to governance definitions.
 *   </li>
 *   <li>
 *       GovernanceProgramReviewInterface - for reviewing the status of the governance program.
 *   </li>
 * </ul>
 */
package org.odpi.openmetadata.accessservices.governanceprogram.api;