/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.SupplementaryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetProperties
extends SupplementaryProperties {
    private static final long serialVersionUID = 1L;
    private String technicalName = null;
    private String versionIdentifier = null;
    private String technicalDescription = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.technicalName = template.getDisplayName();
            this.versionIdentifier = template.getVersionIdentifier();
            this.technicalDescription = template.getTechnicalDescription();
        }
    }

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getTechnicalDescription() {
        return this.technicalDescription;
    }

    public void setTechnicalDescription(String technicalDescription) {
        this.technicalDescription = technicalDescription;
    }

    @Override
    public String toString() {
        return "AssetProperties{technicalName='" + this.technicalName + "', versionIdentifier='" + this.versionIdentifier + "', technicalDescription='" + this.technicalDescription + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + ", displayName='" + this.getDisplayName() + "', summary='" + this.getSummary() + "', description='" + this.getDescription() + "', abbreviation='" + this.getAbbreviation() + "', usage='" + this.getUsage() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        if (this.technicalName != null ? !this.technicalName.equals(that.technicalName) : that.technicalName != null) {
            return false;
        }
        if (this.versionIdentifier != null ? !this.versionIdentifier.equals(that.versionIdentifier) : that.versionIdentifier != null) {
            return false;
        }
        return this.technicalDescription != null ? this.technicalDescription.equals(that.technicalDescription) : that.technicalDescription == null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.technicalName, this.versionIdentifier, this.technicalDescription);
    }
}

