/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.accessservices.governanceprogram.metadataelements.RelatedElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceDefinitionGraph
extends GovernanceDefinitionElement {
    private List<RelatedElement> parents = null;
    private List<RelatedElement> peers = null;
    private List<RelatedElement> children = null;
    private List<RelatedElement> metrics = null;
    private List<RelatedElement> externalReferences = null;
    private List<RelatedElement> others = null;

    public GovernanceDefinitionGraph() {
    }

    public GovernanceDefinitionGraph(GovernanceDefinitionGraph template) {
        super(template);
        if (template != null) {
            this.parents = template.getParents();
            this.peers = template.getPeers();
            this.children = template.getChildren();
            this.metrics = template.getMetrics();
            this.externalReferences = template.getExternalReferences();
            this.others = template.getOthers();
        }
    }

    public List<RelatedElement> getParents() {
        if (this.parents == null) {
            return null;
        }
        if (this.parents.isEmpty()) {
            return null;
        }
        return this.parents;
    }

    public void setParents(List<RelatedElement> parents) {
        this.parents = parents;
    }

    public List<RelatedElement> getPeers() {
        if (this.peers == null) {
            return null;
        }
        if (this.peers.isEmpty()) {
            return null;
        }
        return this.peers;
    }

    public void setPeers(List<RelatedElement> peers) {
        this.peers = peers;
    }

    public List<RelatedElement> getChildren() {
        if (this.children == null) {
            return null;
        }
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children;
    }

    public void setChildren(List<RelatedElement> children) {
        this.children = children;
    }

    public List<RelatedElement> getMetrics() {
        if (this.metrics == null) {
            return null;
        }
        if (this.metrics.isEmpty()) {
            return null;
        }
        return this.metrics;
    }

    public void setMetrics(List<RelatedElement> metrics) {
        this.metrics = metrics;
    }

    public List<RelatedElement> getExternalReferences() {
        if (this.externalReferences == null) {
            return null;
        }
        if (this.externalReferences.isEmpty()) {
            return null;
        }
        return this.externalReferences;
    }

    public void setExternalReferences(List<RelatedElement> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public List<RelatedElement> getOthers() {
        return this.others;
    }

    public void setOthers(List<RelatedElement> others) {
        this.others = others;
    }

    @Override
    public String toString() {
        return "GovernanceDefinitionGraph{relatedElement=" + this.getRelatedElement() + ", elementHeader=" + this.getElementHeader() + ", properties=" + this.getProperties() + ", parents=" + this.parents + ", peers=" + this.peers + ", children=" + this.children + ", metrics=" + this.metrics + ", externalReferences=" + this.externalReferences + ", others=" + this.others + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof GovernanceDefinitionGraph)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceDefinitionGraph that = (GovernanceDefinitionGraph)objectToCompare;
        return Objects.equals(this.parents, that.parents) && Objects.equals(this.peers, that.peers) && Objects.equals(this.children, that.children) && Objects.equals(this.metrics, that.metrics) && Objects.equals(this.others, that.others) && Objects.equals(this.externalReferences, that.externalReferences);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parents, this.peers, this.children, this.metrics, this.externalReferences, this.others);
    }
}

