/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.ExternalSourceRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferenceableRequestBody
extends ExternalSourceRequestBody {
    private String anchorGUID = null;
    private ReferenceableProperties properties = null;

    public ReferenceableRequestBody() {
    }

    public ReferenceableRequestBody(ReferenceableRequestBody template) {
        super(template);
        if (template != null) {
            this.anchorGUID = template.getAnchorGUID();
            this.properties = template.getProperties();
        }
    }

    public ReferenceableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ReferenceableProperties properties) {
        this.properties = properties;
    }

    public String getAnchorGUID() {
        return this.anchorGUID;
    }

    public void setAnchorGUID(String anchorGUID) {
        this.anchorGUID = anchorGUID;
    }

    @Override
    public String toString() {
        return "ReferenceableRequestBody{externalSourceGUID='" + this.getExternalSourceGUID() + "', externalSourceName='" + this.getExternalSourceName() + "', anchorGUID='" + this.anchorGUID + "', properties=" + this.properties + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ReferenceableRequestBody)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ReferenceableRequestBody that = (ReferenceableRequestBody)objectToCompare;
        return Objects.equals(this.anchorGUID, that.anchorGUID) && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.anchorGUID, this.properties);
    }
}

