/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.samples;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramLeadership;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficer;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficerAppointee;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.UserIdentity;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class GovernanceLeadershipSample {
    private static final String cdoAppointmentId = "EXEC-CDO";
    private static final String cpoAppointmentId = "EXEC-CPO";
    private static final String csoAppointmentId = "EXEC-CSO";
    private static final String corpAppointmentId = "EXEC-CORP-GOV";
    private static final String cdoForITAppointmentId = "CHIEF-INFO-ARCH";
    private static final String infraGovForITAppointmentId = "CHIEF-SYS-ARCH";
    private static final String projLeadForITAppointmentId = "CHIEF-SW-PROJ-MGR";
    private static final String julesKeeperEmpNo = "026";
    private static final String ivorPadlockEmpNo = "008";
    private static final String faithBrokerEmpNo = "010";
    private static final String erinOverviewEmpNo = "013";
    private static final String garyGeekeEmpNo = "015";
    private static final String pollyTaskerEmpNo = "005";
    private static final String reggieMintEmpNo = "018";
    private static final String julesKeeperUserId = "julesKeeper";
    private static final String ivorPadlockUserId = "ivorPadlock";
    private static final String faithBrokerUserId = "faithBroker";
    private static final String erinOverviewUserId = "erinOverview";
    private static final String garyGeekeUserId = "garyGeeke";
    private static final String pollyTaskerUserId = "pollyTasker";
    private static final String reggieMintUserId = "reggieMint";
    private static final String workLocationPropertyName = "WorkLocation";
    private static final String contactTypePropertyName = "ContactType";
    private String serverName;
    private String serverURLRoot;
    private String clientUserId;

    private GovernanceLeadershipSample(String serverName, String serverURLRoot, String clientUserId) {
        this.serverName = serverName;
        this.serverURLRoot = serverURLRoot;
        this.clientUserId = clientUserId;
    }

    private void printPersonalProfile(GovernanceProgramLeadership client, String clientUserId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        PersonalProfile profile = client.getPersonalProfileByGUID(clientUserId, guid);
        System.out.println("----------------------------");
        System.out.println("Profile: " + guid);
        List userIdentities = profile.getAssociatedUserIds();
        if (userIdentities == null) {
            System.out.println("  UserId: null <ERROR>");
        } else if (userIdentities.size() == 0) {
            System.out.println("  UserIds: empty <ERROR>");
        } else if (userIdentities.size() == 1) {
            UserIdentity userIdentity = (UserIdentity)userIdentities.get(0);
            if (userIdentity == null) {
                System.out.println("  UserId: empty <ERROR>");
            } else {
                System.out.println("  UserId: " + userIdentity.getUserId());
            }
        } else {
            System.out.print("  UserIds:");
            for (UserIdentity userIdentity : userIdentities) {
                if (userIdentity == null) {
                    System.out.print(" <empty ERROR>");
                    continue;
                }
                System.out.print(" " + userIdentity.getUserId());
            }
            System.out.println();
        }
        System.out.println("  Employee Id: " + profile.getEmployeeNumber());
        System.out.println("  Full Name: " + profile.getFullName());
        System.out.println("  Known Name: " + profile.getKnownName());
        System.out.println("  Job Title: " + profile.getJobTitle());
        System.out.println("  Job Description: " + profile.getJobRoleDescription());
        System.out.println("  Work Location: " + (String)profile.getAdditionalProperties().get(workLocationPropertyName));
        System.out.println("  Contact Type: " + (String)profile.getAdditionalProperties().get(contactTypePropertyName));
        System.out.println("----------------------------");
    }

    private void printGovernanceOfficer(GovernanceProgramLeadership client, String clientUserId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GovernanceOfficer governanceOfficer = client.getGovernanceOfficerByGUID(clientUserId, guid);
        System.out.println("----------------------------");
        System.out.println("Governance Officer: " + guid);
        System.out.println("  Domain: " + governanceOfficer.getGovernanceDomain());
        System.out.println("  Appointment Id: " + governanceOfficer.getAppointmentId());
        System.out.println("  Appointment Context: " + governanceOfficer.getAppointmentContext());
        System.out.println("  Title: " + governanceOfficer.getTitle());
        GovernanceOfficerAppointee appointee = governanceOfficer.getAppointee();
        if (appointee != null) {
            System.out.println("  Appointee: " + appointee.getProfile().getKnownName());
            System.out.println("  Start Date: " + appointee.getStartDate());
            System.out.println("  End Date: " + appointee.getEndDate());
        } else {
            System.out.println("  Appointee: <None> ");
        }
        System.out.println("----------------------------");
    }

    private void run() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GovernanceProgramLeadership client = new GovernanceProgramLeadership(this.serverName, this.serverURLRoot);
        System.out.println("Creating profiles for Jules and Ivor");
        HashMap<String, String> julesAdditionalProperties = new HashMap<String, String>();
        julesAdditionalProperties.put(workLocationPropertyName, "2");
        julesAdditionalProperties.put(contactTypePropertyName, "Employee");
        String julesKeeperProfileGUID = client.createPersonalProfile(this.clientUserId, julesKeeperUserId, julesKeeperEmpNo, "Julian Keeper", "Jules Keeper", "Chief Data and Privacy Officer", "Ensuring CocoP makes the best use of data.", julesAdditionalProperties);
        this.printPersonalProfile(client, this.clientUserId, julesKeeperProfileGUID);
        HashMap<String, String> ivorAdditionalProperties = new HashMap<String, String>();
        ivorAdditionalProperties.put(workLocationPropertyName, "1");
        ivorAdditionalProperties.put(contactTypePropertyName, "Employee");
        String ivorPadlockProfileGUID = client.createPersonalProfile(this.clientUserId, ivorPadlockUserId, ivorPadlockEmpNo, null, "Ivor Padlock", "Security Executive", "Manages security for Coco Pharmaceuticals.", ivorAdditionalProperties);
        this.printPersonalProfile(client, this.clientUserId, ivorPadlockProfileGUID);
        System.out.println("Creating CDO, CPO and CSO governance officers");
        String cdoGUID = client.createGovernanceOfficer(this.clientUserId, GovernanceDomain.DATA, cdoAppointmentId, null, "Chief Data Officer (CDO)", null, null);
        this.printGovernanceOfficer(client, this.clientUserId, cdoGUID);
        String cpoGUID = client.createGovernanceOfficer(this.clientUserId, GovernanceDomain.PRIVACY, cpoAppointmentId, null, "Chief Privacy Officer (CPO)", null, null);
        this.printGovernanceOfficer(client, this.clientUserId, cpoGUID);
        String csoGUID = client.createGovernanceOfficer(this.clientUserId, GovernanceDomain.SECURITY, csoAppointmentId, null, "Chief Security Officer (CSO)", null, null);
        this.printGovernanceOfficer(client, this.clientUserId, csoGUID);
        List governanceOfficers = client.getGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " governance officers");
        System.out.println("Appointing CDO, CPO and CSO governance officers");
        client.appointGovernanceOfficer(this.clientUserId, cdoGUID, julesKeeperProfileGUID, null);
        this.printGovernanceOfficer(client, this.clientUserId, cdoGUID);
        client.appointGovernanceOfficer(this.clientUserId, cpoGUID, julesKeeperProfileGUID, null);
        this.printGovernanceOfficer(client, this.clientUserId, cpoGUID);
        client.appointGovernanceOfficer(this.clientUserId, csoGUID, ivorPadlockProfileGUID, null);
        this.printGovernanceOfficer(client, this.clientUserId, csoGUID);
        System.out.println("Changing CPO to Faith");
        HashMap<String, String> faithAdditionalProperties = new HashMap<String, String>();
        faithAdditionalProperties.put(workLocationPropertyName, "1");
        faithAdditionalProperties.put(contactTypePropertyName, "Employee");
        String faithBrokerProfileGUID = client.createPersonalProfile(this.clientUserId, faithBrokerUserId, faithBrokerEmpNo, "Faith Charity Broker", "Faith Broker", "Human Resources Director", "Providing support to Coco Pharmaceutical employees.", faithAdditionalProperties);
        this.printPersonalProfile(client, this.clientUserId, faithBrokerProfileGUID);
        long handoverTime = new Date().getTime();
        Date handoverDate = new Date(handoverTime + 100L);
        client.relieveGovernanceOfficer(this.clientUserId, cpoGUID, julesKeeperProfileGUID, handoverDate);
        this.printGovernanceOfficer(client, this.clientUserId, cpoGUID);
        client.appointGovernanceOfficer(this.clientUserId, cpoGUID, faithBrokerProfileGUID, handoverDate);
        this.printGovernanceOfficer(client, this.clientUserId, cpoGUID);
        governanceOfficers = client.getGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " governance officers");
        governanceOfficers = client.getActiveGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " active governance officers");
        for (GovernanceOfficer governanceOfficer : governanceOfficers) {
            System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the " + governanceOfficer.getTitle());
        }
        governanceOfficers = client.getGovernanceOfficersByDomain(this.clientUserId, GovernanceDomain.PRIVACY);
        System.out.println(governanceOfficers.size() + " privacy governance officers");
        for (GovernanceOfficer governanceOfficer : governanceOfficers) {
            System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the privacy officer from " + governanceOfficer.getAppointee().getStartDate() + " to " + governanceOfficer.getAppointee().getEndDate());
        }
        try {
            System.out.println("Sleeping ... until after Faith's appointment becomes active");
            Thread.sleep(15L);
        }
        catch (InterruptedException exc) {
            System.out.println("Sleep interrupted");
        }
        governanceOfficers = client.getActiveGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " active governance officers");
        for (GovernanceOfficer governanceOfficer : governanceOfficers) {
            System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the " + governanceOfficer.getTitle());
        }
        client.updatePersonalProfile(this.clientUserId, julesKeeperProfileGUID, julesKeeperEmpNo, "Julian Keeper", "Jules Keeper", "Chief Data Officer", "Ensuring CocoP makes the best use of data.", julesAdditionalProperties);
        this.printPersonalProfile(client, this.clientUserId, julesKeeperProfileGUID);
        System.out.println("Creating profile for Erin");
        HashMap<String, String> erinAdditionalProperties = new HashMap<String, String>();
        erinAdditionalProperties.put(workLocationPropertyName, "2");
        erinAdditionalProperties.put(contactTypePropertyName, "Employee");
        String erinOverviewProfileGUID = client.createPersonalProfile(this.clientUserId, erinOverviewUserId, erinOverviewEmpNo, null, "Erin Overview", "Information Architect", "Manages all information architecture and standards for Coco Pharmaceuticals IT systems.", erinAdditionalProperties);
        this.printPersonalProfile(client, this.clientUserId, erinOverviewProfileGUID);
        System.out.println("Creating CDO for IT governance officer");
        String cdoForITGUID = client.createGovernanceOfficer(this.clientUserId, GovernanceDomain.DATA, cdoForITAppointmentId, "IT Systems", "Chief Data Officer (CDO) for IT", null, null);
        System.out.println("Appointing Erin as CDO for IT");
        client.appointGovernanceOfficer(this.clientUserId, cdoForITGUID, erinOverviewProfileGUID, new Date());
        this.printGovernanceOfficer(client, this.clientUserId, cdoForITGUID);
        System.out.println("Creating profile for Gary");
        HashMap<String, String> garyAdditionalProperties = new HashMap<String, String>();
        garyAdditionalProperties.put(workLocationPropertyName, "1");
        garyAdditionalProperties.put(contactTypePropertyName, "Employee");
        String garyGeekeProfileGUID = client.createPersonalProfile(this.clientUserId, garyGeekeUserId, garyGeekeEmpNo, null, "Gary Geeke", "Infrastructure Architect", "Manages all the IT infrastructure for Coco Pharmaceuticals.", garyAdditionalProperties);
        this.printPersonalProfile(client, this.clientUserId, garyGeekeProfileGUID);
        System.out.println("Creating IT governance officer");
        String infraGovForITGUID = client.createGovernanceOfficer(this.clientUserId, GovernanceDomain.IT_INFRASTRUCTURE, infraGovForITAppointmentId, null, "Chief Infrastructure Architect", null, null);
        System.out.println("Appointing Gary as gov officer for IT");
        client.appointGovernanceOfficer(this.clientUserId, infraGovForITGUID, garyGeekeProfileGUID, null);
        this.printGovernanceOfficer(client, this.clientUserId, infraGovForITGUID);
        System.out.println("Creating profile for Gary");
        HashMap<String, String> pollyAdditionalProperties = new HashMap<String, String>();
        pollyAdditionalProperties.put(workLocationPropertyName, "1");
        pollyAdditionalProperties.put(contactTypePropertyName, "Employee");
        String pollyTaskerProfileGUID = client.createPersonalProfile(this.clientUserId, pollyTaskerUserId, pollyTaskerEmpNo, null, "Polly Tasker", "Lead Project Manager for IT", "Manages IT projects for Coco Pharmaceuticals.", pollyAdditionalProperties);
        this.printPersonalProfile(client, this.clientUserId, pollyTaskerProfileGUID);
        System.out.println("Creating SDLC governance officer");
        String projLeadForITGUID = client.createGovernanceOfficer(this.clientUserId, GovernanceDomain.SOFTWARE_DEVELOPMENT, projLeadForITAppointmentId, null, "Chief Project Lead for Software", null, null);
        System.out.println("Appointing Polly as gov officer for Software Development");
        client.appointGovernanceOfficer(this.clientUserId, projLeadForITGUID, pollyTaskerProfileGUID, null);
        this.printGovernanceOfficer(client, this.clientUserId, projLeadForITGUID);
        System.out.println("Creating profile for Reggie");
        HashMap<String, String> reggieAdditionalProperties = new HashMap<String, String>();
        reggieAdditionalProperties.put(workLocationPropertyName, "1");
        reggieAdditionalProperties.put(contactTypePropertyName, "Employee");
        String reggieMintProfileGUID = client.createPersonalProfile(this.clientUserId, reggieMintUserId, reggieMintEmpNo, "Reginald S P Mint", "Reggie Mint", "Chief Finance Officer", "Manages finance for Coco Pharmaceuticals.", reggieAdditionalProperties);
        this.printPersonalProfile(client, this.clientUserId, pollyTaskerProfileGUID);
        System.out.println("Creating corporate governance officer");
        String corpGUID = client.createGovernanceOfficer(this.clientUserId, GovernanceDomain.CORPORATE, corpAppointmentId, null, "Corporate Governance Officer", null, null);
        System.out.println("Appointing Reggie as corporate gov officer");
        client.appointGovernanceOfficer(this.clientUserId, corpGUID, reggieMintProfileGUID, null);
        this.printGovernanceOfficer(client, this.clientUserId, corpGUID);
        System.out.println("Update the CSO to the CISO");
        client.updateGovernanceOfficer(this.clientUserId, csoGUID, GovernanceDomain.SECURITY, csoAppointmentId, null, "Chief Information Security Officer (CISO)", null, null);
        governanceOfficers = client.getGovernanceOfficers(this.clientUserId);
        System.out.println(governanceOfficers.size() + " governance officers");
        for (GovernanceOfficer governanceOfficer : governanceOfficers) {
            System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the " + governanceOfficer.getTitle());
        }
        client.deleteGovernanceOfficer(this.clientUserId, cdoGUID, cdoAppointmentId, GovernanceDomain.DATA);
        client.deleteGovernanceOfficer(this.clientUserId, cdoForITGUID, cdoForITAppointmentId, GovernanceDomain.DATA);
        client.deleteGovernanceOfficer(this.clientUserId, cpoGUID, cpoAppointmentId, GovernanceDomain.PRIVACY);
        client.deleteGovernanceOfficer(this.clientUserId, csoGUID, csoAppointmentId, GovernanceDomain.SECURITY);
        client.deleteGovernanceOfficer(this.clientUserId, corpGUID, corpAppointmentId, GovernanceDomain.CORPORATE);
        client.deleteGovernanceOfficer(this.clientUserId, projLeadForITGUID, projLeadForITAppointmentId, GovernanceDomain.SOFTWARE_DEVELOPMENT);
        client.deleteGovernanceOfficer(this.clientUserId, infraGovForITGUID, infraGovForITAppointmentId, GovernanceDomain.IT_INFRASTRUCTURE);
        client.deletePersonalProfile(this.clientUserId, julesKeeperProfileGUID, julesKeeperEmpNo);
        client.deletePersonalProfile(this.clientUserId, ivorPadlockProfileGUID, ivorPadlockEmpNo);
        client.deletePersonalProfile(this.clientUserId, faithBrokerProfileGUID, faithBrokerEmpNo);
        client.deletePersonalProfile(this.clientUserId, erinOverviewProfileGUID, erinOverviewEmpNo);
        client.deletePersonalProfile(this.clientUserId, garyGeekeProfileGUID, garyGeekeEmpNo);
        client.deletePersonalProfile(this.clientUserId, reggieMintProfileGUID, reggieMintEmpNo);
        client.deletePersonalProfile(this.clientUserId, pollyTaskerProfileGUID, pollyTaskerEmpNo);
        governanceOfficers = client.getGovernanceOfficers(this.clientUserId);
        if (governanceOfficers != null) {
            System.out.println(governanceOfficers.size() + " governance officers");
            for (GovernanceOfficer governanceOfficer : governanceOfficers) {
                System.out.println(governanceOfficer.getAppointee().getProfile().getKnownName() + " is the " + governanceOfficer.getTitle());
            }
            System.exit(-1);
        } else {
            System.out.println("All governance officers gone");
        }
    }

    public static void main(String[] args) {
        BasicConfigurator.configure((Appender)new NullAppender());
        if (args == null || args.length < 3) {
            System.out.println("Please specify the server's name in the first parameter, the server's platform URL root in the second parameter and the caller's userId in the third parameter");
            System.exit(-1);
        }
        String serverName = args[0];
        String serverURLRoot = args[1];
        String clientUserId = args[2];
        System.out.println("===============================");
        System.out.println("Governance Leadership Sample   ");
        System.out.println("===============================");
        System.out.println("Running against server: " + serverName + " at " + serverURLRoot);
        System.out.println("Using userId: " + clientUserId);
        try {
            GovernanceLeadershipSample sample = new GovernanceLeadershipSample(serverName, serverURLRoot, clientUserId);
            sample.run();
        }
        catch (Throwable error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

