/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.GovernanceProgramErrorCode;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.EmployeeNumberNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceProgramOMASAPIResponse;

public class GovernanceProgramExceptionHandler {
    private String omasServerURL;

    public GovernanceProgramExceptionHandler(String newServerURL) {
        this.omasServerURL = newServerURL;
    }

    public void validateOMASServerURL(String methodName) throws PropertyServerException {
        if (this.omasServerURL == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateUserId(String userId, String methodName) throws UserNotAuthorizedException {
        if (userId == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), null);
        }
    }

    public void validateGUID(String guid, String guidParameter, String expectedTypeName, String methodName) throws UnrecognizedGUIDException {
        if (guid == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameter, methodName});
            throw new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), expectedTypeName, null);
        }
    }

    public void validateName(String name, String nameParameter, String methodName) throws InvalidParameterException {
        if (name == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameter, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), nameParameter);
        }
    }

    public void validateGovernanceDomain(GovernanceDomain governanceDomain, String nameParameter, String methodName) throws InvalidParameterException {
        if (governanceDomain == null) {
            GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.NULL_ENUM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameter, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), nameParameter);
        }
    }

    public void detectAndThrowUnrecognizedGUIDException(String methodName, GovernanceProgramOMASAPIResponse restResult) throws UnrecognizedGUIDException {
        String exceptionClassName = UnrecognizedGUIDException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            String guid = null;
            String expectedTypeName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null) {
                Object property = exceptionProperties.get("guid");
                if (property != null) {
                    guid = (String)property;
                }
                if ((property = exceptionProperties.get("expectedTypeName")) != null) {
                    expectedTypeName = (String)property;
                }
            }
            throw new UnrecognizedGUIDException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), expectedTypeName, guid);
        }
    }

    public void detectAndThrowInvalidParameterException(String methodName, GovernanceProgramOMASAPIResponse restResult) throws InvalidParameterException {
        String exceptionClassName = InvalidParameterException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String paramName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                paramName = (String)nameObject;
            }
            throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), paramName);
        }
    }

    public void detectAndThrowEmployeeNumberNotUniqueException(String methodName, GovernanceProgramOMASAPIResponse restResult) throws EmployeeNumberNotUniqueException {
        String exceptionClassName = EmployeeNumberNotUniqueException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object duplicateProfilesObject;
            List duplicateProfiles = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (duplicateProfilesObject = exceptionProperties.get("duplicateProfiles")) != null) {
                duplicateProfiles = (List)duplicateProfilesObject;
            }
            throw new EmployeeNumberNotUniqueException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), duplicateProfiles);
        }
    }

    public void detectAndThrowAppointmentIdNotUniqueException(String methodName, GovernanceProgramOMASAPIResponse restResult) throws AppointmentIdNotUniqueException {
        String exceptionClassName = EmployeeNumberNotUniqueException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object duplicateProfilesObject;
            List duplicatesPosts = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (duplicateProfilesObject = exceptionProperties.get("duplicatePosts")) != null) {
                duplicatesPosts = (List)duplicateProfilesObject;
            }
            throw new AppointmentIdNotUniqueException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), duplicatesPosts);
        }
    }

    public void detectAndThrowPropertyServerException(String methodName, GovernanceProgramOMASAPIResponse restResult) throws PropertyServerException {
        String exceptionClassName = PropertyServerException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new PropertyServerException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    public void detectAndThrowUserNotAuthorizedException(String methodName, GovernanceProgramOMASAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object userIdObject;
            String userId = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
                userId = (String)userIdObject;
            }
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), userId);
        }
    }

    public void handleRESTRequestFailure(String methodName, Throwable error) throws PropertyServerException {
        GovernanceProgramErrorCode errorCode = GovernanceProgramErrorCode.CLIENT_SIDE_REST_API_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
    }
}

