/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.governanceprogram.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceprogram.GovernanceLeadershipInterface;
import org.odpi.openmetadata.accessservices.governanceprogram.client.GovernanceProgramExceptionHandler;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.AppointmentIdNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.EmployeeNumberNotUniqueException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.governanceprogram.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.ExternalReference;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceDomain;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.GovernanceOfficer;
import org.odpi.openmetadata.accessservices.governanceprogram.properties.PersonalProfile;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.AppointmentRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceDomainRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceOfficerValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.GovernanceProgramOMASAPIResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalDetailsRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileListResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileResponse;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.PersonalProfileValidatorRequestBody;
import org.odpi.openmetadata.accessservices.governanceprogram.rest.VoidResponse;
import org.springframework.web.client.RestTemplate;

public class GovernanceProgramLeadership
implements GovernanceLeadershipInterface {
    private static final String personalProfileTypeName = "Person";
    private static final String governanceOfficerTypeName = "GovernanceOfficer";
    private String omasServerURL;
    private GovernanceProgramExceptionHandler exceptionHandler;

    public GovernanceProgramLeadership(String newServerURL) {
        this.omasServerURL = newServerURL;
        this.exceptionHandler = new GovernanceProgramExceptionHandler(newServerURL);
    }

    @Override
    public String createPersonalProfile(String userId, String profileUserId, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> additionalProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPersonalProfile";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles";
        String profileUserIdParameterName = "profileUserId";
        String employeeNumberParameterName = "employeeNumber";
        String knownNameParameterName = "knownName";
        this.exceptionHandler.validateOMASServerURL("createPersonalProfile");
        this.exceptionHandler.validateUserId(userId, "createPersonalProfile");
        this.exceptionHandler.validateName(profileUserId, "profileUserId", "createPersonalProfile");
        this.exceptionHandler.validateName(employeeNumber, "employeeNumber", "createPersonalProfile");
        this.exceptionHandler.validateName(knownName, "knownName", "createPersonalProfile");
        PersonalDetailsRequestBody requestBody = new PersonalDetailsRequestBody();
        requestBody.setUserId(profileUserId);
        requestBody.setEmployeeNumber(employeeNumber);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        GUIDResponse restResult = this.callGUIDPostRESTCall("createPersonalProfile", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles", requestBody, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("createPersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createPersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createPersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    @Override
    public void updatePersonalProfile(String userId, String profileGUID, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> additionalProperties) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updatePersonalProfile";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/{1}";
        String guidParameterName = "profileGUID";
        String employeeNumberParameterName = "employeeNumber";
        String knownNameParameterName = "knownName";
        this.exceptionHandler.validateOMASServerURL("updatePersonalProfile");
        this.exceptionHandler.validateUserId(userId, "updatePersonalProfile");
        this.exceptionHandler.validateGUID(profileGUID, "profileGUID", personalProfileTypeName, "updatePersonalProfile");
        this.exceptionHandler.validateName(employeeNumber, "employeeNumber", "updatePersonalProfile");
        this.exceptionHandler.validateName(knownName, "knownName", "updatePersonalProfile");
        PersonalDetailsRequestBody requestBody = new PersonalDetailsRequestBody();
        requestBody.setEmployeeNumber(employeeNumber);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        VoidResponse restResult = this.callVoidPostRESTCall("updatePersonalProfile", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/{1}", requestBody, userId, profileGUID);
        this.exceptionHandler.detectAndThrowUnrecognizedGUIDException("updatePersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowInvalidParameterException("updatePersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updatePersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updatePersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
    }

    @Override
    public void deletePersonalProfile(String userId, String profileGUID, String employeeNumber) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deletePersonalProfile";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/{1}/delete";
        String guidParameterName = "profileGUID";
        String employeeNumberParameterName = "employeeNumber";
        this.exceptionHandler.validateOMASServerURL("deletePersonalProfile");
        this.exceptionHandler.validateUserId(userId, "deletePersonalProfile");
        this.exceptionHandler.validateGUID(profileGUID, "profileGUID", personalProfileTypeName, "deletePersonalProfile");
        this.exceptionHandler.validateName(employeeNumber, "employeeNumber", "deletePersonalProfile");
        PersonalProfileValidatorRequestBody requestBody = new PersonalProfileValidatorRequestBody();
        requestBody.setEmployeeNumber(employeeNumber);
        VoidResponse restResult = this.callVoidPostRESTCall("deletePersonalProfile", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/{1}/delete", requestBody, userId, profileGUID);
        this.exceptionHandler.detectAndThrowUnrecognizedGUIDException("deletePersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowInvalidParameterException("deletePersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deletePersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deletePersonalProfile", (GovernanceProgramOMASAPIResponse)restResult);
    }

    @Override
    public PersonalProfile getPersonalProfileByGUID(String userId, String profileGUID) throws UnrecognizedGUIDException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByGUID";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/{1}";
        String guidParameterName = "profileGUID";
        this.exceptionHandler.validateOMASServerURL("getPersonalProfileByGUID");
        this.exceptionHandler.validateUserId(userId, "getPersonalProfileByGUID");
        this.exceptionHandler.validateGUID(profileGUID, "profileGUID", personalProfileTypeName, "getPersonalProfileByGUID");
        PersonalProfileResponse restResult = this.callPersonalProfileGetRESTCall("getPersonalProfileByGUID", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/{1}", userId, profileGUID);
        this.exceptionHandler.detectAndThrowUnrecognizedGUIDException("getPersonalProfileByGUID", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfileByGUID", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfileByGUID", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getPersonalProfile();
    }

    @Override
    public PersonalProfile getPersonalProfileByEmployeeNumber(String userId, String employeeNumber) throws InvalidParameterException, EmployeeNumberNotUniqueException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfileByEmployeeNumber";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/by-employee-number/{1}";
        String employeeNumberParameterName = "employeeNumber";
        this.exceptionHandler.validateOMASServerURL("getPersonalProfileByEmployeeNumber");
        this.exceptionHandler.validateUserId(userId, "getPersonalProfileByEmployeeNumber");
        this.exceptionHandler.validateName(employeeNumber, "employeeNumber", "getPersonalProfileByEmployeeNumber");
        PersonalProfileResponse restResult = this.callPersonalProfileGetRESTCall("getPersonalProfileByEmployeeNumber", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/by-employee-number/{1}", userId, employeeNumber);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfileByEmployeeNumber", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowEmployeeNumberNotUniqueException("getPersonalProfileByEmployeeNumber", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfileByEmployeeNumber", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfileByEmployeeNumber", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getPersonalProfile();
    }

    @Override
    public List<PersonalProfile> getPersonalProfilesByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getPersonalProfilesByName";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/by-name/{1}";
        String nameParameterName = "name";
        this.exceptionHandler.validateOMASServerURL("getPersonalProfilesByName");
        this.exceptionHandler.validateUserId(userId, "getPersonalProfilesByName");
        this.exceptionHandler.validateName(name, "name", "getPersonalProfilesByName");
        PersonalProfileListResponse restResult = this.callPersonalProfileListGetRESTCall("getPersonalProfilesByName", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/personal-profiles/by-name/{1}", userId, name);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getPersonalProfilesByName", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getPersonalProfilesByName", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getPersonalProfilesByName", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getPersonalProfiles();
    }

    @Override
    public String createGovernanceOfficer(String userId, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, Object> additionalProperties, List<ExternalReference> externalReferences) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createGovernanceOfficer";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers";
        String appointmentIdParameterName = "appointmentId";
        String titleParameterName = "title";
        String governanceDomainParameterName = "governanceDomain";
        this.exceptionHandler.validateOMASServerURL("createGovernanceOfficer");
        this.exceptionHandler.validateUserId(userId, "createGovernanceOfficer");
        this.exceptionHandler.validateName(appointmentId, "appointmentId", "createGovernanceOfficer");
        this.exceptionHandler.validateName(title, "title", "createGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "createGovernanceOfficer");
        GovernanceOfficerDetailsRequestBody requestBody = new GovernanceOfficerDetailsRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        requestBody.setAppointmentContext(appointmentContext);
        requestBody.setTitle(title);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExternalReferences(externalReferences);
        GUIDResponse restResult = this.callGUIDPostRESTCall("createGovernanceOfficer", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers", requestBody, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("createGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    @Override
    public void updateGovernanceOfficer(String userId, String governanceOfficerGUID, GovernanceDomain governanceDomain, String appointmentId, String appointmentContext, String title, Map<String, Object> additionalProperties, List<ExternalReference> externalReferences) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateGovernanceOfficer";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}";
        String guidParameterName = "governanceOfficerGUID";
        String appointmentIdParameterName = "appointmentId";
        String titleParameterName = "title";
        String governanceDomainParameterName = "governanceDomain";
        this.exceptionHandler.validateOMASServerURL("updateGovernanceOfficer");
        this.exceptionHandler.validateUserId(userId, "updateGovernanceOfficer");
        this.exceptionHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", governanceOfficerTypeName, "updateGovernanceOfficer");
        this.exceptionHandler.validateName(appointmentId, "appointmentId", "updateGovernanceOfficer");
        this.exceptionHandler.validateName(title, "title", "updateGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "updateGovernanceOfficer");
        GovernanceOfficerDetailsRequestBody requestBody = new GovernanceOfficerDetailsRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        requestBody.setAppointmentContext(appointmentContext);
        requestBody.setTitle(title);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExternalReferences(externalReferences);
        VoidResponse restResult = this.callVoidPostRESTCall("updateGovernanceOfficer", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}", requestBody, userId, governanceOfficerGUID);
        this.exceptionHandler.detectAndThrowUnrecognizedGUIDException("updateGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
    }

    @Override
    public void deleteGovernanceOfficer(String userId, String governanceOfficerGUID, String appointmentId, GovernanceDomain governanceDomain) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteGovernanceOfficer";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}/delete";
        String guidParameterName = "governanceOfficerGUID";
        String appointmentIdParameterName = "appointmentId";
        String governanceDomainParameterName = "governanceDomain";
        this.exceptionHandler.validateOMASServerURL("deleteGovernanceOfficer");
        this.exceptionHandler.validateUserId(userId, "deleteGovernanceOfficer");
        this.exceptionHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", governanceOfficerTypeName, "deleteGovernanceOfficer");
        this.exceptionHandler.validateName(appointmentId, "appointmentId", "deleteGovernanceOfficer");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "deleteGovernanceOfficer");
        GovernanceOfficerValidatorRequestBody requestBody = new GovernanceOfficerValidatorRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        requestBody.setAppointmentId(appointmentId);
        VoidResponse restResult = this.callVoidPostRESTCall("deleteGovernanceOfficer", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}/delete", requestBody, userId, governanceOfficerGUID);
        this.exceptionHandler.detectAndThrowUnrecognizedGUIDException("deleteGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowInvalidParameterException("deleteGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deleteGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deleteGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
    }

    @Override
    public GovernanceOfficer getGovernanceOfficerByGUID(String userId, String governanceOfficerGUID) throws UnrecognizedGUIDException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByGUID";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}";
        String guidParameterName = "governanceOfficerGUID";
        this.exceptionHandler.validateOMASServerURL("getGovernanceOfficerByGUID");
        this.exceptionHandler.validateUserId(userId, "getGovernanceOfficerByGUID");
        this.exceptionHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", governanceOfficerTypeName, "getGovernanceOfficerByGUID");
        GovernanceOfficerResponse restResult = this.callGovernanceOfficerGetRESTCall("getGovernanceOfficerByGUID", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}", userId, governanceOfficerGUID);
        this.exceptionHandler.detectAndThrowUnrecognizedGUIDException("getGovernanceOfficerByGUID", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficerByGUID", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficerByGUID", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getGovernanceOfficer();
    }

    @Override
    public GovernanceOfficer getGovernanceOfficerByAppointmentId(String userId, String appointmentId) throws InvalidParameterException, AppointmentIdNotUniqueException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficerByAppointmentId";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/by-appointment-id/{1}";
        String appointmentIdParameterName = "appointmentId";
        this.exceptionHandler.validateOMASServerURL("getGovernanceOfficerByAppointmentId");
        this.exceptionHandler.validateUserId(userId, "getGovernanceOfficerByAppointmentId");
        this.exceptionHandler.validateName(appointmentId, "appointmentId", "getGovernanceOfficerByAppointmentId");
        GovernanceOfficerResponse restResult = this.callGovernanceOfficerGetRESTCall("getGovernanceOfficerByAppointmentId", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/by-appointment-id/{1}", userId, appointmentId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceOfficerByAppointmentId", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowAppointmentIdNotUniqueException("getGovernanceOfficerByAppointmentId", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficerByAppointmentId", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficerByAppointmentId", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getGovernanceOfficer();
    }

    @Override
    public List<GovernanceOfficer> getGovernanceOfficers(String userId) throws PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficers";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers";
        this.exceptionHandler.validateOMASServerURL("getGovernanceOfficers");
        this.exceptionHandler.validateUserId(userId, "getGovernanceOfficers");
        GovernanceOfficerListResponse restResult = this.callGovernanceOfficerListGetRESTCall("getGovernanceOfficers", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers", userId);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficers", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficers", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getGovernanceOfficers();
    }

    @Override
    public List<GovernanceOfficer> getActiveGovernanceOfficers(String userId) throws PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficers";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/active";
        this.exceptionHandler.validateOMASServerURL("getGovernanceOfficers");
        this.exceptionHandler.validateUserId(userId, "getGovernanceOfficers");
        GovernanceOfficerListResponse restResult = this.callGovernanceOfficerListGetRESTCall("getGovernanceOfficers", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/active", userId);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficers", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficers", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getGovernanceOfficers();
    }

    @Override
    public List<GovernanceOfficer> getGovernanceOfficersByDomain(String userId, GovernanceDomain governanceDomain) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getGovernanceOfficersByDomain";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/by-domain";
        String governanceDomainParameterName = "governanceDomain";
        this.exceptionHandler.validateOMASServerURL("getGovernanceOfficersByDomain");
        this.exceptionHandler.validateUserId(userId, "getGovernanceOfficersByDomain");
        this.exceptionHandler.validateGovernanceDomain(governanceDomain, "governanceDomain", "getGovernanceOfficersByDomain");
        GovernanceDomainRequestBody requestBody = new GovernanceDomainRequestBody();
        requestBody.setGovernanceDomain(governanceDomain);
        GovernanceOfficerListResponse restResult = this.callGovernanceOfficerListPostRESTCall("getGovernanceOfficersByDomain", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/by-domain", requestBody, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getGovernanceOfficersByDomain", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getGovernanceOfficersByDomain", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getGovernanceOfficersByDomain", (GovernanceProgramOMASAPIResponse)restResult);
        return restResult.getGovernanceOfficers();
    }

    @Override
    public void appointGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date startDate) throws UnrecognizedGUIDException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "appointGovernanceOfficer";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}/appoint";
        String governanceOfficerGUIDParameterName = "governanceOfficerGUID";
        String profileGUIDParameterName = "profileGUID";
        this.exceptionHandler.validateOMASServerURL("appointGovernanceOfficer");
        this.exceptionHandler.validateUserId(userId, "appointGovernanceOfficer");
        this.exceptionHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", governanceOfficerTypeName, "appointGovernanceOfficer");
        this.exceptionHandler.validateGUID(profileGUID, "profileGUID", personalProfileTypeName, "appointGovernanceOfficer");
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setGUID(profileGUID);
        requestBody.setEffectiveDate(startDate);
        VoidResponse restResult = this.callVoidPostRESTCall("appointGovernanceOfficer", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}/appoint", requestBody, userId, governanceOfficerGUID);
        this.exceptionHandler.detectAndThrowUnrecognizedGUIDException("appointGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("appointGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("appointGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
    }

    @Override
    public void relieveGovernanceOfficer(String userId, String governanceOfficerGUID, String profileGUID, Date endDate) throws UnrecognizedGUIDException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "relieveGovernanceOfficer";
        String urlTemplate = "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}/relieve";
        String governanceOfficerGUIDParameterName = "governanceOfficerGUID";
        String profileGUIDParameterName = "profileGUID";
        this.exceptionHandler.validateOMASServerURL("relieveGovernanceOfficer");
        this.exceptionHandler.validateUserId(userId, "relieveGovernanceOfficer");
        this.exceptionHandler.validateGUID(governanceOfficerGUID, "governanceOfficerGUID", governanceOfficerTypeName, "relieveGovernanceOfficer");
        this.exceptionHandler.validateGUID(profileGUID, "profileGUID", personalProfileTypeName, "relieveGovernanceOfficer");
        AppointmentRequestBody requestBody = new AppointmentRequestBody();
        requestBody.setGUID(profileGUID);
        requestBody.setEffectiveDate(endDate);
        VoidResponse restResult = this.callVoidPostRESTCall("relieveGovernanceOfficer", this.omasServerURL + "/open-metadata/access-services/governance-program/users/{0}/leadership/governance-officers/{1}/relieve", requestBody, userId, governanceOfficerGUID);
        this.exceptionHandler.detectAndThrowUnrecognizedGUIDException("relieveGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowInvalidParameterException("relieveGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("relieveGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("relieveGovernanceOfficer", (GovernanceProgramOMASAPIResponse)restResult);
    }

    private VoidResponse callVoidPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        VoidResponse restResult = new VoidResponse();
        try {
            RestTemplate restTemplate = new RestTemplate();
            restResult = (VoidResponse)restTemplate.postForObject(urlTemplate, requestBody, restResult.getClass(), params);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleRESTRequestFailure(methodName, error);
        }
        return restResult;
    }

    private GUIDResponse callGUIDPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        GUIDResponse restResult = new GUIDResponse();
        try {
            RestTemplate restTemplate = new RestTemplate();
            restResult = (GUIDResponse)restTemplate.postForObject(urlTemplate, requestBody, restResult.getClass(), params);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleRESTRequestFailure(methodName, error);
        }
        return restResult;
    }

    private GovernanceOfficerListResponse callGovernanceOfficerListPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        GovernanceOfficerListResponse restResult = new GovernanceOfficerListResponse();
        try {
            RestTemplate restTemplate = new RestTemplate();
            restResult = (GovernanceOfficerListResponse)restTemplate.postForObject(urlTemplate, requestBody, restResult.getClass(), params);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleRESTRequestFailure(methodName, error);
        }
        return restResult;
    }

    private PersonalProfileResponse callPersonalProfileGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        PersonalProfileResponse restResult = new PersonalProfileResponse();
        try {
            RestTemplate restTemplate = new RestTemplate();
            restResult = (PersonalProfileResponse)restTemplate.getForObject(urlTemplate, restResult.getClass(), params);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleRESTRequestFailure(methodName, error);
        }
        return restResult;
    }

    private PersonalProfileListResponse callPersonalProfileListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        PersonalProfileListResponse restResult = new PersonalProfileListResponse();
        try {
            RestTemplate restTemplate = new RestTemplate();
            restResult = (PersonalProfileListResponse)restTemplate.getForObject(urlTemplate, restResult.getClass(), params);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleRESTRequestFailure(methodName, error);
        }
        return restResult;
    }

    private GovernanceOfficerResponse callGovernanceOfficerGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        GovernanceOfficerResponse restResult = new GovernanceOfficerResponse();
        try {
            RestTemplate restTemplate = new RestTemplate();
            restResult = (GovernanceOfficerResponse)restTemplate.getForObject(urlTemplate, restResult.getClass(), params);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleRESTRequestFailure(methodName, error);
        }
        return restResult;
    }

    private GovernanceOfficerListResponse callGovernanceOfficerListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        GovernanceOfficerListResponse restResult = new GovernanceOfficerListResponse();
        try {
            RestTemplate restTemplate = new RestTemplate();
            restResult = (GovernanceOfficerListResponse)restTemplate.getForObject(urlTemplate, restResult.getClass(), params);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleRESTRequestFailure(methodName, error);
        }
        return restResult;
    }
}

